/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.BinaryStream;
import com.caucho.quercus.lib.file.WrappedDirectoryValue;
import com.caucho.quercus.lib.file.WrappedStream;
import com.caucho.quercus.program.AbstractFunction;

public class ProtocolWrapper {
    private QuercusClass _qClass;

    protected ProtocolWrapper() {
    }

    public ProtocolWrapper(QuercusClass qClass) {
        this._qClass = qClass;
    }

    public BinaryStream fopen(Env env, StringValue path, StringValue mode, LongValue options) {
        return new WrappedStream(env, this._qClass, path, mode, options);
    }

    public Value opendir(Env env, StringValue path, LongValue flags) {
        WrappedDirectoryValue value = new WrappedDirectoryValue(env, this._qClass);
        if (!value.opendir(path, flags)) {
            return BooleanValue.FALSE;
        }
        return value;
    }

    public boolean unlink(Env env, StringValue path) {
        AbstractFunction function = this._qClass.getStaticFunction("unlink");
        if (function == null) {
            return false;
        }
        return function.call(env, path).toBoolean();
    }

    public boolean rename(Env env, StringValue path_from, StringValue path_to) {
        AbstractFunction function = this._qClass.getStaticFunction("rename");
        if (function == null) {
            return false;
        }
        return function.call(env, path_from, path_to).toBoolean();
    }

    public boolean mkdir(Env env, StringValue path, LongValue mode, LongValue options) {
        AbstractFunction function = this._qClass.getStaticFunction("mkdir");
        if (function == null) {
            return false;
        }
        return function.call(env, path, mode, options).toBoolean();
    }

    public boolean rmdir(Env env, StringValue path, LongValue options) {
        AbstractFunction function = this._qClass.getStaticFunction("rmdir");
        if (function == null) {
            return false;
        }
        return function.call(env, path, options).toBoolean();
    }

    public Value url_stat(Env env, StringValue path, LongValue flags) {
        AbstractFunction function = this._qClass.getStaticFunction("url_stat");
        if (function == null) {
            return BooleanValue.FALSE;
        }
        return function.call(env, path, flags);
    }
}

