/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.regexp.IllegalRegexpException;
import com.caucho.quercus.lib.regexp.PeekString;
import com.caucho.quercus.lib.regexp.Regcomp;
import com.caucho.quercus.lib.regexp.RegexpNode;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.Map;
import java.util.logging.Logger;

public class Regexp {
    private static final Logger log = Logger.getLogger(Regexp.class.getName());
    private static final L10N L = new L10N(Regexp.class);
    public static final int FAIL = -1;
    public static final int SUCCESS = 0;
    StringValue _pattern;
    RegexpNode _prog;
    boolean _ignoreCase;
    boolean _isGlobal;
    int _nLoop;
    int _nGroup;
    CharBuffer _prefix;
    int _minLength;
    int _firstChar;
    boolean[] _firstSet;
    StringValue[] _groupNames;
    boolean _isUnicode;
    boolean _isPHP5String;
    boolean _isUTF8;
    boolean _isEval;

    public Regexp(Env env, StringValue rawRegexp) throws IllegalRegexpException {
        int head;
        if (rawRegexp.length() < 2) {
            throw new IllegalStateException(L.l("Can't find delimiters in regexp '{0}'.", (Object)rawRegexp));
        }
        char delim = '/';
        for (head = 0; head < rawRegexp.length(); ++head) {
            char c = rawRegexp.charAt(head);
            delim = c;
            if (!Character.isWhitespace(c)) break;
        }
        if (delim == '{') {
            delim = '}';
        } else if (delim == '[') {
            delim = ']';
        } else if (delim == '(') {
            delim = ')';
        } else if (delim == '<') {
            delim = '>';
        } else if (delim == '\\' || Character.isLetterOrDigit(delim)) {
            throw new QuercusException(L.l("Delimiter {0} in regexp '{1}' must not be backslash or alphanumeric.", (Object)String.valueOf(delim), (Object)rawRegexp));
        }
        int tail = rawRegexp.lastIndexOf(delim);
        if (tail <= 0) {
            throw new QuercusException(L.l("Can't find second {0} in regexp '{1}'.", (Object)String.valueOf(delim), (Object)rawRegexp));
        }
        StringValue sflags = rawRegexp.substring(tail);
        StringValue pattern = rawRegexp.substring(head + 1, tail);
        int flags = 0;
        block14: for (int i = 0; sflags != null && i < sflags.length(); ++i) {
            switch (sflags.charAt(i)) {
                case 'm': {
                    flags |= 1;
                    continue block14;
                }
                case 's': {
                    flags |= 2;
                    continue block14;
                }
                case 'i': {
                    flags |= 4;
                    continue block14;
                }
                case 'x': {
                    flags |= 8;
                    continue block14;
                }
                case 'g': {
                    flags |= 0x10;
                    continue block14;
                }
                case 'A': {
                    flags |= 0x20;
                    continue block14;
                }
                case 'D': {
                    flags |= 0x40;
                    continue block14;
                }
                case 'U': {
                    flags |= 0x80;
                    continue block14;
                }
                case 'X': {
                    flags |= 0x100;
                    continue block14;
                }
                case 'u': {
                    this._isUTF8 = true;
                    continue block14;
                }
                case 'e': {
                    this._isEval = true;
                }
            }
        }
        if (this._isUTF8) {
            pattern = Regexp.fromUtf8(env, pattern);
        }
        this._pattern = pattern;
        Regcomp comp = new Regcomp(flags);
        this._prog = comp.parse(new PeekString(this._pattern));
        this.compile(env, this._prog, comp);
    }

    protected Regexp(Env env, RegexpNode prog, Regcomp comp) {
        this._prog = prog;
        this.compile(env, this._prog, comp);
    }

    private Regexp() {
    }

    public StringValue getPattern() {
        return this._pattern;
    }

    public boolean isUTF8() {
        return this._isUTF8;
    }

    public boolean isEval() {
        return this._isEval;
    }

    public StringValue convertSubject(Env env, StringValue subject) {
        if (this._isUTF8) {
            return Regexp.fromUtf8(env, subject);
        }
        return subject;
    }

    public StringValue convertResult(Env env, StringValue result) {
        if (this._isUTF8) {
            return Regexp.toUtf8(env, result);
        }
        return result;
    }

    private void compile(Env env, RegexpNode prog, Regcomp comp) {
        this._ignoreCase = (comp._flags & 4) != 0;
        this._isGlobal = (comp._flags & 0x10) != 0;
        this._minLength = prog.minLength();
        this._firstChar = prog.firstChar();
        this._firstSet = prog.firstSet(new boolean[256]);
        this._prefix = new CharBuffer(prog.prefix());
        this._nGroup = comp._maxGroup;
        this._nLoop = comp._nLoop;
        this._groupNames = new StringValue[this._nGroup + 1];
        for (Map.Entry<Integer, StringValue> entry : comp._groupNameMap.entrySet()) {
            StringValue groupName = entry.getValue();
            if (!this._isUnicode) {
                if (this._isUTF8) {
                    groupName.toBinaryValue(env, "UTF-8");
                } else {
                    groupName.toBinaryValue(env);
                }
            }
            this._groupNames[entry.getKey().intValue()] = groupName;
        }
    }

    public StringValue getGroupName(int i) {
        return this._groupNames[i];
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public boolean ignoreCase() {
        return this._ignoreCase;
    }

    static StringValue fromUtf8(Env env, StringValue source) {
        StringValue target = env.createUnicodeBuilder();
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char ch2;
            char ch = source.charAt(i);
            if (ch < '\u0080') {
                target.append(ch);
                continue;
            }
            if ((ch & 0xE0) == 192) {
                if (i + 1 >= len) {
                    throw new QuercusRuntimeException("bad UTF-8 sequence, saw EOF");
                }
                ch2 = source.charAt(++i);
                target.append((char)(((ch & 0x1F) << 6) + (ch2 & 0x3F)));
                continue;
            }
            if (i + 2 >= len) {
                throw new QuercusRuntimeException("bad UTF-8 sequence, saw EOF");
            }
            ch2 = source.charAt(++i);
            char ch3 = source.charAt(++i);
            target.append((char)(((ch & 0xF) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F)));
        }
        return target;
    }

    static StringValue toUtf8(Env env, StringValue source) {
        StringValue target = env.createBinaryBuilder();
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char ch = source.charAt(i);
            if (ch < '\u0080') {
                target.append(ch);
                continue;
            }
            if (ch < '\u0800') {
                target.append((char)(0xC0 | ch >> 6));
                target.append((char)(0x80 | ch & 0x3F));
                continue;
            }
            target.append((char)(0xE0 | ch >> 12));
            target.append((char)(0x80 | ch >> 6 & 0x3F));
            target.append((char)(0x80 | ch & 0x3F));
        }
        return target;
    }

    public String toString() {
        return "Regexp[" + this._pattern + "]";
    }
}

