/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.program;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.expr.VarInfo;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionInfo {
    private final Quercus _quercus;
    private final String _name;
    private final HashMap<String, VarInfo> _varMap = new HashMap();
    private final ArrayList<String> _tempVarList = new ArrayList();
    private ClassDef _classDef;
    private Function _fun;
    private boolean _hasThis;
    private boolean _isGlobal;
    private boolean _isPageMain;
    private boolean _isPageStatic;
    private boolean _isReturnsReference;
    private boolean _isVariableVar;
    private boolean _isOutUsed;
    private boolean _isVariableArgs;
    private boolean _isUsesSymbolTable;
    private boolean _isReadOnly = true;

    public FunctionInfo(Quercus quercus, String name) {
        this._quercus = quercus;
        this._name = name;
    }

    public FunctionInfo copy() {
        FunctionInfo copy = this.createCopy();
        copy._varMap.putAll(this._varMap);
        copy._tempVarList.addAll(this._tempVarList);
        copy._classDef = this._classDef;
        copy._fun = this._fun;
        copy._hasThis = this._hasThis;
        copy._isGlobal = this._isGlobal;
        copy._isPageMain = this._isPageMain;
        copy._isPageStatic = this._isPageStatic;
        copy._isReturnsReference = this._isReturnsReference;
        copy._isVariableVar = this._isVariableVar;
        copy._isOutUsed = this._isOutUsed;
        copy._isVariableArgs = this._isVariableArgs;
        copy._isUsesSymbolTable = this._isUsesSymbolTable;
        copy._isReadOnly = this._isReadOnly;
        return copy;
    }

    protected FunctionInfo createCopy() {
        return new FunctionInfo(this._quercus, this._name);
    }

    public Quercus getQuercus() {
        return this._quercus;
    }

    public String getName() {
        return this._name;
    }

    public void setFunction(Function fun) {
        this._fun = fun;
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        this._isGlobal = isGlobal;
    }

    public boolean isFinal() {
        return this._fun.isFinal();
    }

    public boolean isPageMain() {
        return this._isPageMain;
    }

    public void setPageMain(boolean isPageMain) {
        this._isPageMain = isPageMain;
    }

    public boolean isPageStatic() {
        return this._isPageStatic;
    }

    public void setPageStatic(boolean isPageStatic) {
        this._isPageStatic = isPageStatic;
    }

    public void setHasThis(boolean hasThis) {
        this._hasThis = hasThis;
    }

    public boolean hasThis() {
        return this._hasThis || this._classDef != null && !this._fun.isStatic();
    }

    public void setDeclaringClass(ClassDef classDef) {
        this._classDef = classDef;
    }

    public ClassDef getDeclaringClass() {
        return this._classDef;
    }

    public boolean isMethod() {
        return this._classDef != null && !this._fun.isStatic();
    }

    public boolean isReturnsReference() {
        return this._isReturnsReference;
    }

    public void setReturnsReference(boolean isReturnsReference) {
        this._isReturnsReference = isReturnsReference;
    }

    public boolean isVariableVar() {
        return this._isVariableVar;
    }

    public void setVariableVar(boolean isVariableVar) {
        this._isVariableVar = isVariableVar;
    }

    public boolean isVariableArgs() {
        return this._isVariableArgs;
    }

    public void setVariableArgs(boolean isVariableArgs) {
        this._isVariableArgs = isVariableArgs;
    }

    public boolean isUsesSymbolTable() {
        return this._isUsesSymbolTable;
    }

    public void setUsesSymbolTable(boolean isUsesSymbolTable) {
        this._isUsesSymbolTable = isUsesSymbolTable;
    }

    public boolean isOutUsed() {
        return this._isOutUsed;
    }

    public void setOutUsed() {
        this._isOutUsed = true;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setModified() {
        this._isReadOnly = false;
    }

    public VarInfo createVar(String name) {
        VarInfo var = this._varMap.get(name);
        if (var == null) {
            var = this.createVarInfo(name);
            if (this._isGlobal) {
                var.setGlobal();
            }
            if (Quercus.isSuperGlobal(name)) {
                var.setGlobal();
            }
            this._varMap.put(name, var);
        }
        return var;
    }

    protected VarInfo createVarInfo(String name) {
        return new VarInfo(name, this);
    }

    public Collection<VarInfo> getVariables() {
        return this._varMap.values();
    }

    public void addTempVar(String name) {
        if (!this._tempVarList.contains(name)) {
            this._tempVarList.add(name);
        }
    }

    public Collection<String> getTempVariables() {
        return this._tempVarList;
    }

    public int getTempIndex() {
        return this._tempVarList.size();
    }

    public String toString() {
        return "FunctionInfo[" + this._name + "]";
    }
}

