/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class AbstractMappingStrategy
implements MappingStrategy {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static final String[] DEFAULT_SCRIPT_PATH = new String[]{"agi"};
    private ClassLoader defaultClassLoader = null;

    @Override
    public AgiScript determineScript(AgiRequest request, AgiChannel channel) {
        return this.determineScript(request);
    }

    public abstract AgiScript determineScript(AgiRequest var1);

    protected synchronized ClassLoader getClassLoader() {
        if (this.defaultClassLoader == null) {
            ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
            ArrayList<URL> dirUrls = new ArrayList<URL>();
            for (String scriptPathEntry : DEFAULT_SCRIPT_PATH) {
                File scriptDir = new File(scriptPathEntry);
                if (!scriptDir.isDirectory()) continue;
                try {
                    dirUrls.add(scriptDir.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (dirUrls.isEmpty()) {
                return parentClassLoader;
            }
            this.defaultClassLoader = new URLClassLoader(dirUrls.toArray(new URL[dirUrls.size()]), parentClassLoader);
        }
        return this.defaultClassLoader;
    }

    protected AgiScript createAgiScriptInstance(String className) {
        Class<?> tmpClass;
        AgiScript agiScript = null;
        try {
            tmpClass = this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e1) {
            this.logger.debug("Unable to create AgiScript instance of type " + className + ": Class not found, make sure the class exists and is available on the CLASSPATH");
            return null;
        }
        if (!AgiScript.class.isAssignableFrom(tmpClass)) {
            this.logger.warn("Unable to create AgiScript instance of type " + className + ": Class does not implement the AgiScript interface");
            return null;
        }
        Class<?> agiScriptClass = tmpClass;
        try {
            Constructor<?> constructor = agiScriptClass.getConstructor(new Class[0]);
            agiScript = (AgiScript)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.warn("Unable to create AgiScript instance of type " + className, e);
        }
        return agiScript;
    }
}

