/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ChannelFactory;
import org.asteriskjava.pbx.ChannelHangupListener;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.InvalidChannelName;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.TechType;
import org.asteriskjava.pbx.internal.core.ChannelProxy;
import org.asteriskjava.pbx.internal.core.CoherentManagerConnection;
import org.asteriskjava.pbx.internal.core.EndPointImpl;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class ChannelImpl
implements Channel {
    public static final String ZOMBIE = "<ZOMBIE>";
    public static final String MASQ = "<MASQ>";
    public static final String UNKNOWN_UNIQUE_ID = "-1";
    private static final Log logger = LogFactory.getLog(ChannelImpl.class);
    private static int logCounter = 100;
    private String _channelName;
    private String _uniqueID;
    private EndPoint _endPoint;
    private CallerID _callerID;
    private long _channelId;
    private boolean _muted = false;
    private boolean _parked = false;
    private volatile boolean _isZombie = false;
    private boolean _isLive = true;
    private volatile boolean _isMasqueraded = false;
    private volatile boolean _isInAction = false;
    private boolean _isConsole = false;
    private String _actionPrefix = null;
    public static final String[] _actions = new String[]{"PARKED/", "ASYNCGOTO/", "BRIDGE/"};
    private ChannelHangupListener hangupListener;
    private Long _sweepStartTime = null;
    private boolean _marked = false;

    ChannelImpl(String channelName, String uniqueID) throws InvalidChannelName {
        if (uniqueID == null) {
            throw new IllegalArgumentException("The UniqueID may not be null.");
        }
        if (channelName == null) {
            throw new IllegalArgumentException("The channelName may not be null.");
        }
        if (uniqueID.compareToIgnoreCase(UNKNOWN_UNIQUE_ID) == 0) {
            logger.debug("uniqueID is -1");
        }
        this._uniqueID = uniqueID;
        this.setChannelName(channelName);
    }

    public void masquerade(Channel channel) {
        if (channel.hasCallerID()) {
            this._callerID = channel.getCallerID();
        } else if (this._callerID != null && ((ChannelImpl)channel)._callerID != null) {
            PBX pbx = PBXFactory.getActivePBX();
            if (this._callerID != null) {
                ((ChannelImpl)channel)._callerID = pbx.buildCallerID(this._callerID.getNumber(), this._callerID.getName());
            }
        }
        this._muted = channel.isMute();
        this._parked = channel.isParked();
        this._marked = true;
        this._sweepStartTime = null;
    }

    private void setChannelName(String channelName) throws InvalidChannelName {
        logger.debug("Renamed channel from " + this._channelName + " to " + channelName);
        this._channelName = this.cleanChannelName(channelName);
        this.validateChannelName(this._channelName);
        this._channelId = ChannelFactory.getNextChannelId();
        this._endPoint = new EndPointImpl(this.extractPeerName(this._channelName));
        if (this._channelName.compareTo(this.getEndPoint().getFullyQualifiedName()) == 0 && !this._isConsole) {
            if (logCounter > 0) {
                logger.warn("Invalid channel name " + this._channelName);
                --logCounter;
            } else if (logCounter == 0) {
                logger.warn("Further Invalid channel name warnings suppressed");
                --logCounter;
            }
        }
    }

    private void validateChannelName(String channelName) throws InvalidChannelName {
        if (!this._isConsole) {
            if (!TechType.hasValidTech(channelName)) {
                throw new InvalidChannelName("Invalid channelName: " + channelName + ". Unknown tech.");
            }
            int hypen = channelName.indexOf("-");
            if (hypen == -1) {
                throw new InvalidChannelName("Invalid channelName: " + channelName + ". Missing hypen.");
            }
            int slash = channelName.indexOf("/");
            if (slash == -1) {
                throw new InvalidChannelName("Invalid channelName: " + channelName + ". Missing slash.");
            }
            if (hypen < slash) {
                throw new InvalidChannelName("Invalid channelName: " + channelName + ". Hypen must be after the slash.");
            }
            if (hypen - slash < 2) {
                throw new InvalidChannelName("Invalid channelName: " + channelName + ". Must be one character between the hypen and the slash.");
            }
            if (channelName.length() - hypen < 2) {
                throw new InvalidChannelName("Invalid channelName: " + channelName + ". The channel sequence number must be at least 1 character.");
            }
        }
    }

    private String cleanChannelName(String name) {
        String cleanedName = name.trim().toUpperCase();
        this._isConsole = false;
        if (name.compareToIgnoreCase("Console/dsp") == 0) {
            this._isConsole = true;
        }
        boolean wasInAction = this._isInAction;
        this._isInAction = false;
        for (String prefix : _actions) {
            if (!cleanedName.startsWith(prefix)) continue;
            this._isInAction = true;
            this._actionPrefix = cleanedName.substring(0, prefix.length() - 1);
            cleanedName = cleanedName.substring(prefix.length());
            break;
        }
        if (wasInAction != this._isInAction) {
            logger.debug("Channel " + this + " : inaction status changed from " + wasInAction + " to " + this._isInAction);
        }
        this._isZombie = false;
        if (cleanedName.contains(ZOMBIE)) {
            this._isZombie = true;
            cleanedName = cleanedName.substring(0, cleanedName.indexOf(ZOMBIE));
        }
        this._isMasqueraded = false;
        if (cleanedName.contains(MASQ)) {
            this._isMasqueraded = true;
            cleanedName = cleanedName.substring(0, cleanedName.indexOf(MASQ));
        }
        return cleanedName;
    }

    @Override
    public void rename(String newName, String uniqueId) throws InvalidChannelName {
        String oldChannelName = this.getChannelName();
        logger.info("Changing " + oldChannelName + " to " + newName + " on " + oldChannelName + " " + this._uniqueID);
        this.setChannelName(newName);
        if (this._uniqueID.equalsIgnoreCase(UNKNOWN_UNIQUE_ID)) {
            logger.info("Changing " + this._uniqueID + " to " + uniqueId + " on " + oldChannelName + " " + this._uniqueID);
            this._uniqueID = uniqueId;
        }
        this._isInAction = false;
    }

    @Override
    public String getChannelName() {
        return this._channelName;
    }

    @Override
    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    private final String extractPeerName(String channelName) {
        int channelNameEndPoint = channelName.lastIndexOf("-");
        if (channelNameEndPoint == -1) {
            channelNameEndPoint = channelName.length();
        }
        return channelName.substring(0, channelNameEndPoint);
    }

    boolean wasMarkedDuringSweep() {
        boolean ret = false;
        if (this._sweepStartTime == null || this._marked) {
            this._sweepStartTime = null;
            ret = true;
        }
        return ret;
    }

    @Override
    public void setCallerId(CallerID callerId) {
        this._callerID = callerId;
    }

    void startSweep() {
        this._sweepStartTime = new Date().getTime();
        this._marked = false;
    }

    void markChannel() {
        this._marked = true;
    }

    @Override
    public boolean isSame(Channel _rhs) {
        boolean equals = false;
        if (_rhs == null) {
            logger.warn("isSame called with null");
            return false;
        }
        ChannelImpl rhs = _rhs instanceof ChannelImpl ? (ChannelImpl)_rhs : ((ChannelProxy)_rhs).getRealChannel();
        if (this._uniqueID.compareTo(UNKNOWN_UNIQUE_ID) != 0 && rhs._uniqueID.compareTo(UNKNOWN_UNIQUE_ID) != 0) {
            if (this._uniqueID.compareToIgnoreCase(rhs._uniqueID) == 0) {
                equals = true;
            }
        } else {
            boolean namesMatch;
            boolean ok = this._channelName != null && rhs._channelName != null;
            boolean bl = namesMatch = ok && this._channelName.compareToIgnoreCase(rhs._channelName) == 0;
            if (namesMatch) {
                if (this._isInAction != rhs._isInAction) {
                    ok = false;
                } else if (this._isInAction) {
                    boolean bl2 = ok = this._actionPrefix.compareTo(rhs._actionPrefix) == 0;
                }
            }
            if (ok && namesMatch && this._isZombie != rhs._isZombie) {
                ok = false;
            }
            if (ok && namesMatch && this._isMasqueraded != rhs._isMasqueraded) {
                ok = false;
            }
            equals = ok & namesMatch;
        }
        return equals;
    }

    @Override
    public boolean isSame(String extendedChannelName, String uniqueID) {
        boolean equals = false;
        if (this._uniqueID.compareTo(UNKNOWN_UNIQUE_ID) != 0 && uniqueID.compareTo(UNKNOWN_UNIQUE_ID) != 0) {
            if (this._uniqueID.compareTo(uniqueID) == 0) {
                equals = true;
            }
        } else {
            equals = this.sameExtenededChannelName(extendedChannelName);
        }
        return equals;
    }

    @Override
    public boolean sameExtenededChannelName(String extendedChannelName) {
        boolean ok = this.getExtendedChannelName() != null && extendedChannelName != null;
        return ok && this.getExtendedChannelName().compareToIgnoreCase(extendedChannelName) == 0;
    }

    public boolean sameUniqueID(String uniqueID) {
        boolean equals = false;
        if (this._uniqueID.compareTo(UNKNOWN_UNIQUE_ID) != 0 && uniqueID.compareTo(UNKNOWN_UNIQUE_ID) != 0 && this._uniqueID.compareTo(uniqueID) == 0) {
            equals = true;
        }
        return equals;
    }

    @Override
    public boolean sameEndPoint(Channel rhs) {
        return this.sameEndPoint(rhs.getEndPoint());
    }

    @Override
    public boolean sameEndPoint(EndPoint rhs) {
        boolean ok = this._endPoint != null && rhs != null;
        return ok && this._endPoint.isSame(rhs);
    }

    @Override
    public long getChannelId() {
        return this._channelId;
    }

    @Override
    public boolean isLive() {
        return this._isLive;
    }

    @Override
    public void addHangupListener(ChannelHangupListener listener) {
        if (this.hangupListener != null) {
            throw new IllegalStateException("This channel may only have ONE listener which should be its ChannelProxy");
        }
        this.hangupListener = listener;
    }

    @Override
    public void removeListener(ChannelHangupListener listener) {
        if (this.hangupListener != listener) {
            throw new IllegalStateException("An invalid attempt was made to remove a non-existant listener.");
        }
        this.hangupListener = null;
    }

    @Override
    public void notifyHangupListeners(Integer cause, String causeText) {
        this._isLive = false;
        if (this.hangupListener != null) {
            this.hangupListener.channelHangup(this, cause, causeText);
        } else {
            logger.warn("Hangup listener is null");
        }
    }

    @Override
    public boolean isConnectedTo(EndPoint endPoint) {
        return this._endPoint.isSame(endPoint);
    }

    @Override
    public boolean isMute() {
        return this._muted;
    }

    @Override
    public void setMute(boolean mutedState) {
        this._muted = mutedState;
    }

    @Override
    public void setParked(boolean parked) {
        this._parked = parked;
    }

    @Override
    public boolean isParked() {
        return this._parked;
    }

    public String toString() {
        return this.getExtendedChannelName() + ":" + this._uniqueID;
    }

    @Override
    public String getExtendedChannelName() {
        StringBuilder name = new StringBuilder();
        if (this._isInAction) {
            name.append(this._actionPrefix);
            name.append("/");
        }
        name.append(this._channelName);
        if (this._isMasqueraded) {
            name.append(MASQ);
        }
        if (this._isZombie) {
            name.append(ZOMBIE);
        }
        return name.toString();
    }

    @Override
    public boolean isLocal() {
        return this._endPoint.isLocal();
    }

    @Override
    public boolean isZombie() {
        return this._isZombie;
    }

    @Override
    public boolean isConsole() {
        return this._isConsole;
    }

    TechType getTech() {
        return this._endPoint.getTech();
    }

    String getActionPrefix() {
        return this._isInAction ? this._actionPrefix : "";
    }

    boolean isInAction() {
        return this._isInAction;
    }

    boolean isMasqueraded() {
        return this._isMasqueraded;
    }

    @Override
    public boolean hasCallerID() {
        return this._callerID != null && !this._callerID.isUnknown();
    }

    @Override
    public CallerID getCallerID() {
        if (this._callerID == null) {
            CoherentManagerConnection smc = CoherentManagerConnection.getInstance();
            String number = smc.getVariable(this, "CALLERID(number)");
            String name = smc.getVariable(this, "CALLERID(name)");
            PBX pbx = PBXFactory.getActivePBX();
            this._callerID = pbx.buildCallerID(number, name);
        }
        return this._callerID;
    }

    @Override
    public String getUniqueId() {
        return this._uniqueID;
    }

    @Override
    public boolean canDetectHangup() {
        boolean canDetectHangup = true;
        AsteriskSettings profile = PBXFactory.getActiveProfile();
        boolean detect = profile.getCanDetectHangup();
        if (!this.getEndPoint().isSIP() && !detect) {
            canDetectHangup = false;
        }
        return canDetectHangup;
    }

    @Override
    public boolean isQuiescent() {
        return !this._isInAction && !this._isMasqueraded && !this._isZombie;
    }

    @Override
    public AgiChannelActivityAction getCurrentActivityAction() {
        throw new RuntimeException("This method is only implemented in ChannelProxy");
    }

    @Override
    public void setCurrentActivityAction(AgiChannelActivityAction action) {
        throw new RuntimeException("This method is only implemented in ChannelProxy");
    }

    @Override
    public void setIsInAgi(boolean b) {
        throw new RuntimeException("This method is only implemented in ChannelProxy");
    }

    @Override
    public boolean isInAgi() {
        throw new RuntimeException("This method is only implemented in ChannelProxy");
    }

    @Override
    public boolean waitForChannelToReachAgi(long timeout, TimeUnit timeunit) throws InterruptedException {
        throw new RuntimeException("This method is only implemented in ChannelProxy");
    }
}

