/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.alignment.matrices;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.template.CompoundSet;

public class ScaledSubstitutionMatrix
implements SubstitutionMatrix<AminoAcidCompound> {
    private static final String comment = "#";
    private String description;
    private String name;
    private short[][] matrix;
    private short max;
    private short min;
    private AminoAcidCompoundSet compoundSet = AminoAcidCompoundSet.getAminoAcidCompoundSet();
    private List<AminoAcidCompound> rows;
    private List<AminoAcidCompound> cols;
    private int scale;

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public short[][] getMatrix() {
        return this.matrix;
    }

    public void setMatrix(short[][] matrix) {
        this.matrix = matrix;
    }

    public short getMax() {
        return this.max;
    }

    public void setMax(short max) {
        this.max = max;
    }

    public short getMin() {
        return this.min;
    }

    public void setMin(short min) {
        this.min = min;
    }

    public List<AminoAcidCompound> getRows() {
        return this.rows;
    }

    public void setRows(List<AminoAcidCompound> rows) {
        this.rows = rows;
    }

    public List<AminoAcidCompound> getCols() {
        return this.cols;
    }

    public void setCols(List<AminoAcidCompound> cols) {
        this.cols = cols;
    }

    public static String getComment() {
        return comment;
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder s = new StringBuilder();
        StringTokenizer st = new StringTokenizer(this.description, newline);
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!line.startsWith(comment)) {
                s.append(comment);
            }
            s.append(String.format("%s%n", line));
        }
        if (this.scale != 1) {
            s.append("# Matrix scaled by a factor of ").append(this.scale).append(newline);
        }
        s.append(this.getMatrixAsString());
        return s.toString();
    }

    @Override
    public CompoundSet<AminoAcidCompound> getCompoundSet() {
        return this.compoundSet;
    }

    @Override
    public String getMatrixAsString() {
        StringBuilder s = new StringBuilder();
        int lengthCompound = this.compoundSet.getMaxSingleCompoundStringLength();
        int lengthRest = Math.max(Math.max(Short.toString(this.min).length(), Short.toString(this.max).length()), lengthCompound) + 1;
        String padCompound = "%" + Integer.toString(lengthCompound) + "s";
        String padRest = "%" + Integer.toString(lengthRest);
        for (int i = 0; i < lengthCompound; ++i) {
            s.append(" ");
        }
        for (AminoAcidCompound col : this.cols) {
            s.append(String.format(padRest + "s", this.compoundSet.getStringForCompound(col)));
        }
        s.append(String.format("%n", new Object[0]));
        for (AminoAcidCompound row : this.rows) {
            s.append(String.format(padCompound, this.compoundSet.getStringForCompound(row)));
            for (AminoAcidCompound col : this.cols) {
                s.append(String.format(padRest + "d", this.getValue(row, col)));
            }
            s.append(String.format("%n", new Object[0]));
        }
        return s.toString();
    }

    @Override
    public short getMaxValue() {
        return this.max;
    }

    @Override
    public short getMinValue() {
        return this.min;
    }

    @Override
    public short getValue(AminoAcidCompound from, AminoAcidCompound to) {
        int row = this.rows.indexOf(from);
        int col = this.cols.indexOf(to);
        if (row == -1 || col == -1) {
            row = this.cols.indexOf(from);
            col = this.rows.indexOf(to);
            if (row == -1 || col == -1) {
                return this.min;
            }
        }
        return this.matrix[row][col];
    }

    @Override
    public SubstitutionMatrix<AminoAcidCompound> normalizeMatrix(short scale) {
        return null;
    }

    @Override
    public Map<AminoAcidCompound, Short> getRow(AminoAcidCompound row) {
        int rowIndex = this.rows.indexOf(row);
        HashMap<AminoAcidCompound, Short> map = new HashMap<AminoAcidCompound, Short>();
        for (int colIndex = 0; colIndex < this.matrix[rowIndex].length; ++colIndex) {
            map.put(this.cols.get(colIndex), this.matrix[rowIndex][colIndex]);
        }
        return map;
    }

    @Override
    public Map<AminoAcidCompound, Short> getColumn(AminoAcidCompound column) {
        int colIndex = this.cols.indexOf(column);
        HashMap<AminoAcidCompound, Short> map = new HashMap<AminoAcidCompound, Short>();
        for (int i = 0; i < this.matrix.length; ++i) {
            map.put(this.rows.get(i), this.matrix[i][colIndex]);
        }
        return map;
    }
}

