/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.search.io.blast;

import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.search.io.Hit;
import org.biojava.nbio.core.search.io.blast.BlastResult;
import org.biojava.nbio.core.sequence.template.Sequence;

public class BlastResultBuilder {
    private String program;
    private String version;
    private String reference;
    private String dbFile;
    private Map<String, String> programSpecificParameters;
    private int iterationNumber;
    private String queryID;
    private String queryDef;
    private int queryLength;
    private Sequence querySequence;
    private List<Hit> hits;

    public BlastResultBuilder setProgram(String program) {
        this.program = program;
        return this;
    }

    public BlastResultBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public BlastResultBuilder setReference(String reference) {
        this.reference = reference;
        return this;
    }

    public BlastResultBuilder setDbFile(String dbFile) {
        this.dbFile = dbFile;
        return this;
    }

    public BlastResultBuilder setProgramSpecificParameters(Map<String, String> programSpecificParameters) {
        this.programSpecificParameters = programSpecificParameters;
        return this;
    }

    public BlastResultBuilder setIterationNumber(int iterationNumber) {
        this.iterationNumber = iterationNumber;
        return this;
    }

    public BlastResultBuilder setQueryID(String queryID) {
        this.queryID = queryID;
        return this;
    }

    public BlastResultBuilder setQueryDef(String queryDef) {
        this.queryDef = queryDef;
        return this;
    }

    public BlastResultBuilder setQueryLength(int queryLength) {
        this.queryLength = queryLength;
        return this;
    }

    public BlastResultBuilder setHits(List<Hit> hits) {
        this.hits = hits;
        return this;
    }

    public BlastResultBuilder setQuerySequence(Sequence s) {
        this.querySequence = s;
        return this;
    }

    public BlastResult createBlastResult() {
        return new BlastResult(this.program, this.version, this.reference, this.dbFile, this.programSpecificParameters, this.iterationNumber, this.queryID, this.queryDef, this.queryLength, this.hits, this.querySequence);
    }
}

