/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.io.BufferedReaderBytesRead;
import org.biojava.nbio.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastaReader<S extends Sequence<?>, C extends Compound> {
    private static final Logger logger = LoggerFactory.getLogger(FastaReader.class);
    SequenceCreatorInterface<C> sequenceCreator;
    SequenceHeaderParserInterface<S, C> headerParser;
    BufferedReaderBytesRead br;
    InputStreamReader isr;
    FileInputStream fi = null;
    long fileIndex = 0L;
    long sequenceIndex = 0L;
    String line = "";
    String header = "";

    public FastaReader(InputStream is, SequenceHeaderParserInterface<S, C> headerParser, SequenceCreatorInterface<C> sequenceCreator) {
        this.headerParser = headerParser;
        this.isr = new InputStreamReader(is);
        this.br = new BufferedReaderBytesRead(this.isr);
        this.sequenceCreator = sequenceCreator;
    }

    public FastaReader(File file, SequenceHeaderParserInterface<S, C> headerParser, SequenceCreatorInterface<C> sequenceCreator) throws FileNotFoundException {
        this.headerParser = headerParser;
        this.fi = new FileInputStream(file);
        this.isr = new InputStreamReader(this.fi);
        this.br = new BufferedReaderBytesRead(this.isr);
        this.sequenceCreator = sequenceCreator;
    }

    public Map<String, S> process() throws IOException {
        Map<String, S> sequences = this.process(-1);
        this.close();
        return sequences;
    }

    public Map<String, S> process(int max) throws IOException {
        String line = "";
        if (this.line != null && this.line.length() > 0) {
            line = this.line;
        }
        String header = "";
        if (this.header != null && this.header.length() > 0) {
            header = this.header;
        }
        StringBuilder sb = new StringBuilder();
        int processedSequences = 0;
        boolean keepGoing = true;
        LinkedHashMap<String, AbstractSequence<C>> sequences = new LinkedHashMap<String, AbstractSequence<C>>();
        do {
            AbstractSequence<C> sequence;
            if ((line = line.trim()).length() != 0) {
                if (line.startsWith(">")) {
                    if (sb.length() > 0) {
                        try {
                            sequence = this.sequenceCreator.getSequence(sb.toString(), this.sequenceIndex);
                            this.headerParser.parseHeader(header, sequence);
                            sequences.put(sequence.getAccession().getID(), sequence);
                            ++processedSequences;
                        }
                        catch (CompoundNotFoundException e) {
                            logger.warn("Sequence with header '{}' has unrecognised compounds ({}), it will be ignored", (Object)header, (Object)e.getMessage());
                        }
                        sb.setLength(0);
                    }
                    header = line.substring(1);
                } else if (!line.startsWith(";")) {
                    if (sb.length() == 0) {
                        this.sequenceIndex = this.fileIndex;
                    }
                    sb.append(line);
                }
            }
            this.fileIndex = this.br.getBytesRead();
            line = this.br.readLine();
            if (line == null) {
                if (sb.length() == 0 && header.length() != 0) {
                    logger.warn("Can't parse sequence {}. Got sequence of length 0!", (Object)this.sequenceIndex);
                    logger.warn("header: {}", (Object)header);
                    header = null;
                } else if (sb.length() > 0) {
                    try {
                        sequence = this.sequenceCreator.getSequence(sb.toString(), this.sequenceIndex);
                        this.headerParser.parseHeader(header, sequence);
                        sequences.put(sequence.getAccession().getID(), sequence);
                        ++processedSequences;
                        header = null;
                    }
                    catch (CompoundNotFoundException e) {
                        logger.warn("Sequence with header '{}' has unrecognised compounds ({}), it will be ignored", (Object)header, (Object)e.getMessage());
                    }
                }
                keepGoing = false;
            }
            if (max <= -1 || processedSequences < max) continue;
            keepGoing = false;
        } while (keepGoing);
        this.line = line;
        this.header = header;
        return max > -1 && sequences.isEmpty() ? null : sequences;
    }

    public void close() throws IOException {
        this.br.close();
        this.isr.close();
        if (this.fi != null) {
            this.fi.close();
        }
        this.header = null;
        this.line = null;
    }
}

