/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.storage.BitSequenceReader;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;

public class TwoBitSequenceReader<C extends NucleotideCompound>
extends BitSequenceReader<C> {
    public TwoBitSequenceReader(Sequence<C> sequence) {
        super(new TwoBitArrayWorker<C>(sequence), sequence.getAccession());
    }

    public TwoBitSequenceReader(String sequence, CompoundSet<C> compoundSet) {
        this(sequence, compoundSet, new AccessionID("Unknown"));
    }

    public TwoBitSequenceReader(String sequence, CompoundSet<C> compoundSet, AccessionID accession) {
        super(new TwoBitArrayWorker<C>(sequence, compoundSet), accession);
    }

    public TwoBitSequenceReader(TwoBitArrayWorker<C> worker) {
        super(worker, new AccessionID("unknown"));
    }

    public TwoBitSequenceReader(TwoBitArrayWorker<C> worker, AccessionID accession) {
        super(worker, accession);
    }

    public static class TwoBitArrayWorker<C extends NucleotideCompound>
    extends BitSequenceReader.BitArrayWorker<C> {
        private static final byte MASK = (byte)((int)Math.pow(2.0, 0.0) | (int)Math.pow(2.0, 1.0));

        public TwoBitArrayWorker(CompoundSet<C> compoundSet, int length) {
            super(compoundSet, length);
        }

        public TwoBitArrayWorker(CompoundSet<C> compoundSet, int[] sequence) {
            super(compoundSet, sequence);
        }

        public TwoBitArrayWorker(Sequence<C> sequence) {
            super(sequence);
        }

        public TwoBitArrayWorker(String sequence, CompoundSet<C> compoundSet) {
            super(sequence, compoundSet);
        }

        @Override
        protected byte bitMask() {
            return MASK;
        }

        @Override
        protected int compoundsPerDatatype() {
            return 16;
        }

        @Override
        protected Map<C, Integer> generateCompoundsToIndex() {
            CompoundSet cs = this.getCompoundSet();
            return Map.of((NucleotideCompound)cs.getCompoundForString("T"), 0, (NucleotideCompound)cs.getCompoundForString("C"), 1, (NucleotideCompound)cs.getCompoundForString("A"), 2, (NucleotideCompound)cs.getCompoundForString("G"), 3, (NucleotideCompound)cs.getCompoundForString("t"), 0, (NucleotideCompound)cs.getCompoundForString("c"), 1, (NucleotideCompound)cs.getCompoundForString("a"), 2, (NucleotideCompound)cs.getCompoundForString("g"), 3);
        }

        @Override
        protected List<C> generateIndexToCompounds() {
            CompoundSet cs = this.getCompoundSet();
            ArrayList<NucleotideCompound> result = new ArrayList<NucleotideCompound>();
            result.add((NucleotideCompound)cs.getCompoundForString("T"));
            result.add((NucleotideCompound)cs.getCompoundForString("C"));
            result.add((NucleotideCompound)cs.getCompoundForString("A"));
            result.add((NucleotideCompound)cs.getCompoundForString("G"));
            return result;
        }
    }
}

