/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.symmetry.core.AxisAligner;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.core.Rotation;
import org.biojava.nbio.structure.symmetry.core.RotationGroup;
import org.biojava.nbio.structure.symmetry.core.Subunits;
import org.biojava.nbio.structure.symmetry.geometry.MomentsOfInertia;
import org.biojava.nbio.structure.symmetry.geometry.SuperPosition;

public class RotationAxisAligner
extends AxisAligner {
    private static final Vector3d X_AXIS = new Vector3d(1.0, 0.0, 0.0);
    private static final Vector3d Y_AXIS = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d Z_AXIS = new Vector3d(0.0, 0.0, 1.0);
    private Subunits subunits = null;
    private RotationGroup rotationGroup = null;
    private Matrix4d transformationMatrix = new Matrix4d();
    private Matrix4d reverseTransformationMatrix = new Matrix4d();
    private Vector3d referenceVector = new Vector3d();
    private Vector3d principalRotationVector = new Vector3d();
    private Vector3d[] principalAxesOfInertia = null;
    List<List<Integer>> alignedOrbits = null;
    private Vector3d minBoundary = new Vector3d();
    private Vector3d maxBoundary = new Vector3d();
    private double xyRadiusMax = Double.MIN_VALUE;
    boolean modified = true;

    public RotationAxisAligner(QuatSymmetryResults results) {
        this.subunits = results.getSubunits();
        this.rotationGroup = results.getRotationGroup();
        if (this.subunits == null) {
            throw new IllegalArgumentException("AxisTransformation: Subunits are null");
        }
        if (this.rotationGroup == null) {
            throw new IllegalArgumentException("AxisTransformation: RotationGroup is null");
        }
        if (this.subunits.getSubunitCount() == 0) {
            throw new IllegalArgumentException("AxisTransformation: Subunits is empty");
        }
        if (this.rotationGroup.getOrder() == 0) {
            throw new IllegalArgumentException("AxisTransformation: RotationGroup is empty");
        }
    }

    @Override
    public String getSymmetry() {
        this.run();
        return this.rotationGroup.getPointGroup();
    }

    @Override
    public Matrix4d getTransformation() {
        this.run();
        return this.transformationMatrix;
    }

    @Override
    public Matrix3d getRotationMatrix() {
        this.run();
        Matrix3d m = new Matrix3d();
        this.transformationMatrix.getRotationScale(m);
        return m;
    }

    @Override
    public Matrix4d getReverseTransformation() {
        this.run();
        return this.reverseTransformationMatrix;
    }

    @Override
    public Vector3d getPrincipalRotationAxis() {
        this.run();
        return this.principalRotationVector;
    }

    @Override
    public Vector3d getRotationReferenceAxis() {
        this.run();
        return this.referenceVector;
    }

    @Override
    public Vector3d[] getPrincipalAxesOfInertia() {
        this.run();
        return this.principalAxesOfInertia;
    }

    @Override
    public Vector3d getDimension() {
        this.run();
        Vector3d dimension = new Vector3d();
        dimension.sub((Tuple3d)this.maxBoundary, (Tuple3d)this.minBoundary);
        dimension.scale(0.5);
        return dimension;
    }

    @Override
    public double getRadius() {
        this.run();
        return this.xyRadiusMax;
    }

    @Override
    public Matrix4d getGeometicCenterTransformation() {
        this.run();
        Matrix4d geometricCentered = new Matrix4d(this.reverseTransformationMatrix);
        geometricCentered.setTranslation(new Vector3d((Tuple3d)this.getGeometricCenter()));
        return geometricCentered;
    }

    @Override
    public Point3d getGeometricCenter() {
        this.run();
        Point3d geometricCenter = new Point3d();
        Vector3d translation = new Vector3d();
        this.reverseTransformationMatrix.get(translation);
        if (this.rotationGroup.getPointGroup().startsWith("C")) {
            Vector3d corr = new Vector3d(0.0, 0.0, this.minBoundary.z + this.getDimension().z);
            this.reverseTransformationMatrix.transform(corr);
            geometricCenter.set((Tuple3d)corr);
        }
        geometricCenter.add((Tuple3d)translation);
        return geometricCenter;
    }

    @Override
    public Point3d getCentroid() {
        return new Point3d(this.subunits.getCentroid());
    }

    @Override
    public Subunits getSubunits() {
        return this.subunits;
    }

    public RotationGroup getRotationGroup() {
        return this.rotationGroup;
    }

    @Override
    public List<List<Integer>> getOrbits() {
        return this.alignedOrbits;
    }

    private void run() {
        if (this.modified) {
            this.calcPrincipalRotationVector();
            this.calcPrincipalAxes();
            this.calcReferenceVector();
            this.calcTransformation();
            if (this.rotationGroup.getPointGroup().startsWith("C") && !this.rotationGroup.getPointGroup().startsWith("C2") || this.rotationGroup.getPointGroup().startsWith("D") && !this.rotationGroup.getPointGroup().startsWith("D2")) {
                this.refineReferenceVector();
                this.calcTransformation();
            }
            this.calcReverseTransformation();
            this.calcBoundaries();
            if (!this.rotationGroup.getPointGroup().equals("Helical")) {
                this.calcAlignedOrbits();
            }
            this.modified = false;
        }
    }

    private void calcAlignedOrbits() {
        TreeMap<Double, List<Integer>> depthMap = new TreeMap<Double, List<Integer>>();
        double[] depth = this.getSubunitZDepth();
        this.alignedOrbits = this.calcOrbits();
        for (List<Integer> orbit : this.alignedOrbits) {
            double meanDepth = 0.0;
            for (int subunit : orbit) {
                meanDepth += depth[subunit];
            }
            if (depthMap.get(meanDepth /= (double)orbit.size()) != null) {
                meanDepth += 0.01;
            }
            depthMap.put(meanDepth, orbit);
        }
        this.alignedOrbits.clear();
        for (List<Integer> orbit : depthMap.values()) {
            this.alignWithReferenceAxis(orbit);
            this.alignedOrbits.add(orbit);
        }
    }

    private List<Integer> alignWithReferenceAxis(List<Integer> orbit) {
        int n = this.subunits.getSubunitCount();
        int fold = this.rotationGroup.getRotation(0).getFold();
        if (fold < 2) {
            return orbit;
        }
        Vector3d probe = new Vector3d();
        double dotMin1 = Double.MIN_VALUE;
        double dotMin2 = Double.MIN_VALUE;
        int index1 = 0;
        int index2 = 0;
        Vector3d Y1 = new Vector3d(0.0, 1.0, 0.0);
        Vector3d Y2 = new Vector3d(0.0, 1.0, 0.0);
        Matrix3d m = new Matrix3d();
        double angle = Math.PI * -2 / (double)fold;
        m.rotZ(0.1 * angle);
        m.transform((Tuple3d)Y1);
        m.rotZ(1.1 * angle);
        m.transform((Tuple3d)Y2);
        for (int i : orbit) {
            double dot2;
            Point3d p = this.subunits.getCenters().get(i);
            probe.set((Tuple3d)p);
            this.transformationMatrix.transform(probe);
            double dot1 = Y1.dot(probe);
            if (dot1 > dotMin1) {
                dotMin1 = dot1;
                index1 = i;
            }
            if (!((dot2 = Y2.dot(probe)) > dotMin2)) continue;
            dotMin2 = dot2;
            index2 = i;
        }
        for (int i = 0; i < n && orbit.get(0) != index1; ++i) {
            Collections.rotate(orbit, 1);
        }
        if (orbit.get(1) == index2) {
            return orbit;
        }
        Collections.reverse(orbit.subList(1, orbit.size()));
        if (orbit.get(1) != index2) {
            System.err.println("Warning: alignWithReferenceAxis failed");
        }
        return orbit;
    }

    private void calcTransformation() {
        if (this.rotationGroup.getPointGroup().equals("C1")) {
            this.calcTransformationByInertiaAxes();
        } else {
            this.calcTransformationBySymmetryAxes();
        }
        this.transformationMatrix.setElement(3, 3, 1.0);
    }

    private void calcReverseTransformation() {
        this.reverseTransformationMatrix.invert(this.transformationMatrix);
    }

    private void calcTransformationBySymmetryAxes() {
        Vector3d[] axisVectors = new Vector3d[]{new Vector3d(this.principalRotationVector), new Vector3d(this.referenceVector)};
        Vector3d[] referenceVectors = new Vector3d[]{new Vector3d(Z_AXIS), new Vector3d(Y_AXIS)};
        this.transformationMatrix = this.alignAxes(axisVectors, referenceVectors);
        Matrix4d combined = new Matrix4d();
        combined.setIdentity();
        Vector3d trans = new Vector3d((Tuple3d)this.subunits.getCentroid());
        trans.negate();
        combined.setTranslation(trans);
        this.transformationMatrix.mul(combined);
        if (this.rotationGroup.getPointGroup().startsWith("C")) {
            this.calcZDirection();
        }
    }

    private void calcTransformationByInertiaAxes() {
        Vector3d[] axisVectors = new Vector3d[]{new Vector3d(this.principalAxesOfInertia[0]), new Vector3d(this.principalAxesOfInertia[1])};
        Vector3d[] referenceVectors = new Vector3d[]{new Vector3d(Y_AXIS), new Vector3d(X_AXIS)};
        this.transformationMatrix = this.alignAxes(axisVectors, referenceVectors);
        Matrix4d translation = new Matrix4d();
        translation.setIdentity();
        Vector3d trans = new Vector3d((Tuple3d)this.subunits.getCentroid());
        trans.negate();
        translation.setTranslation(trans);
        this.transformationMatrix.mul(translation);
    }

    private Matrix4d alignAxes(Vector3d[] axisVectors, Vector3d[] referenceVectors) {
        Matrix4d m1 = new Matrix4d();
        AxisAngle4d a = new AxisAngle4d();
        Vector3d axis = new Vector3d();
        Vector3d v1 = new Vector3d(axisVectors[0]);
        Vector3d v2 = new Vector3d(referenceVectors[0]);
        double dot = v1.dot(v2);
        if (Math.abs(dot) < 0.999) {
            axis.cross(v1, v2);
            axis.normalize();
            a.set(axis, v1.angle(v2));
            m1.set(a);
            m1.setElement(3, 3, 1.0);
        } else if (dot > 0.0) {
            m1.setIdentity();
        } else if (dot < 0.0) {
            m1.set(RotationAxisAligner.flipX());
        }
        m1.transform(axisVectors[0]);
        m1.transform(axisVectors[1]);
        v1 = new Vector3d(axisVectors[1]);
        v2 = new Vector3d(referenceVectors[1]);
        Matrix4d m2 = new Matrix4d();
        dot = v1.dot(v2);
        if (Math.abs(dot) < 0.999) {
            axis.cross(v1, v2);
            axis.normalize();
            a.set(axis, v1.angle(v2));
            m2.set(a);
            m2.setElement(3, 3, 1.0);
        } else if (dot > 0.0) {
            m2.setIdentity();
        } else if (dot < 0.0) {
            m2.set(RotationAxisAligner.flipZ());
        }
        m2.transform(axisVectors[0]);
        m2.transform(axisVectors[1]);
        m2.mul(m1);
        Point3d[] axes = new Point3d[]{new Point3d((Tuple3d)axisVectors[0]), new Point3d((Tuple3d)axisVectors[1])};
        Point3d[] ref = new Point3d[]{new Point3d((Tuple3d)referenceVectors[0]), new Point3d((Tuple3d)referenceVectors[1])};
        if (SuperPosition.rmsd(axes, ref) > 0.1) {
            System.out.println("Warning: AxisTransformation: axes alignment is off. RMSD: " + SuperPosition.rmsd(axes, ref));
        }
        return m2;
    }

    private void calcPrincipalAxes() {
        MomentsOfInertia moi = new MomentsOfInertia();
        for (Point3d[] list : this.subunits.getTraces()) {
            for (Point3d p : list) {
                moi.addPoint(p, 1.0);
            }
        }
        this.principalAxesOfInertia = moi.getPrincipalAxes();
    }

    private void calcBoundaries() {
        this.minBoundary.x = Double.MAX_VALUE;
        this.maxBoundary.x = Double.MIN_VALUE;
        this.minBoundary.y = Double.MAX_VALUE;
        this.maxBoundary.x = Double.MIN_VALUE;
        this.minBoundary.z = Double.MAX_VALUE;
        this.maxBoundary.z = Double.MIN_VALUE;
        Point3d probe = new Point3d();
        for (Point3d[] list : this.subunits.getTraces()) {
            for (Point3d p : list) {
                probe.set((Tuple3d)p);
                this.transformationMatrix.transform(probe);
                this.minBoundary.x = Math.min(this.minBoundary.x, probe.x);
                this.maxBoundary.x = Math.max(this.maxBoundary.x, probe.x);
                this.minBoundary.y = Math.min(this.minBoundary.y, probe.y);
                this.maxBoundary.y = Math.max(this.maxBoundary.y, probe.y);
                this.minBoundary.z = Math.min(this.minBoundary.z, probe.z);
                this.maxBoundary.z = Math.max(this.maxBoundary.z, probe.z);
                this.xyRadiusMax = Math.max(this.xyRadiusMax, Math.sqrt(probe.x * probe.x + probe.y * probe.y));
            }
        }
    }

    private void calcZDirection() {
        this.calcBoundaries();
        if (Math.abs(this.minBoundary.z) > Math.abs(this.maxBoundary.z)) {
            Matrix4d rot = RotationAxisAligner.flipY();
            rot.mul(this.transformationMatrix);
            this.transformationMatrix.set(rot);
        }
    }

    private List<List<Integer>> getOrbitsByXYWidth() {
        TreeMap<Double, List<Integer>> widthMap = new TreeMap<Double, List<Integer>>();
        double[] width = this.getSubunitXYWidth();
        List<List<Integer>> orbits = this.calcOrbits();
        for (List<Integer> orbit : orbits) {
            double meanWidth = 0.0;
            for (int subunit : orbit) {
                meanWidth += width[subunit];
            }
            if (widthMap.get(meanWidth /= (double)orbit.size()) != null) {
                meanWidth += 0.01;
            }
            widthMap.put(meanWidth, orbit);
        }
        orbits.clear();
        for (List<Integer> orbit : widthMap.values()) {
            orbits.add(orbit);
        }
        return orbits;
    }

    private double[] getSubunitXYWidth() {
        int n = this.subunits.getSubunitCount();
        double[] width = new double[n];
        Point3d probe = new Point3d();
        for (int i = 0; i < n; ++i) {
            width[i] = Double.MIN_VALUE;
            for (Point3d p : this.subunits.getTraces().get(i)) {
                probe.set((Tuple3d)p);
                this.transformationMatrix.transform(probe);
                width[i] = Math.max(width[i], Math.sqrt(probe.x * probe.x + probe.y * probe.y));
            }
        }
        return width;
    }

    private double[] getSubunitZDepth() {
        int n = this.subunits.getSubunitCount();
        double[] depth = new double[n];
        Point3d probe = new Point3d();
        for (int i = 0; i < n; ++i) {
            Point3d p = this.subunits.getCenters().get(i);
            probe.set((Tuple3d)p);
            this.transformationMatrix.transform(probe);
            depth[i] = probe.z;
        }
        return depth;
    }

    private List<List<Integer>> calcOrbits() {
        int n = this.subunits.getSubunitCount();
        int fold = this.rotationGroup.getRotation(0).getFold();
        ArrayList<List<Integer>> orbits = new ArrayList<List<Integer>>();
        boolean[] used = new boolean[n];
        Arrays.fill(used, false);
        for (int i = 0; i < n; ++i) {
            if (used[i]) continue;
            ArrayList<Integer> orbit = new ArrayList<Integer>(fold);
            for (int j = 0; j < fold; ++j) {
                List<Integer> permutation = this.rotationGroup.getRotation(j).getPermutation();
                orbit.add(permutation.get(i));
                used[permutation.get((int)i).intValue()] = true;
            }
            orbits.add(this.deconvolute(orbit));
        }
        return orbits;
    }

    private List<Integer> deconvolute(List<Integer> orbit) {
        if (this.rotationGroup.getOrder() < 2) {
            return orbit;
        }
        List<Integer> p0 = this.rotationGroup.getRotation(0).getPermutation();
        List<Integer> p1 = this.rotationGroup.getRotation(1).getPermutation();
        ArrayList<Integer> inRotationOrder = new ArrayList<Integer>(orbit.size());
        inRotationOrder.add(orbit.get(0));
        for (int i = 1; i < orbit.size(); ++i) {
            int current = (Integer)inRotationOrder.get(i - 1);
            int index = p0.indexOf(current);
            int next = p1.get(index);
            if (!orbit.contains(next)) {
                System.err.println("deconvolute: inconsistency in permuation. Returning original order");
                return orbit;
            }
            inRotationOrder.add(next);
        }
        return inRotationOrder;
    }

    private void calcPrincipalRotationVector() {
        Rotation rotation = this.rotationGroup.getRotation(0);
        AxisAngle4d axisAngle = rotation.getAxisAngle();
        this.principalRotationVector = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
    }

    private void calcReferenceVector() {
        this.referenceVector = null;
        if (this.rotationGroup.getPointGroup().startsWith("C")) {
            this.referenceVector = this.getReferenceAxisCylic();
        } else if (this.rotationGroup.getPointGroup().startsWith("D")) {
            this.referenceVector = this.getReferenceAxisDihedral();
        } else if (this.rotationGroup.getPointGroup().equals("T")) {
            this.referenceVector = this.getReferenceAxisTetrahedral();
        } else if (this.rotationGroup.getPointGroup().equals("O")) {
            this.referenceVector = this.getReferenceAxisOctahedral();
        } else if (this.rotationGroup.getPointGroup().equals("I")) {
            this.referenceVector = this.getReferenceAxisIcosahedral();
        } else if (this.rotationGroup.getPointGroup().equals("Helical")) {
            this.referenceVector = this.getReferenceAxisCylic();
        }
        if (this.referenceVector == null) {
            System.err.println("Warning: no reference vector found. Using y-axis.");
            this.referenceVector = new Vector3d(Y_AXIS);
        }
        this.referenceVector = this.orthogonalize(this.principalRotationVector, this.referenceVector);
    }

    private void refineReferenceVector() {
        this.referenceVector = new Vector3d(Y_AXIS);
        if (this.rotationGroup.getPointGroup().startsWith("C")) {
            this.referenceVector = this.getReferenceAxisCylicWithSubunitAlignment();
        } else if (this.rotationGroup.getPointGroup().startsWith("D")) {
            this.referenceVector = this.getReferenceAxisDihedralWithSubunitAlignment();
        }
        this.referenceVector = this.orthogonalize(this.principalRotationVector, this.referenceVector);
    }

    private Vector3d orthogonalize(Vector3d vector1, Vector3d vector2) {
        double dot = vector1.dot(vector2);
        Vector3d ref = new Vector3d(vector2);
        if (dot < 0.0) {
            vector2.negate();
        }
        vector2.cross(vector1, vector2);
        vector2.normalize();
        vector2.cross(vector1, vector2);
        vector2.normalize();
        if (ref.dot(vector2) < 0.0) {
            vector2.negate();
        }
        return vector2;
    }

    private Vector3d getReferenceAxisCylic() {
        if (this.rotationGroup.getPointGroup().equals("C2")) {
            Vector3d vr = new Vector3d((Tuple3d)this.subunits.getOriginalCenters().get(0));
            vr.sub((Tuple3d)this.subunits.getCentroid());
            vr.normalize();
            return vr;
        }
        Vector3d vmin = null;
        double dotMin = 1.0;
        for (Vector3d v : this.principalAxesOfInertia) {
            if (!(Math.abs(this.principalRotationVector.dot(v)) < dotMin)) continue;
            dotMin = Math.abs(this.principalRotationVector.dot(v));
            vmin = new Vector3d(v);
        }
        if (this.principalRotationVector.dot(vmin) < 0.0) {
            vmin.negate();
        }
        return vmin;
    }

    private Vector3d getReferenceAxisCylicWithSubunitAlignment() {
        if (this.rotationGroup.getPointGroup().equals("C2")) {
            return this.referenceVector;
        }
        List<List<Integer>> orbits = this.getOrbitsByXYWidth();
        List<Integer> widestOrbit = orbits.get(orbits.size() - 1);
        List<Point3d> centers = this.subunits.getCenters();
        int subunit = widestOrbit.get(0);
        Vector3d refAxis = new Vector3d();
        refAxis.sub((Tuple3d)centers.get(subunit), (Tuple3d)this.subunits.getCentroid());
        refAxis.normalize();
        return refAxis;
    }

    private Vector3d getReferenceAxisDihedralWithSubunitAlignment() {
        int maxFold = this.rotationGroup.getRotation(0).getFold();
        double minAngle = Double.MAX_VALUE;
        Vector3d refVec = null;
        Vector3d ref = this.getSubunitReferenceVector();
        for (int i = 0; i < this.rotationGroup.getOrder(); ++i) {
            if ((this.rotationGroup.getRotation(i).getDirection() != 1 || this.rotationGroup.getRotation(i).getFold() >= maxFold) && !this.rotationGroup.getPointGroup().equals("D2")) continue;
            AxisAngle4d axisAngle = this.rotationGroup.getRotation(i).getAxisAngle();
            Vector3d v = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
            v.normalize();
            double angle = v.angle(ref);
            if (angle < minAngle) {
                minAngle = angle;
                refVec = v;
            }
            Vector3d vn = new Vector3d(v);
            vn.negate();
            angle = vn.angle(ref);
            if (!(angle < minAngle)) continue;
            minAngle = angle;
            refVec = vn;
        }
        refVec.normalize();
        return refVec;
    }

    private Vector3d getReferenceAxisDihedral() {
        int maxFold = this.rotationGroup.getRotation(0).getFold();
        if (maxFold == 2) {
            maxFold = 3;
        }
        for (int i = 0; i < this.rotationGroup.getOrder(); ++i) {
            if (this.rotationGroup.getRotation(i).getDirection() != 1 || this.rotationGroup.getRotation(i).getFold() >= maxFold) continue;
            AxisAngle4d axisAngle = this.rotationGroup.getRotation(i).getAxisAngle();
            Vector3d v = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
            v.normalize();
            return v;
        }
        return null;
    }

    private Vector3d getReferenceAxisTetrahedral() {
        for (int i = 0; i < this.rotationGroup.getOrder(); ++i) {
            AxisAngle4d axisAngle = this.rotationGroup.getRotation(i).getAxisAngle();
            Vector3d v = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
            double d = v.dot(this.principalRotationVector);
            if (this.rotationGroup.getRotation(i).getFold() != 3 || !(d > 0.3) || !(d < 0.9)) continue;
            return v;
        }
        return null;
    }

    private Vector3d getReferenceAxisOctahedral() {
        for (int i = 0; i < this.rotationGroup.getOrder(); ++i) {
            AxisAngle4d axisAngle = this.rotationGroup.getRotation(i).getAxisAngle();
            Vector3d v = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
            double d = v.dot(this.principalRotationVector);
            if (this.rotationGroup.getRotation(i).getFold() != 4 || !(d > -0.1) || !(d < 0.1)) continue;
            return v;
        }
        return null;
    }

    private Vector3d getReferenceAxisIcosahedral() {
        for (int i = 0; i < this.rotationGroup.getOrder(); ++i) {
            AxisAngle4d axisAngle = this.rotationGroup.getRotation(i).getAxisAngle();
            Vector3d v = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
            double d = v.dot(this.principalRotationVector);
            if (this.rotationGroup.getRotation(i).getFold() != 5 || !(d > 0.4) || !(d < 0.5)) continue;
            return v;
        }
        return null;
    }

    private Vector3d getSubunitReferenceVector() {
        int n = this.subunits.getSubunitCount();
        Point3d probe = new Point3d();
        double maxWidthSq = 0.0;
        Point3d ref = null;
        for (int i = 0; i < n; ++i) {
            for (Point3d p : this.subunits.getTraces().get(i)) {
                probe.set((Tuple3d)p);
                this.transformationMatrix.transform(probe);
                double widthSq = probe.x * probe.x + probe.y * probe.y;
                if (!(widthSq > maxWidthSq)) continue;
                maxWidthSq = widthSq;
                ref = p;
            }
        }
        Vector3d refVector = new Vector3d();
        refVector.sub(ref, (Tuple3d)this.subunits.getCentroid());
        refVector.normalize();
        return refVector;
    }

    private static Matrix4d flipX() {
        Matrix4d rot = new Matrix4d();
        rot.m00 = 1.0;
        rot.m11 = -1.0;
        rot.m22 = -1.0;
        rot.m33 = 1.0;
        return rot;
    }

    private static Matrix4d flipY() {
        Matrix4d rot = new Matrix4d();
        rot.m00 = -1.0;
        rot.m11 = 1.0;
        rot.m22 = -1.0;
        rot.m33 = 1.0;
        return rot;
    }

    private static Matrix4d flipZ() {
        Matrix4d rot = new Matrix4d();
        rot.m00 = -1.0;
        rot.m11 = -1.0;
        rot.m22 = 1.0;
        rot.m33 = 1.0;
        return rot;
    }
}

