/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.symmetry.core.AxisAligner;
import org.biojava.nbio.structure.symmetry.core.Helix;
import org.biojava.nbio.structure.symmetry.core.HelixLayers;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryResults;
import org.biojava.nbio.structure.symmetry.core.Subunits;
import org.biojava.nbio.structure.symmetry.geometry.MomentsOfInertia;
import org.biojava.nbio.structure.symmetry.geometry.SuperPosition;

public class HelixAxisAligner
extends AxisAligner {
    private static final Vector3d Y_AXIS = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d Z_AXIS = new Vector3d(0.0, 0.0, 1.0);
    private Subunits subunits = null;
    private HelixLayers helixLayers = null;
    private Matrix4d transformationMatrix = new Matrix4d();
    private Matrix4d reverseTransformationMatrix = new Matrix4d();
    private Vector3d referenceVector = new Vector3d();
    private Vector3d principalRotationVector = new Vector3d();
    private Vector3d[] principalAxesOfInertia = null;
    private List<List<Integer>> alignedOrbits = null;
    private Vector3d minBoundary = new Vector3d();
    private Vector3d maxBoundary = new Vector3d();
    private double xzRadiusMax = Double.MIN_VALUE;
    boolean modified = true;

    public HelixAxisAligner(QuatSymmetryResults results) {
        this.subunits = results.getSubunits();
        this.helixLayers = results.getHelixLayers();
        if (this.subunits == null) {
            throw new IllegalArgumentException("HelixAxisTransformation: Subunits are null");
        }
        if (this.helixLayers == null) {
            throw new IllegalArgumentException("HelixAxisTransformation: HelixLayers is null");
        }
        if (this.subunits.getSubunitCount() == 0) {
            throw new IllegalArgumentException("HelixAxisTransformation: Subunits is empty");
        }
        if (this.helixLayers.size() == 0) {
            throw new IllegalArgumentException("HelixAxisTransformation: HelixLayers is empty");
        }
    }

    @Override
    public String getSymmetry() {
        this.run();
        return "H";
    }

    @Override
    public Matrix4d getTransformation() {
        this.run();
        return this.transformationMatrix;
    }

    @Override
    public Matrix3d getRotationMatrix() {
        this.run();
        Matrix3d m = new Matrix3d();
        this.transformationMatrix.getRotationScale(m);
        return m;
    }

    @Override
    public Matrix4d getReverseTransformation() {
        this.run();
        return this.reverseTransformationMatrix;
    }

    @Override
    public Vector3d getPrincipalRotationAxis() {
        this.run();
        return this.principalRotationVector;
    }

    @Override
    public Vector3d getRotationReferenceAxis() {
        this.run();
        return this.referenceVector;
    }

    @Override
    public Vector3d[] getPrincipalAxesOfInertia() {
        this.run();
        return this.principalAxesOfInertia;
    }

    @Override
    public Vector3d getDimension() {
        this.run();
        Vector3d dimension = new Vector3d();
        dimension.sub((Tuple3d)this.maxBoundary, (Tuple3d)this.minBoundary);
        dimension.scale(0.5);
        return dimension;
    }

    @Override
    public double getRadius() {
        this.run();
        return this.xzRadiusMax;
    }

    @Override
    public Matrix4d getGeometicCenterTransformation() {
        this.run();
        Matrix4d geometricCentered = new Matrix4d(this.reverseTransformationMatrix);
        geometricCentered.setTranslation(new Vector3d((Tuple3d)this.getGeometricCenter()));
        return geometricCentered;
    }

    @Override
    public Point3d getGeometricCenter() {
        this.run();
        Point3d geometricCenter = new Point3d();
        Vector3d translation = new Vector3d();
        this.reverseTransformationMatrix.transform(translation);
        geometricCenter.add((Tuple3d)translation);
        return geometricCenter;
    }

    @Override
    public Point3d getCentroid() {
        return new Point3d(this.subunits.getCentroid());
    }

    @Override
    public Subunits getSubunits() {
        return this.subunits;
    }

    public HelixLayers getHelixLayers() {
        this.run();
        return this.helixLayers;
    }

    @Override
    public List<List<Integer>> getOrbits() {
        this.run();
        return this.alignedOrbits;
    }

    private void run() {
        if (this.modified) {
            this.calcPrincipalRotationVector();
            this.calcPrincipalAxes();
            this.calcReferenceVector();
            this.calcTransformation();
            this.transformationMatrix = this.reorientHelix(0);
            this.calcReverseTransformation();
            this.calcBoundaries();
            this.calcAlignedOrbits();
            this.calcCenterOfRotation();
            this.modified = false;
        }
    }

    public Point3d calcCenterOfRotation() {
        List<Integer> line = this.getLongestLayerLine();
        if (line.size() < 3) {
            return this.subunits.getCentroid();
        }
        Point3d centerOfRotation = new Point3d();
        List<Point3d> centers = this.subunits.getOriginalCenters();
        for (int i = 0; i < line.size() - 2; ++i) {
            Point3d p1 = new Point3d(centers.get(line.get(i)));
            Point3d p2 = new Point3d(centers.get(line.get(i + 1)));
            Point3d p3 = new Point3d(centers.get(line.get(i + 2)));
            this.transformationMatrix.transform(p1);
            this.transformationMatrix.transform(p2);
            this.transformationMatrix.transform(p3);
            centerOfRotation.add((Tuple3d)this.getMidPoint(p1, p2, p3));
        }
        centerOfRotation.scale((double)(1 / (line.size() - 2)));
        centerOfRotation.y = 0.0;
        this.reverseTransformationMatrix.transform(centerOfRotation);
        return centerOfRotation;
    }

    private List<Integer> getLongestLayerLine() {
        int len = 0;
        int index = 0;
        Helix helix = this.helixLayers.getByLargestContacts();
        List<List<Integer>> layerLines = helix.getLayerLines();
        for (int i = 0; i < layerLines.size(); ++i) {
            if (layerLines.get(i).size() <= len) continue;
            len = layerLines.get(i).size();
            index = i;
        }
        return layerLines.get(index);
    }

    private Point3d getMidPoint(Point3d p1, Point3d p2, Point3d p3) {
        Vector3d v1 = new Vector3d();
        v1.sub((Tuple3d)p1, (Tuple3d)p2);
        Vector3d v2 = new Vector3d();
        v2.sub((Tuple3d)p3, (Tuple3d)p2);
        Vector3d v3 = new Vector3d();
        v3.add((Tuple3d)v1);
        v3.add((Tuple3d)v2);
        v3.normalize();
        double dTotal = v1.length();
        double rise = p2.y - p1.y;
        double chord = Math.sqrt(dTotal * dTotal - rise * rise);
        double angle = this.helixLayers.getByLargestContacts().getAxisAngle().angle;
        double radius = chord / Math.sin(angle / 2.0) / 2.0;
        v3.scale(radius);
        v3.add((Tuple3d)p2);
        Point3d cor = new Point3d((Tuple3d)v3);
        return cor;
    }

    private Matrix4d reorientHelix(int index) {
        Matrix4d matrix = new Matrix4d();
        matrix.setIdentity();
        matrix.setRotation(new AxisAngle4d(1.0, 0.0, 0.0, 1.5707963267948966 * (double)(index + 1)));
        matrix.mul(this.transformationMatrix);
        return matrix;
    }

    private void calcAlignedOrbits() {
        TreeMap<Double, List<Integer>> depthMap = new TreeMap<Double, List<Integer>>();
        double[] depth = this.getSubunitZDepth();
        this.alignedOrbits = this.calcOrbits();
        for (List<Integer> orbit : this.alignedOrbits) {
            double meanDepth = 0.0;
            for (int subunit : orbit) {
                meanDepth += depth[subunit];
            }
            if (depthMap.get(meanDepth /= (double)orbit.size()) != null) {
                meanDepth += 0.01;
            }
            depthMap.put(meanDepth, orbit);
        }
        this.alignedOrbits.clear();
        for (List<Integer> orbit : depthMap.values()) {
            this.alignedOrbits.add(orbit);
        }
    }

    private void calcTransformation() {
        this.calcTransformationBySymmetryAxes();
        this.transformationMatrix.setElement(3, 3, 1.0);
    }

    private void calcReverseTransformation() {
        this.reverseTransformationMatrix.invert(this.transformationMatrix);
    }

    private void calcTransformationBySymmetryAxes() {
        Vector3d[] axisVectors = new Vector3d[]{new Vector3d(this.principalRotationVector), new Vector3d(this.referenceVector)};
        Vector3d[] referenceVectors = new Vector3d[]{new Vector3d(Z_AXIS), new Vector3d(Y_AXIS)};
        this.transformationMatrix = this.alignAxes(axisVectors, referenceVectors);
        Matrix4d combined = new Matrix4d();
        combined.setIdentity();
        Vector3d trans = new Vector3d((Tuple3d)this.subunits.getCentroid());
        trans.negate();
        combined.setTranslation(trans);
        this.transformationMatrix.mul(combined);
        this.calcZDirection();
    }

    private Matrix4d alignAxes(Vector3d[] axisVectors, Vector3d[] referenceVectors) {
        Matrix4d m1 = new Matrix4d();
        AxisAngle4d a = new AxisAngle4d();
        Vector3d axis = new Vector3d();
        Vector3d v1 = new Vector3d(axisVectors[0]);
        Vector3d v2 = new Vector3d(referenceVectors[0]);
        double dot = v1.dot(v2);
        if (Math.abs(dot) < 0.999) {
            axis.cross(v1, v2);
            axis.normalize();
            a.set(axis, v1.angle(v2));
            m1.set(a);
            m1.setElement(3, 3, 1.0);
        } else if (dot > 0.0) {
            m1.setIdentity();
        } else if (dot < 0.0) {
            m1.set(HelixAxisAligner.flipX());
        }
        m1.transform(axisVectors[0]);
        m1.transform(axisVectors[1]);
        v1 = new Vector3d(axisVectors[1]);
        v2 = new Vector3d(referenceVectors[1]);
        Matrix4d m2 = new Matrix4d();
        dot = v1.dot(v2);
        if (Math.abs(dot) < 0.999) {
            axis.cross(v1, v2);
            axis.normalize();
            a.set(axis, v1.angle(v2));
            m2.set(a);
            m2.setElement(3, 3, 1.0);
        } else if (dot > 0.0) {
            m2.setIdentity();
        } else if (dot < 0.0) {
            m2.set(HelixAxisAligner.flipZ());
        }
        m2.transform(axisVectors[0]);
        m2.transform(axisVectors[1]);
        m2.mul(m1);
        Point3d[] axes = new Point3d[]{new Point3d((Tuple3d)axisVectors[0]), new Point3d((Tuple3d)axisVectors[1])};
        Point3d[] ref = new Point3d[]{new Point3d((Tuple3d)referenceVectors[0]), new Point3d((Tuple3d)referenceVectors[1])};
        if (SuperPosition.rmsd(axes, ref) > 0.1) {
            System.out.println("Warning: AxisTransformation: axes alignment is off. RMSD: " + SuperPosition.rmsd(axes, ref));
        }
        return m2;
    }

    private void calcPrincipalAxes() {
        MomentsOfInertia moi = new MomentsOfInertia();
        for (Point3d[] list : this.subunits.getTraces()) {
            for (Point3d p : list) {
                moi.addPoint(p, 1.0);
            }
        }
        this.principalAxesOfInertia = moi.getPrincipalAxes();
    }

    private void calcBoundaries() {
        this.minBoundary.x = Double.MAX_VALUE;
        this.maxBoundary.x = Double.MIN_VALUE;
        this.minBoundary.y = Double.MAX_VALUE;
        this.maxBoundary.x = Double.MIN_VALUE;
        this.minBoundary.z = Double.MAX_VALUE;
        this.maxBoundary.z = Double.MIN_VALUE;
        this.xzRadiusMax = Double.MIN_VALUE;
        Point3d probe = new Point3d();
        for (Point3d[] list : this.subunits.getTraces()) {
            for (Point3d p : list) {
                probe.set((Tuple3d)p);
                this.transformationMatrix.transform(probe);
                this.minBoundary.x = Math.min(this.minBoundary.x, probe.x);
                this.maxBoundary.x = Math.max(this.maxBoundary.x, probe.x);
                this.minBoundary.y = Math.min(this.minBoundary.y, probe.y);
                this.maxBoundary.y = Math.max(this.maxBoundary.y, probe.y);
                this.minBoundary.z = Math.min(this.minBoundary.z, probe.z);
                this.maxBoundary.z = Math.max(this.maxBoundary.z, probe.z);
                this.xzRadiusMax = Math.max(this.xzRadiusMax, Math.sqrt(probe.x * probe.x + probe.z * probe.z));
            }
        }
    }

    private void calcZDirection() {
        this.calcBoundaries();
        if (Math.abs(this.minBoundary.z) > Math.abs(this.maxBoundary.z)) {
            Matrix4d rot = HelixAxisAligner.flipY();
            rot.mul(this.transformationMatrix);
            this.transformationMatrix.set(rot);
        }
    }

    private double[] getSubunitZDepth() {
        int n = this.subunits.getSubunitCount();
        double[] depth = new double[n];
        Point3d probe = new Point3d();
        for (int i = 0; i < n; ++i) {
            Point3d p = this.subunits.getCenters().get(i);
            probe.set((Tuple3d)p);
            this.transformationMatrix.transform(probe);
            depth[i] = probe.z;
        }
        return depth;
    }

    private List<List<Integer>> calcOrbits() {
        int n = this.subunits.getSubunitCount();
        ArrayList<List<Integer>> orbits = new ArrayList<List<Integer>>();
        for (int i = 0; i < n; ++i) {
            orbits.add(Collections.singletonList(i));
        }
        return orbits;
    }

    private void calcPrincipalRotationVector() {
        AxisAngle4d axisAngle = this.helixLayers.getByLargestContacts().getAxisAngle();
        this.principalRotationVector = new Vector3d(axisAngle.x, axisAngle.y, axisAngle.z);
    }

    private void calcReferenceVector() {
        this.referenceVector = this.getReferenceAxisCylic();
        if (this.referenceVector == null) {
            System.err.println("Warning: no reference vector found. Using y-axis.");
            this.referenceVector = new Vector3d(Y_AXIS);
        }
        this.referenceVector = this.orthogonalize(this.principalRotationVector, this.referenceVector);
    }

    private Vector3d orthogonalize(Vector3d vector1, Vector3d vector2) {
        double dot = vector1.dot(vector2);
        Vector3d ref = new Vector3d(vector2);
        if (dot < 0.0) {
            vector2.negate();
        }
        if (Math.abs(dot) < 1.0E-5) {
            System.out.println("HelixAxisAligner: Warning: reference axis parallel");
        }
        vector2.cross(vector1, vector2);
        vector2.normalize();
        vector2.cross(vector1, vector2);
        vector2.normalize();
        if (ref.dot(vector2) < 0.0) {
            vector2.negate();
        }
        return vector2;
    }

    private Vector3d getReferenceAxisCylic() {
        Vector3d vmin = null;
        double dotMin = 1.0;
        for (Vector3d v : this.principalAxesOfInertia) {
            if (!(Math.abs(this.principalRotationVector.dot(v)) < dotMin)) continue;
            dotMin = Math.abs(this.principalRotationVector.dot(v));
            vmin = new Vector3d(v);
        }
        if (this.principalRotationVector.dot(vmin) < 0.0) {
            vmin.negate();
        }
        return vmin;
    }

    private static Matrix4d flipX() {
        Matrix4d rot = new Matrix4d();
        rot.m00 = 1.0;
        rot.m11 = -1.0;
        rot.m22 = -1.0;
        rot.m33 = 1.0;
        return rot;
    }

    private static Matrix4d flipY() {
        Matrix4d rot = new Matrix4d();
        rot.m00 = -1.0;
        rot.m11 = 1.0;
        rot.m22 = -1.0;
        rot.m33 = 1.0;
        return rot;
    }

    private static Matrix4d flipZ() {
        Matrix4d rot = new Matrix4d();
        rot.m00 = -1.0;
        rot.m11 = -1.0;
        rot.m22 = 1.0;
        rot.m33 = 1.0;
        return rot;
    }
}

