/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.symmetry.core.ProteinChainExtractor;
import org.biojava.nbio.structure.symmetry.core.QuatSymmetryParameters;
import org.biojava.nbio.structure.symmetry.core.SequenceAlignmentCluster;
import org.biojava.nbio.structure.symmetry.core.UniqueSequenceList;

public class ProteinSequenceClusterer {
    private Structure structure = null;
    private Structure structure2 = null;
    private QuatSymmetryParameters parameters = null;
    private List<Atom[]> caUnaligned = new ArrayList<Atom[]>();
    private List<String> chainIds = new ArrayList<String>();
    private List<Integer> modelNumbers = new ArrayList<Integer>();
    private List<String> sequences = new ArrayList<String>();
    private List<SequenceAlignmentCluster> seqClusters = new ArrayList<SequenceAlignmentCluster>();
    private int nucleicAcidChainCount = 0;
    private boolean modified = true;

    public ProteinSequenceClusterer(Structure structure, QuatSymmetryParameters parameters) {
        this.structure = structure;
        this.parameters = parameters;
    }

    public ProteinSequenceClusterer(Structure structure1, Structure structure2, QuatSymmetryParameters parameters) {
        this.structure = structure1;
        this.structure2 = structure2;
        this.parameters = parameters;
    }

    public List<SequenceAlignmentCluster> getSequenceAlignmentClusters() {
        this.run();
        return this.seqClusters;
    }

    public int getProteinChainCount() {
        this.run();
        return this.sequences.size();
    }

    public int getNucleicAcidChainCount() {
        this.run();
        return this.nucleicAcidChainCount;
    }

    public static void sortSequenceClustersBySize(List<SequenceAlignmentCluster> clusters) {
        Collections.sort(clusters, new Comparator<SequenceAlignmentCluster>(){

            @Override
            public int compare(SequenceAlignmentCluster c1, SequenceAlignmentCluster c2) {
                int sign = Math.round(Math.signum(c2.getSequenceCount() - c1.getSequenceCount()));
                if (sign != 0) {
                    return sign;
                }
                return Math.round(Math.signum(c2.getSequenceAlignmentLength() - c1.getSequenceAlignmentLength()));
            }
        });
    }

    private void run() {
        if (this.modified) {
            this.extractProteinChains();
            this.clusterChains();
            this.modified = false;
        }
    }

    private void extractProteinChains() {
        ProteinChainExtractor extractor = new ProteinChainExtractor(this.structure, this.parameters);
        this.caUnaligned = extractor.getCalphaTraces();
        this.chainIds = extractor.getChainIds();
        this.sequences = extractor.getSequences();
        this.modelNumbers = extractor.getModelNumbers();
        this.nucleicAcidChainCount = extractor.getNucleicAcidChainCount();
        if (this.structure2 != null) {
            extractor = new ProteinChainExtractor(this.structure2, this.parameters);
            this.caUnaligned.addAll(extractor.getCalphaTraces());
            this.chainIds.addAll(extractor.getChainIds());
            this.sequences.addAll(extractor.getSequences());
            this.modelNumbers.addAll(extractor.getModelNumbers());
        }
    }

    private void clusterChains() {
        boolean[] processed = new boolean[this.caUnaligned.size()];
        Arrays.fill(processed, false);
        for (int i = 0; i < this.caUnaligned.size(); ++i) {
            if (processed[i]) continue;
            processed[i] = true;
            UniqueSequenceList seqList = new UniqueSequenceList(this.caUnaligned.get(i), this.chainIds.get(i), this.modelNumbers.get(i), 0, this.sequences.get(i));
            SequenceAlignmentCluster seqCluster = new SequenceAlignmentCluster(this.parameters);
            seqCluster.addUniqueSequenceList(seqList);
            this.seqClusters.add(seqCluster);
            block1: for (int j = i + 1; j < this.caUnaligned.size(); ++j) {
                if (processed[j]) continue;
                for (SequenceAlignmentCluster c : this.seqClusters) {
                    if (!c.identityMatch(this.caUnaligned.get(j), this.chainIds.get(j), this.modelNumbers.get(j), 0, this.sequences.get(j))) continue;
                    processed[j] = true;
                    continue block1;
                }
            }
        }
        ProteinSequenceClusterer.sortSequenceClustersBySize(this.seqClusters);
    }
}

