/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.AtomIterator;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.SVDSuperimposer;
import org.biojava.nbio.structure.StandardAminoAcid;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.jama.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Calc {
    private static final Logger logger = LoggerFactory.getLogger(Calc.class);

    public static final double getDistance(Atom a, Atom b) {
        double x = a.getX() - b.getX();
        double y = a.getY() - b.getY();
        double z = a.getZ() - b.getZ();
        double s = x * x + y * y + z * z;
        return Math.sqrt(s);
    }

    public static double getDistanceFast(Atom a, Atom b) {
        double x = a.getX() - b.getX();
        double y = a.getY() - b.getY();
        double z = a.getZ() - b.getZ();
        return x * x + y * y + z * z;
    }

    public static final Atom invert(Atom a) {
        double[] coords = new double[]{0.0, 0.0, 0.0};
        AtomImpl zero = new AtomImpl();
        zero.setCoords(coords);
        return Calc.subtract(zero, a);
    }

    public static final Atom add(Atom a, Atom b) {
        AtomImpl c = new AtomImpl();
        c.setX(a.getX() + b.getX());
        c.setY(a.getY() + b.getY());
        c.setZ(a.getZ() + b.getZ());
        return c;
    }

    public static final Atom subtract(Atom a, Atom b) {
        AtomImpl c = new AtomImpl();
        c.setX(a.getX() - b.getX());
        c.setY(a.getY() - b.getY());
        c.setZ(a.getZ() - b.getZ());
        return c;
    }

    public static final Atom vectorProduct(Atom a, Atom b) {
        AtomImpl c = new AtomImpl();
        c.setX(a.getY() * b.getZ() - a.getZ() * b.getY());
        c.setY(a.getZ() * b.getX() - a.getX() * b.getZ());
        c.setZ(a.getX() * b.getY() - a.getY() * b.getX());
        return c;
    }

    public static final double scalarProduct(Atom a, Atom b) {
        return a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ();
    }

    public static final double amount(Atom a) {
        return Math.sqrt(Calc.scalarProduct(a, a));
    }

    public static final double angle(Atom a, Atom b) {
        Vector3d va = new Vector3d(a.getCoords());
        Vector3d vb = new Vector3d(b.getCoords());
        return Math.toDegrees(va.angle(vb));
    }

    public static final Atom unitVector(Atom a) {
        double amount = Calc.amount(a);
        double[] coords = new double[]{a.getX() / amount, a.getY() / amount, a.getZ() / amount};
        a.setCoords(coords);
        return a;
    }

    public static final double torsionAngle(Atom a, Atom b, Atom c, Atom d) {
        Atom ab = Calc.subtract(a, b);
        Atom cb = Calc.subtract(c, b);
        Atom bc = Calc.subtract(b, c);
        Atom dc = Calc.subtract(d, c);
        Atom abc = Calc.vectorProduct(ab, cb);
        Atom bcd = Calc.vectorProduct(bc, dc);
        double angl = Calc.angle(abc, bcd);
        Atom vecprod = Calc.vectorProduct(abc, bcd);
        double val = Calc.scalarProduct(cb, vecprod);
        if (val < 0.0) {
            angl = -angl;
        }
        return angl;
    }

    public static final double getPhi(AminoAcid a, AminoAcid b) throws StructureException {
        if (!Calc.isConnected(a, b)) {
            throw new StructureException("can not calc Phi - AminoAcids are not connected!");
        }
        Atom a_C = a.getC();
        Atom b_N = b.getN();
        Atom b_CA = b.getCA();
        Atom b_C = b.getC();
        if (b_CA == null) {
            throw new StructureException("Can not calculate Phi, CA atom is missing");
        }
        return Calc.torsionAngle(a_C, b_N, b_CA, b_C);
    }

    public static final double getPsi(AminoAcid a, AminoAcid b) throws StructureException {
        if (!Calc.isConnected(a, b)) {
            throw new StructureException("can not calc Psi - AminoAcids are not connected!");
        }
        Atom a_N = a.getN();
        Atom a_CA = a.getCA();
        Atom a_C = a.getC();
        Atom b_N = b.getN();
        if (a_CA == null) {
            throw new StructureException("Can not calculate Psi, CA atom is missing");
        }
        return Calc.torsionAngle(a_N, a_CA, a_C, b_N);
    }

    public static final boolean isConnected(AminoAcid a, AminoAcid b) {
        Atom C = null;
        Atom N = null;
        C = a.getC();
        N = b.getN();
        if (C == null || N == null) {
            return false;
        }
        double distance = Calc.getDistance(C, N);
        return distance < 2.5;
    }

    public static final void rotate(Atom atom, double[][] m) {
        double x = atom.getX();
        double y = atom.getY();
        double z = atom.getZ();
        double nx = m[0][0] * x + m[0][1] * y + m[0][2] * z;
        double ny = m[1][0] * x + m[1][1] * y + m[1][2] * z;
        double nz = m[2][0] * x + m[2][1] * y + m[2][2] * z;
        atom.setX(nx);
        atom.setY(ny);
        atom.setZ(nz);
    }

    public static final void rotate(Structure structure, double[][] rotationmatrix) throws StructureException {
        if (rotationmatrix.length != 3) {
            throw new StructureException("matrix does not have size 3x3 !");
        }
        AtomIterator iter = new AtomIterator(structure);
        while (iter.hasNext()) {
            Atom atom = iter.next();
            Calc.rotate(atom, rotationmatrix);
        }
    }

    public static final void rotate(Group group, double[][] rotationmatrix) throws StructureException {
        if (rotationmatrix.length != 3) {
            throw new StructureException("matrix does not have size 3x3 !");
        }
        AtomIterator iter = new AtomIterator(group);
        while (iter.hasNext()) {
            Atom atom = null;
            atom = iter.next();
            Calc.rotate(atom, rotationmatrix);
        }
    }

    public static final void rotate(Atom atom, Matrix m) {
        double x = atom.getX();
        double y = atom.getY();
        double z = atom.getZ();
        double[][] ad = new double[][]{{x, y, z}};
        Matrix am = new Matrix(ad);
        Matrix na = am.times(m);
        atom.setX(na.get(0, 0));
        atom.setY(na.get(0, 1));
        atom.setZ(na.get(0, 2));
    }

    public static final void rotate(Group group, Matrix m) {
        AtomIterator iter = new AtomIterator(group);
        while (iter.hasNext()) {
            Atom atom = iter.next();
            Calc.rotate(atom, m);
        }
    }

    public static final void rotate(Structure structure, Matrix m) {
        AtomIterator iter = new AtomIterator(structure);
        while (iter.hasNext()) {
            Atom atom = iter.next();
            Calc.rotate(atom, m);
        }
    }

    public static void transform(Atom[] ca, Matrix4d t) {
        for (Atom atom : ca) {
            Calc.transform(atom, t);
        }
    }

    public static final void transform(Atom atom, Matrix4d m) {
        Point3d p = new Point3d(atom.getX(), atom.getY(), atom.getZ());
        m.transform(p);
        atom.setX(p.x);
        atom.setY(p.y);
        atom.setZ(p.z);
    }

    public static final void transform(Group group, Matrix4d m) {
        AtomIterator iter = new AtomIterator(group);
        while (iter.hasNext()) {
            Atom atom = iter.next();
            Calc.transform(atom, m);
        }
    }

    public static final void transform(Structure structure, Matrix4d m) {
        AtomIterator iter = new AtomIterator(structure);
        while (iter.hasNext()) {
            Atom atom = iter.next();
            Calc.transform(atom, m);
        }
    }

    public static final void transform(Chain chain, Matrix4d m) {
        for (Group g : chain.getAtomGroups()) {
            for (Atom atom : g.getAtoms()) {
                Calc.transform(atom, m);
            }
        }
    }

    public static final void translate(Atom atom, Vector3d v) {
        atom.setX(atom.getX() + v.x);
        atom.setY(atom.getY() + v.y);
        atom.setZ(atom.getZ() + v.z);
    }

    public static final void translate(Group group, Vector3d v) {
        AtomIterator iter = new AtomIterator(group);
        while (iter.hasNext()) {
            Atom atom = iter.next();
            Calc.translate(atom, v);
        }
    }

    public static final void translate(Chain chain, Vector3d v) {
        for (Group g : chain.getAtomGroups()) {
            for (Atom atom : g.getAtoms()) {
                Calc.translate(atom, v);
            }
        }
    }

    public static final void translate(Structure structure, Vector3d v) {
        AtomIterator iter = new AtomIterator(structure);
        while (iter.hasNext()) {
            Atom atom = iter.next();
            Calc.translate(atom, v);
        }
    }

    public static final void plus(Structure s, Matrix matrix) {
        AtomIterator iter = new AtomIterator(s);
        Atom oldAtom = null;
        Atom rotOldAtom = null;
        while (iter.hasNext()) {
            Atom atom = null;
            atom = iter.next();
            try {
                if (oldAtom != null) {
                    logger.debug("before {}", (Object)Calc.getDistance(oldAtom, atom));
                }
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
            oldAtom = (Atom)atom.clone();
            double x = atom.getX();
            double y = atom.getY();
            double z = atom.getZ();
            double[][] ad = new double[][]{{x, y, z}};
            Matrix am = new Matrix(ad);
            Matrix na = am.plus(matrix);
            double[] coords = new double[]{na.get(0, 0), na.get(0, 1), na.get(0, 2)};
            atom.setCoords(coords);
            try {
                if (rotOldAtom != null) {
                    logger.debug("after {}", (Object)Calc.getDistance(rotOldAtom, atom));
                }
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
            rotOldAtom = (Atom)atom.clone();
        }
    }

    public static final void shift(Structure structure, Atom a) {
        AtomIterator iter = new AtomIterator(structure);
        while (iter.hasNext()) {
            Atom atom = null;
            atom = iter.next();
            Atom natom = Calc.add(atom, a);
            double x = natom.getX();
            double y = natom.getY();
            double z = natom.getZ();
            atom.setX(x);
            atom.setY(y);
            atom.setZ(z);
        }
    }

    public static final void shift(Atom a, Atom b) {
        Atom natom = Calc.add(a, b);
        double x = natom.getX();
        double y = natom.getY();
        double z = natom.getZ();
        a.setX(x);
        a.setY(y);
        a.setZ(z);
    }

    public static final void shift(Group group, Atom a) {
        AtomIterator iter = new AtomIterator(group);
        while (iter.hasNext()) {
            Atom atom = null;
            atom = iter.next();
            Atom natom = Calc.add(atom, a);
            double x = natom.getX();
            double y = natom.getY();
            double z = natom.getZ();
            atom.setX(x);
            atom.setY(y);
            atom.setZ(z);
        }
    }

    public static final Atom getCentroid(Atom[] atomSet) {
        if (atomSet.length == 0) {
            throw new IllegalArgumentException("Atom array has length 0, can't calculate centroid!");
        }
        double[] coords = new double[]{0.0, 0.0, 0.0};
        for (Atom a : atomSet) {
            coords[0] = coords[0] + a.getX();
            coords[1] = coords[1] + a.getY();
            coords[2] = coords[2] + a.getZ();
        }
        int n = atomSet.length;
        coords[0] = coords[0] / (double)n;
        coords[1] = coords[1] / (double)n;
        coords[2] = coords[2] / (double)n;
        AtomImpl vec = new AtomImpl();
        vec.setCoords(coords);
        return vec;
    }

    public static Atom centerOfMass(Atom[] points) {
        Atom center = new AtomImpl();
        float totalMass = 0.0f;
        for (Atom a : points) {
            float mass = a.getElement().getAtomicMass();
            totalMass += mass;
            center = Calc.scaleAdd(mass, a, center);
        }
        center = Calc.scaleEquals(center, 1.0f / totalMass);
        return center;
    }

    public static Atom scaleEquals(Atom a, double s) {
        double x = a.getX();
        double y = a.getY();
        double z = a.getZ();
        a.setX(x *= s);
        a.setY(y *= s);
        a.setZ(z *= s);
        return a;
    }

    public static Atom scale(Atom a, double s) {
        double x = a.getX();
        double y = a.getY();
        double z = a.getZ();
        AtomImpl b = new AtomImpl();
        b.setX(x * s);
        b.setY(y * s);
        b.setZ(z * s);
        return b;
    }

    public static Atom scaleAdd(double s, Atom x, Atom b) {
        double xc = s * x.getX() + b.getX();
        double yc = s * x.getY() + b.getY();
        double zc = s * x.getZ() + b.getZ();
        b.setX(xc);
        b.setY(yc);
        b.setZ(zc);
        return b;
    }

    public static final Atom getCenterVector(Atom[] atomSet) {
        Atom centroid = Calc.getCentroid(atomSet);
        return Calc.getCenterVector(atomSet, centroid);
    }

    public static final Atom getCenterVector(Atom[] atomSet, Atom centroid) {
        double[] coords = new double[]{0.0 - centroid.getX(), 0.0 - centroid.getY(), 0.0 - centroid.getZ()};
        AtomImpl shiftVec = new AtomImpl();
        shiftVec.setCoords(coords);
        return shiftVec;
    }

    public static final Atom[] centerAtoms(Atom[] atomSet) throws StructureException {
        Atom centroid = Calc.getCentroid(atomSet);
        return Calc.centerAtoms(atomSet, centroid);
    }

    public static final Atom[] centerAtoms(Atom[] atomSet, Atom centroid) throws StructureException {
        Atom shiftVector = Calc.getCenterVector(atomSet, centroid);
        Atom[] newAtoms = new AtomImpl[atomSet.length];
        for (int i = 0; i < atomSet.length; ++i) {
            Atom n;
            Atom a = atomSet[i];
            newAtoms[i] = n = Calc.add(a, shiftVector);
        }
        return newAtoms;
    }

    public static final Atom createVirtualCBAtom(AminoAcid amino) throws StructureException {
        AminoAcid ala = StandardAminoAcid.getAminoAcid("ALA");
        Atom aN = ala.getN();
        Atom aCA = ala.getCA();
        Atom aC = ala.getC();
        Atom aCB = ala.getCB();
        Atom[] arr1 = new Atom[]{aN, aCA, aC};
        Atom[] arr2 = new Atom[]{amino.getN(), amino.getCA(), amino.getC()};
        SVDSuperimposer svd = new SVDSuperimposer(arr2, arr1);
        Matrix rotMatrix = svd.getRotation();
        Atom tranMatrix = svd.getTranslation();
        Calc.rotate(aCB, rotMatrix);
        Atom virtualCB = Calc.add(aCB, tranMatrix);
        virtualCB.setName("CB");
        return virtualCB;
    }

    public static final double[] getZYZEuler(Matrix m) {
        double rZ2;
        double rZ1;
        double m22 = m.get(2, 2);
        double rY = Math.toDegrees(Math.acos(m22));
        if (m22 > 0.999 || m22 < -0.999) {
            rZ1 = Math.toDegrees(Math.atan2(m.get(1, 0), m.get(1, 1)));
            rZ2 = 0.0;
        } else {
            rZ1 = Math.toDegrees(Math.atan2(m.get(2, 1), -m.get(2, 0)));
            rZ2 = Math.toDegrees(Math.atan2(m.get(1, 2), m.get(0, 2)));
        }
        return new double[]{rZ1, rY, rZ2};
    }

    public static final double[] getXYZEuler(Matrix m) {
        double bank;
        double attitude;
        double heading;
        if (m.get(1, 0) > 0.998) {
            heading = Math.atan2(m.get(0, 2), m.get(2, 2));
            attitude = 1.5707963267948966;
            bank = 0.0;
        } else if (m.get(1, 0) < -0.998) {
            heading = Math.atan2(m.get(0, 2), m.get(2, 2));
            attitude = -1.5707963267948966;
            bank = 0.0;
        } else {
            heading = Math.atan2(-m.get(2, 0), m.get(0, 0));
            bank = Math.atan2(-m.get(1, 2), m.get(1, 1));
            attitude = Math.asin(m.get(1, 0));
        }
        return new double[]{heading, attitude, bank};
    }

    public static final Matrix matrixFromEuler(double heading, double attitude, double bank) {
        double ch = Math.cos(heading);
        double sh = Math.sin(heading);
        double ca = Math.cos(attitude);
        double sa = Math.sin(attitude);
        double cb = Math.cos(bank);
        double sb = Math.sin(bank);
        Matrix m = new Matrix(3, 3);
        m.set(0, 0, ch * ca);
        m.set(0, 1, sh * sb - ch * sa * cb);
        m.set(0, 2, ch * sa * sb + sh * cb);
        m.set(1, 0, sa);
        m.set(1, 1, ca * cb);
        m.set(1, 2, -ca * sb);
        m.set(2, 0, -sh * ca);
        m.set(2, 1, sh * sa * cb + ch * sb);
        m.set(2, 2, -sh * sa * sb + ch * cb);
        return m;
    }

    public static double calcRotationAngleInDegrees(Atom centerPt, Atom targetPt) {
        double theta = Math.atan2(targetPt.getY() - centerPt.getY(), targetPt.getX() - centerPt.getX());
        double angle = Math.toDegrees(theta += 1.5707963267948966);
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static void main(String[] args) {
        AtomImpl a = new AtomImpl();
        a.setX(0.0);
        a.setY(0.0);
        a.setZ(0.0);
        AtomImpl b = new AtomImpl();
        b.setX(1.0);
        b.setY(1.0);
        b.setZ(0.0);
        logger.info("Angle between atoms: ", (Object)Calc.calcRotationAngleInDegrees(a, b));
    }

    public static void rotate(Atom[] ca, Matrix matrix) {
        for (Atom atom : ca) {
            Calc.rotate(atom, matrix);
        }
    }

    public static void shift(Atom[] ca, Atom b) {
        for (Atom atom : ca) {
            Calc.shift(atom, b);
        }
    }

    public static Matrix4d getTransformation(Matrix rot, Matrix trans) {
        return new Matrix4d(new Matrix3d(rot.getColumnPackedCopy()), new Vector3d(trans.getColumnPackedCopy()), 1.0);
    }

    public static Matrix4d getTransformation(Matrix rot, Atom trans) {
        return new Matrix4d(new Matrix3d(rot.getColumnPackedCopy()), new Vector3d(trans.getCoords()), 1.0);
    }

    public static Matrix getRotationMatrix(Matrix4d transform) {
        Matrix rot = new Matrix(3, 3);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                rot.set(j, i, transform.getElement(i, j));
            }
        }
        return rot;
    }

    public static Atom getTranslationVector(Matrix4d transform) {
        AtomImpl transl = new AtomImpl();
        double[] coords = new double[]{transform.m03, transform.m13, transform.m23};
        transl.setCoords(coords);
        return transl;
    }

    public static Point3d[] atomsToPoints(Atom[] atoms) {
        Point3d[] points = new Point3d[atoms.length];
        for (int i = 0; i < atoms.length; ++i) {
            points[i] = new Point3d(atoms[i].getCoords());
        }
        return points;
    }
}

