/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.Compound;
import org.biojava.nbio.structure.DBRef;
import org.biojava.nbio.structure.ExperimentalTechnique;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.JournalArticle;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Site;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.io.CompoundFinder;
import org.biojava.nbio.structure.io.FileConvert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureImpl
implements Structure,
Serializable {
    private static final long serialVersionUID = -8344837138032851348L;
    private static final Logger logger = LoggerFactory.getLogger(StructureImpl.class);
    private String pdb_id;
    private List<List<Chain>> models = new ArrayList<List<Chain>>();
    private List<Map<String, Integer>> connections = new ArrayList<Map<String, Integer>>();
    private List<Compound> compounds = new ArrayList<Compound>();
    private List<DBRef> dbrefs = new ArrayList<DBRef>();
    private List<Bond> ssbonds;
    private List<Site> sites;
    private List<Group> hetAtoms;
    private String name = "";
    private StructureIdentifier structureIdentifier;
    private PDBHeader pdbHeader = new PDBHeader();
    private Long id;
    private boolean biologicalAssembly;

    public StructureImpl() {
        this.ssbonds = new ArrayList<Bond>();
        this.sites = new ArrayList<Site>();
        this.hetAtoms = new ArrayList<Group>();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public StructureImpl(Group g) {
        this();
        ChainImpl c = new ChainImpl();
        c.addGroup(g);
        this.addChain(c);
    }

    public StructureImpl(Chain c) {
        this();
        this.addChain(c);
    }

    @Override
    public Structure clone() {
        StructureImpl n = new StructureImpl();
        n.setPDBCode(this.getPDBCode());
        n.setName(this.getName());
        n.setPDBHeader(this.pdbHeader);
        n.setDBRefs(this.getDBRefs());
        n.setSites(this.getSites());
        for (int i = 0; i < this.nrModels(); ++i) {
            ArrayList<Chain> cloned_model = new ArrayList<Chain>();
            for (int j = 0; j < this.size(i); ++j) {
                Chain cloned_chain = (Chain)this.getChain(i, j).clone();
                cloned_chain.setStructure(n);
                cloned_model.add(cloned_chain);
            }
            n.addModel(cloned_model);
        }
        ArrayList<Compound> newCompoundList = new ArrayList<Compound>();
        for (Compound compound : this.compounds) {
            Compound newCompound = new Compound(compound);
            for (String chainId : compound.getChainIds()) {
                for (int modelNr = 0; modelNr < n.nrModels(); ++modelNr) {
                    try {
                        Chain newChain = n.getChainByPDB(chainId, modelNr);
                        newChain.setCompound(newCompound);
                        newCompound.addChain(newChain);
                        continue;
                    }
                    catch (StructureException e) {
                        logger.warn("Could not find chain id " + chainId + " of model " + modelNr + " while cloning compound " + compound.getMolId() + ". Something is wrong!");
                    }
                }
            }
            newCompoundList.add(newCompound);
        }
        n.setCompounds(newCompoundList);
        return n;
    }

    @Override
    public Group findGroup(String chainId, String pdbResnum, int modelnr) throws StructureException {
        if (modelnr > this.models.size()) {
            throw new StructureException(" no model nr " + modelnr + " in this structure. (contains " + this.models.size() + ")");
        }
        Chain c = this.findChain(chainId, modelnr);
        List<Group> groups = c.getAtomGroups();
        for (Group g : groups) {
            String rnum = g.getResidueNumber().toString();
            if (!rnum.equals(pdbResnum)) continue;
            return g;
        }
        throw new StructureException("could not find group " + pdbResnum + " in chain " + chainId);
    }

    @Override
    public Group findGroup(String chainName, String pdbResnum) throws StructureException {
        return this.findGroup(chainName, pdbResnum, 0);
    }

    @Override
    public Chain findChain(String chainId, int modelnr) throws StructureException {
        List<Chain> chains = this.getChains(modelnr);
        for (Chain c : chains) {
            if (!c.getChainID().equals(chainId)) continue;
            return c;
        }
        throw new StructureException("Could not find chain \"" + chainId + "\" for PDB id " + this.pdb_id);
    }

    @Override
    public Chain findChain(String chainId) throws StructureException {
        return this.findChain(chainId, 0);
    }

    @Override
    public void setPDBCode(String pdb_id_) {
        this.pdb_id = pdb_id_;
    }

    @Override
    public String getPDBCode() {
        return this.pdb_id;
    }

    @Override
    public void setName(String nam) {
        this.name = nam;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public StructureIdentifier getStructureIdentifier() {
        return this.structureIdentifier;
    }

    @Override
    public void setStructureIdentifier(StructureIdentifier structureIdentifier) {
        this.structureIdentifier = structureIdentifier;
    }

    @Override
    public void setConnections(List<Map<String, Integer>> conns) {
        this.connections = conns;
    }

    @Override
    public List<Map<String, Integer>> getConnections() {
        return this.connections;
    }

    @Override
    public void addChain(Chain chain) {
        int modelnr = 0;
        this.addChain(chain, modelnr);
    }

    @Override
    public void addChain(Chain chain, int modelnr) {
        chain.setStructure(this);
        if (this.models.isEmpty()) {
            ArrayList<Chain> model = new ArrayList<Chain>();
            model.add(chain);
            this.models.add(model);
        } else {
            List<Chain> model = this.models.get(modelnr);
            model.add(chain);
        }
    }

    @Override
    public Chain getChain(int number) {
        int modelnr = 0;
        return this.getChain(modelnr, number);
    }

    @Override
    public Chain getChain(int modelnr, int number) {
        List<Chain> model = this.models.get(modelnr);
        return model.get(number);
    }

    @Override
    public void addModel(List<Chain> model) {
        for (Chain c : model) {
            c.setStructure(this);
        }
        this.models.add(model);
    }

    @Override
    public void setChains(List<Chain> chains) {
        this.setModel(0, chains);
    }

    @Override
    public void setModel(int position, List<Chain> model) {
        if (model == null) {
            throw new IllegalArgumentException("trying to set model to null!");
        }
        for (Chain c : model) {
            c.setStructure(this);
        }
        if (this.models.isEmpty()) {
            this.models.add(model);
        } else {
            this.models.set(position, model);
        }
    }

    @Override
    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder str = new StringBuilder();
        str.append("structure ");
        str.append(this.name);
        str.append(" ");
        str.append(this.pdb_id);
        str.append(" ");
        if (this.nrModels() > 1) {
            str.append(" models: ");
            str.append(this.nrModels());
            str.append(newline);
        }
        str.append(this.pdbHeader);
        str.append(newline);
        for (int i = 0; i < this.nrModels(); ++i) {
            if (this.nrModels() > 1) {
                str.append(" model[");
                str.append(i);
                str.append("]:");
                str.append(newline);
            }
            str.append(" chains:");
            str.append(newline);
            for (int j = 0; j < this.size(i); ++j) {
                Compound comp;
                String molName;
                Chain cha = this.getChain(i, j);
                List<Group> agr = cha.getAtomGroups(GroupType.AMINOACID);
                List<Group> hgr = cha.getAtomGroups(GroupType.HETATM);
                List<Group> ngr = cha.getAtomGroups(GroupType.NUCLEOTIDE);
                str.append("chain ").append(j).append(": >").append(cha.getChainID()).append("< ");
                if (cha.getCompound() != null && (molName = (comp = cha.getCompound()).getMolName()) != null) {
                    str.append(molName);
                }
                str.append(newline);
                str.append(" length SEQRES: ").append(cha.getSeqResLength());
                str.append(" length ATOM: ").append(cha.getAtomLength());
                str.append(" aminos: ").append(agr.size());
                str.append(" hetatms: ").append(hgr.size());
                str.append(" nucleotides: ").append(ngr.size()).append(newline);
            }
        }
        str.append("DBRefs: ").append(this.dbrefs.size()).append(newline);
        for (DBRef dbref : this.dbrefs) {
            str.append(dbref.toPDB()).append(newline);
        }
        str.append("Molecules: ").append(newline);
        for (Compound mol : this.compounds) {
            str.append(mol).append(newline);
        }
        return str.toString();
    }

    @Override
    public int size() {
        int modelnr = 0;
        if (!this.models.isEmpty()) {
            return this.models.get(modelnr).size();
        }
        return 0;
    }

    @Override
    public int size(int modelnr) {
        return this.getChains(modelnr).size();
    }

    @Override
    public int nrModels() {
        return this.models.size();
    }

    @Override
    public boolean isCrystallographic() {
        if (this.pdbHeader.getExperimentalTechniques() != null) {
            return ExperimentalTechnique.isCrystallographic(this.pdbHeader.getExperimentalTechniques());
        }
        if (this.pdbHeader.getCrystallographicInfo().getSpaceGroup() != null) {
            if (this.pdbHeader.getCrystallographicInfo().getCrystalCell() == null) {
                return false;
            }
            return this.pdbHeader.getCrystallographicInfo().getCrystalCell().isCellReasonable();
        }
        return false;
    }

    @Override
    public boolean isNmr() {
        if (this.pdbHeader.getExperimentalTechniques() != null) {
            return ExperimentalTechnique.isNmr(this.pdbHeader.getExperimentalTechniques());
        }
        if (this.nrModels() > 1) {
            if (this.pdbHeader.getCrystallographicInfo().getSpaceGroup() != null) {
                if (this.pdbHeader.getCrystallographicInfo().getCrystalCell() == null) {
                    return true;
                }
                if (!this.pdbHeader.getCrystallographicInfo().getCrystalCell().isCellReasonable()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public void setNmr(boolean nmr) {
    }

    @Override
    public List<Chain> getChains(int modelnr) {
        return this.getModel(modelnr);
    }

    @Override
    public List<Chain> getChains() {
        return this.getModel(0);
    }

    @Override
    public void setChains(int modelnr, List<Chain> chains) {
        for (Chain c : chains) {
            c.setStructure(this);
        }
        this.models.remove(modelnr);
        this.models.add(modelnr, chains);
    }

    @Override
    public List<Chain> getModel(int modelnr) {
        return this.models.get(modelnr);
    }

    @Override
    public Chain getChainByPDB(String chainId, int modelnr) throws StructureException {
        List<Chain> chains = this.getChains(modelnr);
        for (Chain c : chains) {
            if (!c.getChainID().equals(chainId)) continue;
            return c;
        }
        throw new StructureException("did not find chain with chainId \"" + chainId + "\"" + " for PDB id " + this.pdb_id);
    }

    @Override
    public Chain getChainByPDB(String chainId) throws StructureException {
        return this.getChainByPDB(chainId, 0);
    }

    @Override
    public String toPDB() {
        FileConvert f = new FileConvert(this);
        return f.toPDB();
    }

    @Override
    public String toMMCIF() {
        FileConvert f = new FileConvert(this);
        return f.toMMCIF();
    }

    @Override
    public boolean hasChain(String chainId) {
        int modelnr = 0;
        List<Chain> chains = this.getChains(modelnr);
        for (Chain c : chains) {
            if (!c.getChainID().equals(chainId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCompounds(List<Compound> molList) {
        this.compounds = molList;
    }

    @Override
    public void addCompound(Compound compound) {
        this.compounds.add(compound);
    }

    @Override
    public List<Compound> getCompounds() {
        if (this.compounds == null || this.compounds.isEmpty()) {
            CompoundFinder cf = new CompoundFinder(this);
            this.compounds = cf.findCompounds();
            for (Compound compound : this.compounds) {
                for (Chain c : compound.getChains()) {
                    c.setCompound(compound);
                }
            }
        }
        return this.compounds;
    }

    @Override
    public Compound getCompoundById(int molId) {
        for (Compound mol : this.compounds) {
            if (mol.getMolId() != molId) continue;
            return mol;
        }
        return null;
    }

    @Override
    public List<DBRef> getDBRefs() {
        return this.dbrefs;
    }

    @Override
    public void setDBRefs(List<DBRef> dbrefs) {
        if (dbrefs == null) {
            throw new IllegalArgumentException("trying to set dbrefs to null!");
        }
        for (DBRef ref : dbrefs) {
            ref.setParent(this);
        }
        this.dbrefs = dbrefs;
    }

    @Override
    public PDBHeader getPDBHeader() {
        return this.pdbHeader;
    }

    @Override
    public void setPDBHeader(PDBHeader pdbHeader) {
        this.pdbHeader = pdbHeader;
    }

    @Override
    public List<Bond> getSSBonds() {
        return this.ssbonds;
    }

    @Override
    public void setSSBonds(List<Bond> ssbonds) {
        this.ssbonds = ssbonds;
    }

    @Override
    public void addSSBond(Bond ssbond) {
        this.ssbonds.add(ssbond);
    }

    @Override
    public boolean hasJournalArticle() {
        return this.pdbHeader.hasJournalArticle();
    }

    @Override
    public JournalArticle getJournalArticle() {
        return this.pdbHeader.getJournalArticle();
    }

    @Override
    public void setJournalArticle(JournalArticle journalArticle) {
        this.pdbHeader.setJournalArticle(journalArticle);
    }

    @Override
    public List<Site> getSites() {
        return this.sites;
    }

    @Override
    public void setSites(List<Site> sites) {
        this.sites = sites;
    }

    @Override
    public List<Group> getHetGroups() {
        return this.hetAtoms;
    }

    @Override
    public void setBiologicalAssembly(boolean biologicalAssembly) {
        this.biologicalAssembly = biologicalAssembly;
    }

    @Override
    public boolean isBiologicalAssembly() {
        return this.biologicalAssembly;
    }

    @Override
    public void setCrystallographicInfo(PDBCrystallographicInfo crystallographicInfo) {
        this.pdbHeader.setCrystallographicInfo(crystallographicInfo);
    }

    @Override
    public PDBCrystallographicInfo getCrystallographicInfo() {
        return this.pdbHeader.getCrystallographicInfo();
    }

    @Override
    public String getIdentifier() {
        if (this.getStructureIdentifier() != null) {
            return this.getStructureIdentifier().getIdentifier();
        }
        if (this.getName() != null) {
            return this.getName();
        }
        return this.toCanonical().getIdentifier();
    }

    @Override
    @Deprecated
    public String getPdbId() {
        return this.pdb_id;
    }

    @Override
    public void resetModels() {
        this.models = new ArrayList<List<Chain>>();
    }

    @Deprecated
    public List<ResidueRange> getResidueRanges() {
        return this.toCanonical().getResidueRanges();
    }

    @Override
    @Deprecated
    public List<String> getRanges() {
        return ResidueRange.toStrings(this.getResidueRanges());
    }

    private SubstructureIdentifier toCanonical() {
        StructureIdentifier real = this.getStructureIdentifier();
        if (real != null) {
            try {
                return real.toCanonical();
            }
            catch (StructureException structureException) {
                // empty catch block
            }
        }
        ArrayList<ResidueRange> range = new ArrayList<ResidueRange>();
        for (Chain chain : this.getChains()) {
            List<Group> groups = chain.getAtomGroups();
            ListIterator<Group> groupsIt = groups.listIterator();
            if (!groupsIt.hasNext()) continue;
            Group g = groupsIt.next();
            ResidueNumber first = g.getResidueNumber();
            while (groupsIt.hasNext()) {
                g = groupsIt.next();
            }
            ResidueNumber last = g.getResidueNumber();
            range.add(new ResidueRange(chain.getChainID(), first, last));
        }
        return new SubstructureIdentifier(this.getPDBCode(), range);
    }
}

