/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.cluster.Subunit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubunitExtractor {
    private static final Logger logger = LoggerFactory.getLogger(SubunitExtractor.class);

    private SubunitExtractor() {
    }

    public static List<Subunit> extractSubunits(Structure structure, int absMinLen, double fraction, int minLen) {
        ArrayList<Subunit> subunits = new ArrayList<Subunit>();
        for (Chain c : structure.getPolyChains()) {
            if (!c.isProtein()) continue;
            Atom[] ca = StructureTools.getRepresentativeAtomArray(c);
            logger.debug("Chain " + c.getId() + "; CA Atoms: " + ca.length + "; SEQRES: " + c.getSeqResSequence());
            if (ca.length == 0) continue;
            subunits.add(new Subunit(ca, c.getName(), null, structure));
        }
        int adjustedMinLen = SubunitExtractor.calcAdjustedMinimumSequenceLength(subunits, absMinLen, fraction, minLen);
        logger.debug("Adjusted minimum sequence length: " + adjustedMinLen);
        for (int s = subunits.size() - 1; s >= 0; --s) {
            if (((Subunit)subunits.get(s)).size() >= adjustedMinLen) continue;
            subunits.remove(s);
        }
        return subunits;
    }

    private static int calcAdjustedMinimumSequenceLength(List<Subunit> subunits, int absMinLen, double fraction, int minLen) {
        int maxLength = Integer.MIN_VALUE;
        int minLength = Integer.MAX_VALUE;
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (int i = 0; i < subunits.size(); ++i) {
            if (subunits.get(i).size() < absMinLen) continue;
            maxLength = Math.max(subunits.get(i).size(), maxLength);
            minLength = Math.min(subunits.get(i).size(), minLength);
            lengths.add(subunits.get(i).size());
        }
        int adjustedMinimumSequenceLength = minLen;
        if (lengths.size() < 2) {
            return adjustedMinimumSequenceLength;
        }
        double median = 0.0;
        Collections.sort(lengths);
        if (lengths.size() % 2 == 1) {
            int middle = (lengths.size() - 1) / 2;
            median = ((Integer)lengths.get(middle)).intValue();
        } else {
            int middle2 = lengths.size() / 2;
            int middle1 = middle2 - 1;
            median = 0.5 * (double)((Integer)lengths.get(middle1) + (Integer)lengths.get(middle2));
        }
        if ((double)minLength >= median * fraction) {
            adjustedMinimumSequenceLength = Math.min(minLength, minLen);
        }
        return adjustedMinimumSequenceLength;
    }
}

