/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.domain;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.client.JFatCatClient;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.align.util.URLConnectionTools;
import org.biojava.nbio.structure.domain.AssignmentXMLSerializer;
import org.biojava.nbio.structure.domain.PDPDomain;
import org.biojava.nbio.structure.domain.PDPProvider;
import org.biojava.nbio.structure.domain.SerializableCache;
import org.biojava.nbio.structure.scop.server.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePDPProvider
extends SerializableCache<String, SortedSet<String>>
implements PDPProvider {
    private static final Logger logger = LoggerFactory.getLogger(RemotePDPProvider.class);
    public static final String DEFAULT_SERVER = "http://source.rcsb.org/jfatcatserver/domains/";
    String server = "http://source.rcsb.org/jfatcatserver/domains/";
    private static String CACHE_FILE_NAME = "remotepdpdomaindefs.ser";

    public static void main(String[] args) throws IOException, StructureException {
        RemotePDPProvider me = new RemotePDPProvider(true);
        SortedSet<String> pdpdomains = me.getPDPDomainNamesForPDB("4HHB");
        System.out.println(pdpdomains);
        AtomCache cache = new AtomCache();
        Structure s = me.getDomain(pdpdomains.first(), cache);
        System.out.println(s);
        me.flushCache();
    }

    public RemotePDPProvider() {
        super(CACHE_FILE_NAME);
        this.disableCache();
    }

    public RemotePDPProvider(boolean useCache) throws IOException {
        super(CACHE_FILE_NAME);
        if (!useCache) {
            this.disableCache();
        } else {
            this.loadRepresentativeDomains();
        }
    }

    private void loadRepresentativeDomains() throws IOException {
        AssignmentXMLSerializer results = null;
        try {
            URL u = new URL(this.server + "getRepresentativePDPDomains");
            logger.info("Fetching {}", (Object)u);
            InputStream response = URLConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            results = AssignmentXMLSerializer.fromXML(xml);
            Map<String, String> data = results.getAssignments();
            logger.info("got {} domain ranges for PDP domains from server.", (Object)data.size());
            for (String key : data.keySet()) {
                String range = data.get(key);
                String[] spl = range.split(",");
                TreeSet<String> value = new TreeSet<String>();
                for (String s : spl) {
                    value.add(s);
                }
                this.serializedCache.put(key, value);
            }
        }
        catch (MalformedURLException e) {
            logger.error("Malformed PDP server: " + this.server, (Throwable)e);
            throw new IllegalArgumentException("Invalid Server: " + this.server, e);
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    @Override
    public Structure getDomain(String pdpDomainName, AtomCache cache) throws IOException, StructureException {
        return cache.getStructure(this.getPDPDomain(pdpDomainName));
    }

    @Override
    public PDPDomain getPDPDomain(String pdpDomainName) throws IOException {
        SortedSet<String> domainRanges = null;
        if (this.serializedCache != null && this.serializedCache.containsKey(pdpDomainName)) {
            domainRanges = (SortedSet<String>)this.serializedCache.get(pdpDomainName);
        }
        boolean shouldRequestDomainRanges = this.checkDomainRanges(domainRanges);
        try {
            if (shouldRequestDomainRanges) {
                URL u = new URL(this.server + "getPDPDomain?pdpId=" + pdpDomainName);
                logger.info("Fetching {}", (Object)u);
                InputStream response = URLConnectionTools.getInputStream(u);
                String xml = JFatCatClient.convertStreamToString(response);
                domainRanges = XMLUtil.getDomainRangesFromXML(xml);
                if (domainRanges != null) {
                    this.cache(pdpDomainName, domainRanges);
                }
            }
        }
        catch (MalformedURLException e) {
            logger.error("Problem generating PDP request URL for " + pdpDomainName, (Throwable)e);
            throw new IllegalArgumentException("Invalid PDP name: " + pdpDomainName, e);
        }
        String pdbId = null;
        ArrayList<ResidueRange> ranges = new ArrayList<ResidueRange>();
        for (String domainRange : domainRanges) {
            SubstructureIdentifier strucId = new SubstructureIdentifier(domainRange);
            if (pdbId == null) {
                pdbId = strucId.getPdbId();
            } else if (!pdbId.equals(strucId.getPdbId())) {
                throw new RuntimeException("Don't know how to take the union of domains from multiple PDB IDs.");
            }
            ranges.addAll(strucId.getResidueRanges());
        }
        return new PDPDomain(pdpDomainName, ranges);
    }

    private boolean checkDomainRanges(SortedSet<String> domainRanges) {
        if (domainRanges == null || domainRanges.size() == 0) {
            return true;
        }
        for (String d : domainRanges) {
            if (d == null || d.length() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public SortedSet<String> getPDPDomainNamesForPDB(String pdbId) throws IOException {
        SortedSet<String> results = null;
        try {
            URL u = new URL(this.server + "getPDPDomainNamesForPDB?pdbId=" + pdbId);
            logger.info("Fetching {}", (Object)u);
            InputStream response = URLConnectionTools.getInputStream(u);
            String xml = JFatCatClient.convertStreamToString(response);
            results = XMLUtil.getDomainRangesFromXML(xml);
        }
        catch (MalformedURLException e) {
            logger.error("Problem generating PDP request URL for " + pdbId, (Throwable)e);
            throw new IllegalArgumentException("Invalid PDB name: " + pdbId, e);
        }
        return results;
    }
}

