/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.quaternary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.quaternary.OperatorResolver;
import org.biojava.nbio.structure.quaternary.OrderedPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiologicalAssemblyBuilder {
    private static final Logger logger = LoggerFactory.getLogger(BiologicalAssemblyBuilder.class);
    private OperatorResolver operatorResolver;
    private Map<String, Matrix4d> allTransformations;
    private List<String> modelIndex = new ArrayList<String>();

    public BiologicalAssemblyBuilder() {
        this.init();
    }

    public Structure rebuildQuaternaryStructure(Structure asymUnit, List<BiologicalAssemblyTransformation> transformations, boolean useAsymIds, boolean multiModel) {
        this.orderTransformationsByChainId(asymUnit, transformations);
        Structure s = asymUnit.clone();
        s.resetModels();
        for (BiologicalAssemblyTransformation transformation : transformations) {
            ArrayList<Chain> chainsToTransform = new ArrayList<Chain>();
            if (useAsymIds) {
                Chain c = asymUnit.getChain(transformation.getChainId());
                chainsToTransform.add(c);
            } else {
                Chain polyC = asymUnit.getPolyChainByPDB(transformation.getChainId());
                List<Chain> nonPolyCs = asymUnit.getNonPolyChainsByPDB(transformation.getChainId());
                Chain waterC = asymUnit.getWaterChainByPDB(transformation.getChainId());
                if (polyC != null) {
                    chainsToTransform.add(polyC);
                }
                if (!nonPolyCs.isEmpty()) {
                    chainsToTransform.addAll(nonPolyCs);
                }
                if (waterC != null) {
                    chainsToTransform.add(waterC);
                }
            }
            for (Chain c : chainsToTransform) {
                Chain chain = (Chain)c.clone();
                Calc.transform(chain, transformation.getTransformationMatrix());
                String transformId = transformation.getId();
                if (multiModel) {
                    this.addChainMultiModel(s, chain, transformId);
                    continue;
                }
                this.addChainFlattened(s, chain, transformId);
            }
        }
        s.setBiologicalAssembly(true);
        return s;
    }

    private void orderTransformationsByChainId(Structure asymUnit, List<BiologicalAssemblyTransformation> transformations) {
        final List<String> chainIds = this.getChainIds(asymUnit);
        Collections.sort(transformations, new Comparator<BiologicalAssemblyTransformation>(){

            @Override
            public int compare(BiologicalAssemblyTransformation t1, BiologicalAssemblyTransformation t2) {
                if (t1.getId().equals(t2.getId())) {
                    return chainIds.indexOf(t1.getChainId()) - chainIds.indexOf(t2.getChainId());
                }
                return t1.getId().compareTo(t2.getId());
            }
        });
    }

    private List<String> getChainIds(Structure asymUnit) {
        ArrayList<String> chainIds = new ArrayList<String>();
        for (Chain c : asymUnit.getChains()) {
            String intChainID = c.getId();
            chainIds.add(intChainID);
        }
        return chainIds;
    }

    private void addChainMultiModel(Structure s, Chain newChain, String transformId) {
        int modelCount;
        if (this.modelIndex.size() == 0) {
            this.modelIndex.add("PLACEHOLDER FOR ASYM UNIT");
        }
        if ((modelCount = this.modelIndex.indexOf(transformId)) == -1) {
            this.modelIndex.add(transformId);
            modelCount = this.modelIndex.indexOf(transformId);
        }
        if (modelCount == 0) {
            s.addChain(newChain);
        } else if (modelCount > s.nrModels()) {
            ArrayList<Chain> newModel = new ArrayList<Chain>();
            newModel.add(newChain);
            s.addModel(newModel);
        } else {
            s.addChain(newChain, modelCount - 1);
        }
    }

    private void addChainFlattened(Structure s, Chain newChain, String transformId) {
        newChain.setId(newChain.getId() + "_" + transformId);
        newChain.setName(newChain.getName() + "_" + transformId);
        s.addChain(newChain);
    }

    public ArrayList<BiologicalAssemblyTransformation> getBioUnitTransformationList(PdbxStructAssembly psa, List<PdbxStructAssemblyGen> psags, List<PdbxStructOperList> operators) {
        this.init();
        for (PdbxStructOperList oper : operators) {
            try {
                Matrix4d m = new Matrix4d();
                m.m00 = Double.parseDouble(oper.getMatrix11());
                m.m01 = Double.parseDouble(oper.getMatrix12());
                m.m02 = Double.parseDouble(oper.getMatrix13());
                m.m10 = Double.parseDouble(oper.getMatrix21());
                m.m11 = Double.parseDouble(oper.getMatrix22());
                m.m12 = Double.parseDouble(oper.getMatrix23());
                m.m20 = Double.parseDouble(oper.getMatrix31());
                m.m21 = Double.parseDouble(oper.getMatrix32());
                m.m22 = Double.parseDouble(oper.getMatrix33());
                m.m03 = Double.parseDouble(oper.getVector1());
                m.m13 = Double.parseDouble(oper.getVector2());
                m.m23 = Double.parseDouble(oper.getVector3());
                m.m30 = 0.0;
                m.m31 = 0.0;
                m.m32 = 0.0;
                m.m33 = 1.0;
                this.allTransformations.put(oper.getId(), m);
            }
            catch (NumberFormatException e) {
                logger.warn("Could not parse a matrix value from pdbx_struct_oper_list for id {}. The operator id will be ignored. Error: {}", (Object)oper.getId(), (Object)e.getMessage());
            }
        }
        ArrayList<BiologicalAssemblyTransformation> transformations = this.getBioUnitTransformationsListUnaryOperators(psa.getId(), psags);
        transformations.addAll(this.getBioUnitTransformationsListBinaryOperators(psa.getId(), psags));
        transformations.trimToSize();
        return transformations;
    }

    private ArrayList<BiologicalAssemblyTransformation> getBioUnitTransformationsListBinaryOperators(String assemblyId, List<PdbxStructAssemblyGen> psags) {
        ArrayList<BiologicalAssemblyTransformation> transformations = new ArrayList<BiologicalAssemblyTransformation>();
        List<OrderedPair<String>> operators = this.operatorResolver.getBinaryOperators();
        for (PdbxStructAssemblyGen psag : psags) {
            if (!psag.getAssembly_id().equals(assemblyId)) continue;
            List<String> asymIds = Arrays.asList(psag.getAsym_id_list().split(","));
            this.operatorResolver.parseOperatorExpressionString(psag.getOper_expression());
            for (String chainId : asymIds) {
                for (OrderedPair<String> operator : operators) {
                    Matrix4d original1 = this.allTransformations.get(operator.getElement1());
                    Matrix4d original2 = this.allTransformations.get(operator.getElement2());
                    if (original1 == null || original2 == null) {
                        logger.warn("Could not find matrix operator for operator id {} or {}. Assembly id {} will not contain the composed operator.", new Object[]{operator.getElement1(), operator.getElement2(), assemblyId});
                        continue;
                    }
                    Matrix4d composed = new Matrix4d(original1);
                    composed.mul(original2);
                    BiologicalAssemblyTransformation transform = new BiologicalAssemblyTransformation();
                    transform.setChainId(chainId);
                    transform.setId(operator.getElement1() + "x" + operator.getElement2());
                    transform.setTransformationMatrix(composed);
                    transformations.add(transform);
                }
            }
        }
        return transformations;
    }

    private ArrayList<BiologicalAssemblyTransformation> getBioUnitTransformationsListUnaryOperators(String assemblyId, List<PdbxStructAssemblyGen> psags) {
        ArrayList<BiologicalAssemblyTransformation> transformations = new ArrayList<BiologicalAssemblyTransformation>();
        for (PdbxStructAssemblyGen psag : psags) {
            if (!psag.getAssembly_id().equals(assemblyId)) continue;
            this.operatorResolver.parseOperatorExpressionString(psag.getOper_expression());
            List<String> operators = this.operatorResolver.getUnaryOperators();
            List<String> asymIds = Arrays.asList(psag.getAsym_id_list().split(","));
            for (String chainId : asymIds) {
                for (String operator : operators) {
                    Matrix4d original = this.allTransformations.get(operator);
                    if (original == null) {
                        logger.warn("Could not find matrix operator for operator id {}. Assembly id {} will not contain the operator.", (Object)operator, (Object)assemblyId);
                        continue;
                    }
                    BiologicalAssemblyTransformation transform = new BiologicalAssemblyTransformation();
                    transform.setChainId(chainId);
                    transform.setId(operator);
                    transform.setTransformationMatrix(original);
                    transformations.add(transform);
                }
            }
        }
        return transformations;
    }

    private void init() {
        this.operatorResolver = new OperatorResolver();
        this.allTransformations = new HashMap<String, Matrix4d>();
    }
}

