/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.domain;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.util.AtomCache;

public class PDPDomain
implements StructureIdentifier {
    private static final long serialVersionUID = 6894463080739943026L;
    private String identifier;
    private SubstructureIdentifier canonical;
    public static final Pattern PDP_NAME_PATTERN = Pattern.compile("^(?:PDP:)([0-9][a-z0-9]{3})(\\w)(\\w)$", 2);

    public PDPDomain(String pdpDomainName, List<ResidueRange> ranges) {
        this.identifier = pdpDomainName;
        Matcher matcher = PDP_NAME_PATTERN.matcher(this.identifier);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed PDP domain name");
        }
        String pdbId = matcher.group(1);
        this.canonical = new SubstructureIdentifier(pdbId, ranges);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String getPdbId() {
        return this.canonical.getPdbId();
    }

    @Override
    public SubstructureIdentifier toCanonical() {
        return this.canonical;
    }

    @Override
    public Structure reduce(Structure input) throws StructureException {
        return this.canonical.reduce(input);
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public Structure loadStructure(AtomCache cache) throws StructureException, IOException {
        return this.canonical.loadStructure(cache);
    }
}

