/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.secstruc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.secstruc.BetaBridge;
import org.biojava.nbio.structure.secstruc.BridgeType;
import org.biojava.nbio.structure.secstruc.SecStrucState;
import org.biojava.nbio.structure.secstruc.SecStrucType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSSPParser {
    private static final Logger logger = LoggerFactory.getLogger(DSSPParser.class);

    public static List<SecStrucState> parseInputStream(InputStream dsspIs, Structure structure, boolean assign) throws IOException, StructureException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(dsspIs));
        return DSSPParser.generalParse(reader, structure, assign);
    }

    public static List<SecStrucState> parseFile(String dsspPath, Structure structure, boolean assign) throws IOException, StructureException {
        File file = new File(dsspPath);
        FileReader read = new FileReader(file);
        BufferedReader reader = new BufferedReader(read);
        return DSSPParser.generalParse(reader, structure, assign);
    }

    public static List<SecStrucState> parseString(String dsspOut, Structure structure, boolean assign) throws IOException, StructureException {
        StringReader read = new StringReader(dsspOut);
        BufferedReader reader = new BufferedReader(read);
        return DSSPParser.generalParse(reader, structure, assign);
    }

    private static List<SecStrucState> generalParse(BufferedReader reader, Structure structure, boolean assign) throws IOException, StructureException {
        String line;
        String startLine = "  #  RESIDUE AA STRUCTURE BP1 BP2  ACC";
        ArrayList<SecStrucState> secstruc = new ArrayList<SecStrucState>();
        while ((line = reader.readLine()) != null && !line.startsWith(startLine)) {
        }
        while ((line = reader.readLine()) != null) {
            BetaBridge bb;
            String indexStr = line.substring(0, 5).trim();
            String resNumStr = line.substring(5, 10).trim();
            if (resNumStr.equals("")) continue;
            int index = Integer.parseInt(indexStr);
            int resNum = Integer.parseInt(resNumStr);
            char insCode = line.charAt(10);
            String chainId = line.substring(11, 13).trim();
            ResidueNumber r = new ResidueNumber(chainId, resNum, Character.valueOf(insCode));
            Group parent = structure.getPolyChainByPDB(chainId).getGroupByPDB(r);
            SecStrucType ssType = SecStrucType.fromCharacter(Character.valueOf(line.charAt(16)));
            SecStrucState ss = new SecStrucState(parent, "DSSP_ASSIGNMENT", ssType);
            String bp = line.substring(25, 29).trim();
            if (!bp.equals("")) {
                bb = new BetaBridge(index, Integer.parseInt(bp), BridgeType.parallel);
                ss.addBridge(bb);
            } else {
                logger.warn("Unable to parse beta Bridge for resn " + index);
            }
            bp = line.substring(29, 33).trim();
            if (!bp.equals("")) {
                bb = new BetaBridge(index, Integer.parseInt(bp), BridgeType.parallel);
                ss.addBridge(bb);
            } else {
                logger.warn("Unable to parse beta Bridge for resn " + index);
            }
            block8: for (int i = 0; i < 4; ++i) {
                int a = 42 + i * 11;
                int b = a + 8;
                String val = line.substring(a, b).trim();
                if (val.equals("")) {
                    logger.warn("Unable to parse energy for resn " + index);
                    continue;
                }
                String[] p = val.split(",");
                int partner = Integer.parseInt(p[0]);
                if (partner != 0) {
                    partner += index;
                }
                double energy = Double.parseDouble(p[1]) * 1000.0;
                switch (i) {
                    case 0: {
                        ss.getAccept1().setPartner(partner);
                        ss.getAccept1().setEnergy(energy);
                        continue block8;
                    }
                    case 1: {
                        ss.getDonor1().setPartner(partner);
                        ss.getDonor1().setEnergy(energy);
                        continue block8;
                    }
                    case 2: {
                        ss.getAccept2().setPartner(partner);
                        ss.getAccept2().setEnergy(energy);
                        continue block8;
                    }
                    case 3: {
                        ss.getDonor2().setPartner(partner);
                        ss.getDonor1().setEnergy(energy);
                    }
                }
            }
            String val = line.substring(91, 97).trim();
            if (!val.equals("")) {
                ss.setKappa(Float.parseFloat(val));
            } else {
                logger.warn("Unable to parse kappa for resn " + index);
            }
            val = line.substring(103, 109).trim();
            if (!val.equals("")) {
                ss.setPhi(Float.parseFloat(val));
            } else {
                logger.warn("Unable to parse phi for resn " + index);
            }
            val = line.substring(109, 116).trim();
            if (!val.equals("")) {
                ss.setPsi(Float.parseFloat(val));
            } else {
                logger.warn("Unable to parse psi for resn " + index);
            }
            if (assign) {
                parent.setProperty("secstruc", ss);
            }
            secstruc.add(ss);
        }
        reader.close();
        return secstruc;
    }
}

