/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.scop;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import org.biojava.nbio.structure.scop.ScopCategory;

@XmlRootElement(name="ScopDescription", namespace="http://source.rcsb.org")
@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
public class ScopDescription
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8579808155176839161L;
    int sunID;
    ScopCategory category;
    String classificationId;
    String name;
    String description;

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(this.sunID));
        buf.append("\t");
        buf.append(this.category);
        buf.append("\t");
        buf.append(this.classificationId);
        buf.append("\t");
        buf.append(this.name);
        buf.append("\t");
        buf.append(this.description);
        return buf.toString();
    }

    public int getSunID() {
        return this.sunID;
    }

    public void setSunID(int sunID) {
        this.sunID = sunID;
    }

    public ScopCategory getCategory() {
        return this.category;
    }

    public void setCategory(ScopCategory category) {
        this.category = category;
    }

    public String getClassificationId() {
        return this.classificationId;
    }

    public void setClassificationId(String classificationId) {
        this.classificationId = classificationId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getClassificationId(ScopCategory category) {
        if (this.classificationId == null || this.classificationId.isEmpty()) {
            return null;
        }
        int numParts = 0;
        switch (category) {
            case Family: {
                ++numParts;
            }
            case Superfamily: {
                ++numParts;
            }
            case Fold: {
                ++numParts;
            }
            case Class: {
                ++numParts;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only Class, Fold, Superfamily, and Family are supported.");
            }
        }
        int endChar = -1;
        for (int i = 0; i < numParts - 1; ++i) {
            if ((endChar = this.classificationId.indexOf(46, endChar + 1)) >= 0) continue;
            return null;
        }
        if ((endChar = this.classificationId.indexOf(46, endChar + 1)) < 0) {
            return this.classificationId;
        }
        return this.classificationId.substring(0, endChar);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.classificationId == null ? 0 : this.classificationId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.sunID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScopDescription other = (ScopDescription)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.classificationId == null ? other.classificationId != null : !this.classificationId.equals(other.classificationId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.sunID == other.sunID;
    }

    protected Object clone() throws CloneNotSupportedException {
        super.clone();
        ScopDescription n = new ScopDescription();
        n.setCategory(this.getCategory());
        n.setClassificationId(this.getClassificationId());
        n.setDescription(this.getDescription());
        n.setName(this.getName());
        n.setSunID(this.getSunID());
        return n;
    }
}

