/*
 * Decompiled with CFR 0.152.
 */
package org.codeability.sharing.plugins.api.search;

import java.util.List;
import java.util.stream.Collectors;

public class SearchInputMetadataDTO {
    private String programmingLanguage;
    private String keyword;
    private List<String> naturalLanguage;
    private String license;
    private String author;
    private String learningResourceType;
    private String format;
    private String parentId;

    public SearchInputMetadataDTO() {
    }

    public SearchInputMetadataDTO(String programmingLanguage, String keyword, List<String> naturalLanguage, String license, String author, String format) {
        this.programmingLanguage = SearchInputMetadataDTO.mapEmptyString(programmingLanguage);
        this.keyword = SearchInputMetadataDTO.mapEmptyString(keyword);
        this.license = SearchInputMetadataDTO.mapEmptyString(license);
        this.author = SearchInputMetadataDTO.mapEmptyString(author);
        this.naturalLanguage = naturalLanguage;
        this.format = SearchInputMetadataDTO.mapEmptyString(format);
    }

    private static List<String> mapEmptyString(List<String> str) {
        if (str == null) {
            return null;
        }
        return str.stream().map(s -> "".equals(s) ? null : s).toList();
    }

    private static String mapEmptyString(String str) {
        return "".equals(str) ? null : str;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean hasMetadataInput() {
        return this.programmingLanguage != null || this.keyword != null || this.author != null || this.license != null;
    }

    public String getProgrammingLanguage() {
        return this.programmingLanguage;
    }

    public void setProgrammingLanguage(String programmingLanguage) {
        this.programmingLanguage = SearchInputMetadataDTO.mapEmptyString(programmingLanguage);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = SearchInputMetadataDTO.mapEmptyString(keyword);
    }

    public List<String> getNaturalLanguage() {
        return this.naturalLanguage;
    }

    public String getNaturalLanguagesAsString() {
        return this.naturalLanguage == null ? "null" : this.naturalLanguage.stream().collect(Collectors.joining(", "));
    }

    public void setNaturalLanguage(List<String> naturalLanguages) {
        this.naturalLanguage = SearchInputMetadataDTO.mapEmptyString(naturalLanguages);
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = SearchInputMetadataDTO.mapEmptyString(license);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = SearchInputMetadataDTO.mapEmptyString(author);
    }

    public String getLearningResourceType() {
        return this.learningResourceType;
    }

    public void setLearningResourceType(String learningResourceType) {
        this.learningResourceType = learningResourceType;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String toString() {
        return "programmingLanguage: " + this.programmingLanguage + ", keyword: " + this.keyword + ", naturalLanguage: " + this.getNaturalLanguagesAsString() + ", license: " + this.license + ", author: " + this.author + ", format: " + this.format;
    }
}

