/*
 * Copyright (c) 2010, Stanislav Muhametsin. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.sql.generation.api.grammar.common;

import org.atp.api.Typeable;

/**
 * A table name may be just table name, or schema-qualified table name.
 * 
 * @author Stanislav Muhametsin
 */
public interface TableName
    extends Typeable<TableName>
{

    /**
     * Gets the schema name. Returns {@code null} if this is not schema-qualified table name.
     * 
     * @return Schema name of the schema-qualified table name, or {@code null} if this is not a schema-qualified table
     *         name.
     */
    public String getSchemaName();

    /**
     * Gets name of the table. Returns always non-{@code null}.
     * 
     * @return The name of the table. Always non-{@code null}.
     */
    public String getTableName();
}
