/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.builders.booleans;

import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.BooleanExpression;
import org.sql.generation.api.grammar.booleans.Predicate;
import org.sql.generation.api.grammar.builders.booleans.BooleanBuilder;
import org.sql.generation.api.grammar.factories.BooleanFactory;

public class BooleanBuilderImpl
implements BooleanBuilder {
    private BooleanExpression _topLevelExpression;
    private final BooleanFactory _factory;

    public BooleanBuilderImpl(BooleanFactory factory) {
        this(factory, (BooleanExpression)Predicate.EmptyPredicate.INSTANCE);
    }

    public BooleanBuilderImpl(BooleanFactory factory, BooleanExpression expression) {
        NullArgumentException.validateNotNull((String)"boolean expression factory", (Object)factory);
        this._factory = factory;
        this._topLevelExpression = expression;
    }

    public BooleanBuilder and(BooleanExpression next) {
        this._topLevelExpression = this._factory.and(this._topLevelExpression, next);
        return this;
    }

    public BooleanBuilder or(BooleanExpression next) {
        this._topLevelExpression = this._factory.or(this._topLevelExpression, next);
        return this;
    }

    public BooleanBuilder not() {
        this._topLevelExpression = this._factory.not(this._topLevelExpression);
        return this;
    }

    public BooleanBuilder reset(BooleanExpression newExpression) {
        this._topLevelExpression = newExpression;
        return this;
    }

    public BooleanExpression createExpression() {
        return this._topLevelExpression == null ? Predicate.EmptyPredicate.INSTANCE : this._topLevelExpression;
    }
}

