/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.atp.api.Typeable;
import org.sql.generation.api.grammar.definition.schema.SchemaDefinition;
import org.sql.generation.api.grammar.definition.schema.SchemaElement;
import org.sql.generation.api.grammar.definition.table.CheckConstraint;
import org.sql.generation.api.grammar.definition.table.ColumnDefinition;
import org.sql.generation.api.grammar.definition.table.ConstraintCharacteristics;
import org.sql.generation.api.grammar.definition.table.ForeignKeyConstraint;
import org.sql.generation.api.grammar.definition.table.LikeClause;
import org.sql.generation.api.grammar.definition.table.MatchType;
import org.sql.generation.api.grammar.definition.table.ReferentialAction;
import org.sql.generation.api.grammar.definition.table.TableCommitAction;
import org.sql.generation.api.grammar.definition.table.TableConstraintDefinition;
import org.sql.generation.api.grammar.definition.table.TableDefinition;
import org.sql.generation.api.grammar.definition.table.TableElementList;
import org.sql.generation.api.grammar.definition.table.TableScope;
import org.sql.generation.api.grammar.definition.table.UniqueConstraint;
import org.sql.generation.api.grammar.definition.table.UniqueSpecification;
import org.sql.generation.api.grammar.definition.view.RegularViewSpecification;
import org.sql.generation.api.grammar.definition.view.ViewCheckOption;
import org.sql.generation.api.grammar.definition.view.ViewDefinition;
import org.sql.generation.implementation.transformation.AbstractProcessor;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class DefinitionProcessing {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegularViewSpecificationProcessor
    extends AbstractProcessor<RegularViewSpecification> {
        public RegularViewSpecificationProcessor() {
            super(RegularViewSpecification.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, RegularViewSpecification object, StringBuilder builder) {
            if (object.getColumns() != null) {
                builder.append("(");
                aggregator.process((Typeable<?>)object.getColumns(), builder);
                builder.append(")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewDefinitionProcessor
    extends AbstractProcessor<ViewDefinition> {
        private static final Map<ViewCheckOption, String> _defaultViewCheckOptions;
        private final Map<ViewCheckOption, String> _viewCheckOptions;

        public ViewDefinitionProcessor() {
            this(_defaultViewCheckOptions);
        }

        public ViewDefinitionProcessor(Map<ViewCheckOption, String> viewCheckOptions) {
            super(ViewDefinition.class);
            this._viewCheckOptions = viewCheckOptions;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, ViewDefinition object, StringBuilder builder) {
            builder.append("CREATE").append(" ");
            if (object.isRecursive().booleanValue()) {
                builder.append("RECURSIVE").append(" ");
            }
            builder.append("VIEW").append(" ");
            aggregator.process((Typeable<?>)object.getViewName(), builder);
            aggregator.process((Typeable<?>)object.getViewSpecification(), builder);
            builder.append("AS").append("\n");
            aggregator.process((Typeable<?>)object.getViewQuery(), builder);
            if (object.getViewCheckOption() != null) {
                builder.append("\n").append("WITH").append(" ").append(this._viewCheckOptions.get(object.getViewCheckOption())).append(" ").append("CHECK OPTION");
            }
        }

        static {
            HashMap<ViewCheckOption, String> map = new HashMap<ViewCheckOption, String>();
            map.put(ViewCheckOption.CASCADED, "CASCADED");
            map.put(ViewCheckOption.LOCAL, "LOCAL");
            _defaultViewCheckOptions = map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForeignKeyConstraintProcessor
    extends AbstractProcessor<ForeignKeyConstraint> {
        private static final Map<ReferentialAction, String> _defaultReferentialActions;
        private static final Map<MatchType, String> _defaultMatchTypes;
        private final Map<ReferentialAction, String> _referentialActions;
        private final Map<MatchType, String> _matchTypes;

        public ForeignKeyConstraintProcessor() {
            this(_defaultReferentialActions, _defaultMatchTypes);
        }

        public ForeignKeyConstraintProcessor(Map<ReferentialAction, String> uniqueSpecs, Map<MatchType, String> matchTypes) {
            super(ForeignKeyConstraint.class);
            this._referentialActions = uniqueSpecs;
            this._matchTypes = matchTypes;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, ForeignKeyConstraint object, StringBuilder builder) {
            builder.append("FOREIGN KEY").append("(");
            aggregator.process((Typeable<?>)object.getSourceColumns(), builder);
            builder.append(")").append("\n").append("REFERENCES").append(" ");
            aggregator.process((Typeable<?>)object.getTargetTableName(), builder);
            if (object.getTargetColumns() != null) {
                builder.append("(");
                aggregator.process((Typeable<?>)object.getTargetColumns(), builder);
                builder.append(")");
            }
            if (object.getMatchType() != null) {
                builder.append(" ").append("MATCH").append(" ").append(this._matchTypes.get(object.getMatchType()));
            }
            builder.append("\n");
            this.handleReferentialAction("ON UPDATE", object.getOnUpdate(), builder);
            builder.append(" ");
            this.handleReferentialAction("ON DELETE", object.getOnDelete(), builder);
        }

        protected void handleReferentialAction(String prefix, ReferentialAction action, StringBuilder builder) {
            if (action != null) {
                builder.append(prefix).append(" ").append(this._referentialActions.get(action));
            }
        }

        static {
            HashMap<ReferentialAction, String> map = new HashMap<ReferentialAction, String>();
            map.put(ReferentialAction.CASCADE, "CASCADE");
            map.put(ReferentialAction.NO_ACTION, "NO ACTION");
            map.put(ReferentialAction.RESTRICT, "RESTRICT");
            map.put(ReferentialAction.SET_DEFAULT, "SET DEFAULT");
            map.put(ReferentialAction.SET_NULL, "SET NULL");
            _defaultReferentialActions = map;
            HashMap<MatchType, String> mt = new HashMap<MatchType, String>();
            mt.put(MatchType.FULL, "FULL");
            mt.put(MatchType.PARTIAL, "PARTIAL");
            mt.put(MatchType.SIMPLE, "SIMPLE");
            _defaultMatchTypes = mt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UniqueConstraintProcessor
    extends AbstractProcessor<UniqueConstraint> {
        private static final Map<UniqueSpecification, String> _defaultUniqueSpecs;
        private final Map<UniqueSpecification, String> _uniqueSpecs;

        public UniqueConstraintProcessor() {
            this(_defaultUniqueSpecs);
        }

        public UniqueConstraintProcessor(Map<UniqueSpecification, String> uniqueSpecs) {
            super(UniqueConstraint.class);
            this._uniqueSpecs = uniqueSpecs;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, UniqueConstraint object, StringBuilder builder) {
            builder.append(this._uniqueSpecs.get(object.getUniquenessKind())).append("(");
            aggregator.process((Typeable<?>)object.getColumnNameList(), builder);
            builder.append(")");
        }

        static {
            HashMap<UniqueSpecification, String> map = new HashMap<UniqueSpecification, String>();
            map.put(UniqueSpecification.PRIMARY_KEY, "PRIMARY KEY");
            map.put(UniqueSpecification.UNIQUE, "UNIQUE");
            _defaultUniqueSpecs = map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckConstraintProcessor
    extends AbstractProcessor<CheckConstraint> {
        public CheckConstraintProcessor() {
            super(CheckConstraint.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, CheckConstraint object, StringBuilder builder) {
            builder.append("CHECK").append(" ").append("(");
            aggregator.process((Typeable<?>)object.getCheckCondition(), builder);
            builder.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableConstraintDefinitionProcessor
    extends AbstractProcessor<TableConstraintDefinition> {
        private static final Map<ConstraintCharacteristics, String> _defaultCharacteristics;
        private final Map<ConstraintCharacteristics, String> _characteristics;

        public TableConstraintDefinitionProcessor() {
            this(_defaultCharacteristics);
        }

        public TableConstraintDefinitionProcessor(Map<ConstraintCharacteristics, String> characteristics) {
            super(TableConstraintDefinition.class);
            this._characteristics = characteristics;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, TableConstraintDefinition object, StringBuilder builder) {
            if (object.getConstraintName() != null) {
                builder.append("CONSTRAINT").append(" ").append(object.getConstraintName()).append(" ");
            }
            aggregator.process((Typeable<?>)object.getConstraint(), builder);
            if (object.getCharacteristics() != null) {
                builder.append(" ").append(this._characteristics.get(object.getCharacteristics()));
            }
        }

        static {
            HashMap<ConstraintCharacteristics, String> operations = new HashMap<ConstraintCharacteristics, String>();
            operations.put(ConstraintCharacteristics.INITIALLY_DEFERRED_DEFERRABLE, "INITIALLY DEFERRED DEFERRABLE");
            operations.put(ConstraintCharacteristics.INITIALLY_IMMEDIATE_DEFERRABLE, "INITIALLY IMMEDIATE DEFERRABLE");
            operations.put(ConstraintCharacteristics.NOT_DEFERRABLE, "NOT DEFERRABLE");
            _defaultCharacteristics = operations;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LikeClauseProcessor
    extends AbstractProcessor<LikeClause> {
        public LikeClauseProcessor() {
            super(LikeClause.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, LikeClause object, StringBuilder builder) {
            builder.append("LIKE").append(" ");
            aggregator.process((Typeable<?>)object.getTableName(), builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnDefinitionProcessor
    extends AbstractProcessor<ColumnDefinition> {
        public ColumnDefinitionProcessor() {
            super(ColumnDefinition.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, ColumnDefinition object, StringBuilder builder) {
            builder.append(object.getColumnName()).append(" ");
            aggregator.process((Typeable<?>)object.getDataType(), builder);
            if (object.getDefault() != null) {
                builder.append(" ").append("DEFAULT").append(" ").append(object.getDefault());
            }
            if (!object.mayBeNull().booleanValue()) {
                builder.append(" ").append("NOT NULL");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableElementListProcessor
    extends AbstractProcessor<TableElementList> {
        public TableElementListProcessor() {
            super(TableElementList.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, TableElementList object, StringBuilder builder) {
            Iterator iter = object.getElementList().iterator();
            builder.append("(").append("\n");
            while (iter.hasNext()) {
                aggregator.process((Typeable)iter.next(), builder);
                if (iter.hasNext()) {
                    builder.append(",");
                }
                builder.append("\n");
            }
            builder.append(")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableDefinitionProcessor
    extends AbstractProcessor<TableDefinition> {
        private static final Map<TableScope, String> _defaultTableScopes;
        private static final Map<TableCommitAction, String> _defaultCommitActions;
        private final Map<TableScope, String> _tableScopes;
        private final Map<TableCommitAction, String> _commitActions;

        public static Map<TableCommitAction, String> getDefaultCommitActions() {
            return Collections.unmodifiableMap(_defaultCommitActions);
        }

        public static Map<TableScope, String> getDefaultTableScopes() {
            return Collections.unmodifiableMap(_defaultTableScopes);
        }

        public TableDefinitionProcessor() {
            this(_defaultTableScopes, _defaultCommitActions);
        }

        public TableDefinitionProcessor(Map<TableScope, String> tableScopes, Map<TableCommitAction, String> commitActions) {
            super(TableDefinition.class);
            this._tableScopes = tableScopes;
            this._commitActions = commitActions;
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, TableDefinition object, StringBuilder builder) {
            builder.append("CREATE");
            if (object.getTableScope() != null) {
                builder.append(" ").append(this._tableScopes.get(object.getTableScope()));
            }
            builder.append(" ").append("TABLE").append(" ");
            aggregator.process((Typeable<?>)object.getTableName(), builder);
            builder.append("\n");
            aggregator.process((Typeable<?>)object.getContents(), builder);
            builder.append("\n");
            if (object.getCommitAction() != null) {
                builder.append("ON COMMIT").append(" ").append(this._commitActions.get(object.getCommitAction()));
            }
        }

        static {
            HashMap<TableScope, String> operations = new HashMap<TableScope, String>();
            operations.put(TableScope.GLOBAL_TEMPORARY, "GLOBAL TEMPORARY");
            operations.put(TableScope.LOCAL_TEMPORARY, "LOCAL TEMPORARY");
            _defaultTableScopes = operations;
            HashMap<TableCommitAction, String> commitActions = new HashMap<TableCommitAction, String>();
            commitActions.put(TableCommitAction.ON_COMMIT_DELETE_ROWS, "DELETE ROWS");
            commitActions.put(TableCommitAction.ON_COMMIT_PRESERVE_ROWS, "PRESERVE ROWS");
            _defaultCommitActions = commitActions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SchemaDefinitionProcessor
    extends AbstractProcessor<SchemaDefinition> {
        public SchemaDefinitionProcessor() {
            super(SchemaDefinition.class);
        }

        @Override
        protected void doProcess(SQLProcessorAggregator aggregator, SchemaDefinition object, StringBuilder builder) {
            builder.append("CREATE").append(" ").append("SCHEMA ").append(object.getSchemaName());
            String charset = object.getSchemaCharset();
            if (charset != null) {
                builder.append(" DEFAULT CHARSET ").append(object.getSchemaCharset());
            }
            builder.append("\n");
        }

        protected void processSchemaElements(SQLProcessorAggregator aggregator, SchemaDefinition object, StringBuilder builder) {
            for (SchemaElement el : object.getSchemaElements()) {
                aggregator.process(el.asTypeable(), builder);
                builder.append("\n");
            }
        }
    }
}

