/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation.pgsql;

import org.slf4j.LoggerFactory;
import org.sql.generation.api.grammar.query.QuerySpecification;
import org.sql.generation.api.grammar.query.pgsql.LimitByNumber;
import org.sql.generation.api.grammar.query.pgsql.LimitClause;
import org.sql.generation.api.grammar.query.pgsql.OffsetClause;
import org.sql.generation.api.grammar.query.pgsql.PgSQLQuerySpecification;
import org.sql.generation.implementation.transformation.QueryProcessing;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class QueryProcessing {

    public static class PgSQLQuerySpecificationProcessor
    extends QueryProcessing.QuerySpecificationProcessor {
        protected PgSQLQuerySpecificationProcessor() {
            super((Class<? extends QuerySpecification>)PgSQLQuerySpecification.class);
        }

        protected void doProcess(SQLProcessorAggregator processor, QuerySpecification query, StringBuilder builder) {
            super.doProcess(processor, query, builder);
            PgSQLQuerySpecification pgQuery = (PgSQLQuerySpecification)query;
            this.processLimitClause(pgQuery, builder);
            this.processOffsetClause(pgQuery, builder);
        }

        protected void processLimitClause(PgSQLQuerySpecification query, StringBuilder builder) {
            LimitClause limit = query.getLimit();
            if (limit != null) {
                builder.append("\n").append("LIMIT").append(" ");
                if (limit == LimitClause.LimitAll.INSTANCE) {
                    builder.append("ALL");
                } else if (limit instanceof LimitByNumber) {
                    builder.append(((LimitByNumber)limit).getLimit());
                    this.checkOrderBy(query, builder, "LIMIT");
                }
            }
        }

        protected void processOffsetClause(PgSQLQuerySpecification query, StringBuilder builder) {
            OffsetClause offset = query.getOffset();
            if (offset != null) {
                builder.append("\n").append("OFFSET").append(" ").append(offset.getOffset());
                this.checkOrderBy(query, builder, "OFFSET");
            }
        }

        protected void checkOrderBy(PgSQLQuerySpecification query, StringBuilder builder, String clauseName) {
            if (query.getOrderBy() == null) {
                LoggerFactory.getLogger((String)this.getClass().getName()).warn("Spotted query with " + clauseName + " clause, but without ORDER BY. See http://www.postgresql.org/docs/9.0/static/queries-limit.html for more information." + "\n" + "Query so far: " + builder.toString());
            }
        }
    }
}

