/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.CountDownLatch;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SSLContextUtil;
import org.java_websocket.util.SocketUtil;
import org.junit.Test;

public class Issue825Test {
    @Test(timeout=15000L)
    public void testIssue() throws IOException, URISyntaxException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, CertificateException, InterruptedException {
        final CountDownLatch countClientOpenLatch = new CountDownLatch(3);
        CountDownLatch countClientMessageLatch = new CountDownLatch(3);
        CountDownLatch countServerDownLatch = new CountDownLatch(1);
        int port = SocketUtil.getAvailablePort();
        WebSocketClient webSocket = new WebSocketClient(new URI("wss://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
                countClientOpenLatch.countDown();
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }
        };
        MyWebSocketServer server = new MyWebSocketServer(port, countServerDownLatch, countClientMessageLatch);
        SSLContext sslContext = SSLContextUtil.getContext();
        server.setWebSocketFactory((WebSocketServerFactory)new DefaultSSLWebSocketServerFactory(sslContext));
        webSocket.setSocketFactory((SocketFactory)sslContext.getSocketFactory());
        server.start();
        countServerDownLatch.await();
        webSocket.connectBlocking();
        webSocket.send("hi");
        Thread.sleep(10L);
        webSocket.closeBlocking();
        webSocket.reconnectBlocking();
        webSocket.send("it's");
        Thread.sleep(10000L);
        webSocket.closeBlocking();
        webSocket.reconnect();
        countClientOpenLatch.await();
        webSocket.send("me");
        Thread.sleep(100L);
        webSocket.closeBlocking();
        countClientMessageLatch.await();
    }

    private static class MyWebSocketServer
    extends WebSocketServer {
        private final CountDownLatch countServerLatch;
        private final CountDownLatch countClientMessageLatch;

        public MyWebSocketServer(int port, CountDownLatch serverDownLatch, CountDownLatch countClientMessageLatch) {
            super(new InetSocketAddress(port));
            this.countServerLatch = serverDownLatch;
            this.countClientMessageLatch = countClientMessageLatch;
        }

        public void onOpen(WebSocket conn, ClientHandshake handshake) {
        }

        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        }

        public void onMessage(WebSocket conn, String message) {
            this.countClientMessageLatch.countDown();
        }

        public void onError(WebSocket conn, Exception ex) {
            ex.printStackTrace();
        }

        public void onStart() {
            this.countServerLatch.countDown();
        }
    }
}

