/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Issue879Test {
    private static final int NUMBER_OF_TESTS = 20;
    @Parameterized.Parameter
    public int numberOfConnections;

    @Test(timeout=10000L)
    public void QuickStopTest() throws IOException, InterruptedException, URISyntaxException {
        final boolean[] wasBindException = new boolean[]{false};
        final boolean[] wasConcurrentException = new boolean[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        int port = SocketUtil.getAvailablePort();
        class SimpleServer
        extends WebSocketServer {
            public SimpleServer(InetSocketAddress address) {
                super(address);
            }

            public void onOpen(WebSocket conn, ClientHandshake handshake) {
                this.broadcast("new connection: " + handshake.getResourceDescriptor());
            }

            public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            }

            public void onMessage(WebSocket conn, String message) {
            }

            public void onMessage(WebSocket conn, ByteBuffer message) {
            }

            public void onError(WebSocket conn, Exception ex) {
                if (ex instanceof BindException) {
                    wasBindException[0] = true;
                }
                if (ex instanceof ConcurrentModificationException) {
                    wasConcurrentException[0] = true;
                }
            }

            public void onStart() {
                countDownLatch.countDown();
            }
        }
        SimpleServer serverA = new SimpleServer(new InetSocketAddress(port));
        SimpleServer serverB = new SimpleServer(new InetSocketAddress(port));
        serverA.start();
        countDownLatch.await();
        List<WebSocketClient> clients = this.startNewConnections(this.numberOfConnections, port);
        Thread.sleep(100L);
        int numberOfConnected = 0;
        for (WebSocketClient client : clients) {
            if (!client.isOpen()) continue;
            ++numberOfConnected;
        }
        serverA.stop();
        serverB.start();
        clients.clear();
        Assert.assertFalse((String)"There was a BindException", (boolean)wasBindException[0]);
        Assert.assertFalse((String)"There was a ConcurrentModificationException", (boolean)wasConcurrentException[0]);
    }

    @Parameterized.Parameters
    public static Collection<Integer[]> data() {
        ArrayList<Integer[]> ret = new ArrayList<Integer[]>(20);
        for (int i = 0; i < 20; ++i) {
            ret.add(new Integer[]{25 + i * 25});
        }
        return ret;
    }

    private List<WebSocketClient> startNewConnections(int numberOfConnections, int port) throws URISyntaxException, InterruptedException {
        ArrayList<WebSocketClient> clients = new ArrayList<WebSocketClient>(numberOfConnections);
        for (int i = 0; i < numberOfConnections; ++i) {
            SimpleClient client = new SimpleClient(new URI("ws://localhost:" + port));
            client.connect();
            Thread.sleep(1L);
            clients.add(client);
        }
        return clients;
    }

    class SimpleClient
    extends WebSocketClient {
        public SimpleClient(URI serverUri) {
            super(serverUri);
        }

        public void onOpen(ServerHandshake handshakedata) {
        }

        public void onMessage(String message) {
        }

        public void onClose(int code, String reason, boolean remote) {
        }

        public void onError(Exception ex) {
        }
    }
}

