/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.beanmapping;

import java.util.ArrayList;
import java.util.List;
import org.mapstruct.ap.internal.model.beanmapping.PropertyEntry;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Strings;

public abstract class AbstractReference {
    private final Parameter parameter;
    private final List<PropertyEntry> propertyEntries;
    private final boolean isValid;

    protected AbstractReference(Parameter sourceParameter, List<PropertyEntry> sourcePropertyEntries, boolean isValid) {
        this.parameter = sourceParameter;
        this.propertyEntries = sourcePropertyEntries;
        this.isValid = isValid;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public List<PropertyEntry> getPropertyEntries() {
        return this.propertyEntries;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<String> getElementNames() {
        ArrayList<String> elementNames = new ArrayList<String>();
        if (this.parameter != null) {
            elementNames.add(this.parameter.getName());
        }
        for (PropertyEntry propertyEntry : this.propertyEntries) {
            elementNames.add(propertyEntry.getName());
        }
        return elementNames;
    }

    public PropertyEntry getShallowestProperty() {
        if (this.propertyEntries.isEmpty()) {
            return null;
        }
        return Collections.first(this.propertyEntries);
    }

    public String getShallowestPropertyName() {
        if (this.propertyEntries.isEmpty()) {
            return null;
        }
        return Collections.first(this.propertyEntries).getName();
    }

    public PropertyEntry getDeepestProperty() {
        if (this.propertyEntries.isEmpty()) {
            return null;
        }
        return Collections.last(this.propertyEntries);
    }

    public String getDeepestPropertyName() {
        if (this.propertyEntries.isEmpty()) {
            return null;
        }
        return Collections.last(this.propertyEntries).getName();
    }

    public boolean isNested() {
        return this.propertyEntries.size() > 1;
    }

    public String toString() {
        String result = "";
        if (!this.isValid) {
            result = "invalid";
        } else if (this.propertyEntries.isEmpty()) {
            if (this.parameter != null) {
                result = String.format("parameter \"%s %s\"", this.parameter.getType(), this.parameter.getName());
            }
        } else if (this.propertyEntries.size() == 1) {
            PropertyEntry propertyEntry = this.propertyEntries.get(0);
            result = String.format("property \"%s %s\"", propertyEntry.getType(), propertyEntry.getName());
        } else {
            PropertyEntry lastPropertyEntry = this.propertyEntries.get(this.propertyEntries.size() - 1);
            result = String.format("property \"%s %s\"", lastPropertyEntry.getType(), Strings.join(this.getElementNames(), "."));
        }
        return result;
    }
}

