/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import org.mapstruct.ap.shaded.freemarker.core.BooleanExpression;
import org.mapstruct.ap.shaded.freemarker.core.BugException;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.EvalUtil;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;

final class ComparisonExpression
extends BooleanExpression {
    private final Expression left;
    private final Expression right;
    private final int operation;
    private final String opString;

    ComparisonExpression(Expression left, Expression right, String opString) {
        this.left = left;
        this.right = right;
        this.opString = opString = opString.intern();
        if (opString == "==" || opString == "=") {
            this.operation = 1;
        } else if (opString == "!=") {
            this.operation = 2;
        } else if (opString == "gt" || opString == "\\gt" || opString == ">" || opString == "&gt;") {
            this.operation = 4;
        } else if (opString == "gte" || opString == "\\gte" || opString == ">=" || opString == "&gt;=") {
            this.operation = 6;
        } else if (opString == "lt" || opString == "\\lt" || opString == "<" || opString == "&lt;") {
            this.operation = 3;
        } else if (opString == "lte" || opString == "\\lte" || opString == "<=" || opString == "&lt;=") {
            this.operation = 5;
        } else {
            throw new BugException("Unknown comparison operator " + opString);
        }
    }

    boolean evalToBoolean(Environment env) throws TemplateException {
        return EvalUtil.compare(this.left, this.operation, this.opString, this.right, this, env);
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + ' ' + this.opString + ' ' + this.right.getCanonicalForm();
    }

    String getNodeTypeSymbol() {
        return this.opString;
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return new ComparisonExpression(this.left.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState), this.right.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState), this.opString);
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        return idx == 0 ? this.left : this.right;
    }

    ParameterRole getParameterRole(int idx) {
        return ParameterRole.forBinaryOperatorOperand(idx);
    }
}

