/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mapstruct.ap.shaded.freemarker.core.Dot;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.Identifier;
import org.mapstruct.ap.shaded.freemarker.core.InvalidReferenceException;
import org.mapstruct.ap.shaded.freemarker.core.Macro;
import org.mapstruct.ap.shaded.freemarker.core.MessageUtil;
import org.mapstruct.ap.shaded.freemarker.core.MiscUtil;
import org.mapstruct.ap.shaded.freemarker.core.NonUserDefinedDirectiveLikeException;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.TemplateElement;
import org.mapstruct.ap.shaded.freemarker.core.TextBlock;
import org.mapstruct.ap.shaded.freemarker.core._DelayedJQuote;
import org.mapstruct.ap.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.ap.shaded.freemarker.template.EmptyMap;
import org.mapstruct.ap.shaded.freemarker.template.TemplateDirectiveModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateTransformModel;

final class UnifiedCall
extends TemplateElement {
    private Expression nameExp;
    private Map namedArgs;
    private List positionalArgs;
    private List bodyParameterNames;
    boolean legacySyntax;
    private volatile transient SoftReference sortedNamedArgsCache;

    UnifiedCall(Expression nameExp, Map namedArgs, TemplateElement nestedBlock, List bodyParameterNames) {
        this.nameExp = nameExp;
        this.namedArgs = namedArgs;
        this.nestedBlock = nestedBlock;
        this.bodyParameterNames = bodyParameterNames;
    }

    UnifiedCall(Expression nameExp, List positionalArgs, TemplateElement nestedBlock, List bodyParameterNames) {
        this.nameExp = nameExp;
        this.positionalArgs = positionalArgs;
        if (nestedBlock == TextBlock.EMPTY_BLOCK) {
            nestedBlock = null;
        }
        this.nestedBlock = nestedBlock;
        this.bodyParameterNames = bodyParameterNames;
    }

    void accept(Environment env) throws TemplateException, IOException {
        TemplateModel tm = this.nameExp.eval(env);
        if (tm == Macro.DO_NOTHING_MACRO) {
            return;
        }
        if (tm instanceof Macro) {
            Macro macro = (Macro)tm;
            if (macro.isFunction && !this.legacySyntax) {
                throw new _MiscTemplateException(env, new Object[]{"Routine ", new _DelayedJQuote(macro.getName()), " is a function, not a directive. Functions can only be called from expressions, like in ${f()}, ${x + f()} or ", "<@someDirective someParam=f() />", "."});
            }
            env.visit(macro, this.namedArgs, this.positionalArgs, this.bodyParameterNames, this.nestedBlock);
        } else {
            boolean isDirectiveModel = tm instanceof TemplateDirectiveModel;
            if (isDirectiveModel || tm instanceof TemplateTransformModel) {
                Map args;
                if (this.namedArgs != null && !this.namedArgs.isEmpty()) {
                    args = new HashMap();
                    Iterator it = this.namedArgs.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String key = (String)entry.getKey();
                        Expression valueExp = (Expression)entry.getValue();
                        TemplateModel value = valueExp.eval(env);
                        args.put(key, value);
                    }
                } else {
                    args = EmptyMap.instance;
                }
                if (isDirectiveModel) {
                    env.visit(this.nestedBlock, (TemplateDirectiveModel)tm, args, this.bodyParameterNames);
                } else {
                    env.visitAndTransform(this.nestedBlock, (TemplateTransformModel)tm, args);
                }
            } else {
                if (tm == null) {
                    throw InvalidReferenceException.getInstance(this.nameExp, env);
                }
                throw new NonUserDefinedDirectiveLikeException(this.nameExp, tm, env);
            }
        }
    }

    protected String dump(boolean canonical) {
        boolean nameIsInParen;
        StringBuffer sb = new StringBuffer();
        if (canonical) {
            sb.append('<');
        }
        sb.append('@');
        MessageUtil.appendExpressionAsUntearable(sb, this.nameExp);
        boolean bl = nameIsInParen = sb.charAt(sb.length() - 1) == ')';
        if (this.positionalArgs != null) {
            for (int i = 0; i < this.positionalArgs.size(); ++i) {
                Expression argExp = (Expression)this.positionalArgs.get(i);
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(' ');
                sb.append(argExp.getCanonicalForm());
            }
        } else {
            List entries = this.getSortedNamedArgs();
            for (int i = 0; i < entries.size(); ++i) {
                Map.Entry entry = (Map.Entry)entries.get(i);
                Expression argExp = (Expression)entry.getValue();
                sb.append(' ');
                sb.append(entry.getKey());
                sb.append('=');
                MessageUtil.appendExpressionAsUntearable(sb, argExp);
            }
        }
        if (canonical) {
            if (this.nestedBlock == null) {
                sb.append("/>");
            } else {
                sb.append('>');
                sb.append(this.nestedBlock.getCanonicalForm());
                sb.append("</@");
                if (!nameIsInParen && (this.nameExp instanceof Identifier || this.nameExp instanceof Dot && ((Dot)this.nameExp).onlyHasIdentifiers())) {
                    sb.append(this.nameExp.getCanonicalForm());
                }
                sb.append('>');
            }
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return "@";
    }

    int getParameterCount() {
        return 1 + (this.positionalArgs != null ? this.positionalArgs.size() : 0) + (this.namedArgs != null ? this.namedArgs.size() * 2 : 0) + (this.bodyParameterNames != null ? this.bodyParameterNames.size() : 0);
    }

    Object getParameterValue(int idx) {
        int bodyParameterNamesSize;
        int namedArgsSize;
        int positionalArgsSize;
        if (idx == 0) {
            return this.nameExp;
        }
        int base = 1;
        int n = positionalArgsSize = this.positionalArgs != null ? this.positionalArgs.size() : 0;
        if (idx - base < positionalArgsSize) {
            return this.positionalArgs.get(idx - base);
        }
        int n2 = namedArgsSize = this.namedArgs != null ? this.namedArgs.size() : 0;
        if (idx - (base += positionalArgsSize) < namedArgsSize * 2) {
            Map.Entry namedArg = (Map.Entry)this.getSortedNamedArgs().get((idx - base) / 2);
            return (idx - base) % 2 == 0 ? namedArg.getKey() : namedArg.getValue();
        }
        int n3 = bodyParameterNamesSize = this.bodyParameterNames != null ? this.bodyParameterNames.size() : 0;
        if (idx - (base += namedArgsSize * 2) < bodyParameterNamesSize) {
            return this.bodyParameterNames.get(idx - base);
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        int bodyParameterNamesSize;
        int namedArgsSize;
        int positionalArgsSize;
        if (idx == 0) {
            return ParameterRole.CALLEE;
        }
        int base = 1;
        int n = positionalArgsSize = this.positionalArgs != null ? this.positionalArgs.size() : 0;
        if (idx - base < positionalArgsSize) {
            return ParameterRole.ARGUMENT_VALUE;
        }
        int n2 = namedArgsSize = this.namedArgs != null ? this.namedArgs.size() : 0;
        if (idx - (base += positionalArgsSize) < namedArgsSize * 2) {
            return (idx - base) % 2 == 0 ? ParameterRole.ARGUMENT_NAME : ParameterRole.ARGUMENT_VALUE;
        }
        int n3 = bodyParameterNamesSize = this.bodyParameterNames != null ? this.bodyParameterNames.size() : 0;
        if (idx - (base += namedArgsSize * 2) < bodyParameterNamesSize) {
            return ParameterRole.TARGET_LOOP_VARIABLE;
        }
        throw new IndexOutOfBoundsException();
    }

    private List getSortedNamedArgs() {
        List res;
        SoftReference ref = this.sortedNamedArgsCache;
        if (ref != null && (res = (List)((Reference)ref).get()) != null) {
            return res;
        }
        res = MiscUtil.sortMapOfExpressions(this.namedArgs);
        this.sortedNamedArgsCache = new SoftReference<List>(res);
        return res;
    }
}

