/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Map;
import java.util.Set;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.SupportingMappingMethod;
import org.mapstruct.ap.internal.model.common.FieldReference;
import org.mapstruct.ap.internal.util.Strings;

public class SupportingField
extends Field {
    private final String templateName;
    private final Map<String, Object> templateParameter;
    private final SupportingMappingMethod definingMethod;

    public SupportingField(SupportingMappingMethod definingMethod, FieldReference fieldReference, String name) {
        super(fieldReference.getType(), name, true);
        this.templateName = this.getTemplateNameForClass(fieldReference.getClass());
        this.templateParameter = fieldReference.getTemplateParameter();
        this.definingMethod = definingMethod;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    public Map<String, Object> getTemplateParameter() {
        return this.templateParameter;
    }

    public SupportingMappingMethod getDefiningMethod() {
        return this.definingMethod;
    }

    public static void addAllFieldsIn(Set<SupportingMappingMethod> supportingMappingMethods, Set<Field> targets) {
        for (SupportingMappingMethod supportingMappingMethod : supportingMappingMethods) {
            Field field = supportingMappingMethod.getSupportingField();
            if (field == null) continue;
            targets.add(supportingMappingMethod.getSupportingField());
        }
    }

    public static Field getSafeField(SupportingMappingMethod method, FieldReference ref, Set<Field> existingFields) {
        if (ref == null) {
            return null;
        }
        String name = ref.getVariableName();
        for (Field existingField : existingFields) {
            if (!existingField.getVariableName().equals(ref.getVariableName()) || !existingField.getType().equals(ref.getType())) continue;
            return existingField;
        }
        name = Strings.getSafeVariableName(name, Field.getFieldNames(existingFields));
        return new SupportingField(method, ref, name);
    }
}

