/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.processor.AnnotationBasedComponentModelProcessor;
import org.mapstruct.ap.internal.util.AnnotationProcessingException;

public class CdiComponentProcessor
extends AnnotationBasedComponentModelProcessor {
    @Override
    protected String getComponentModelIdentifier() {
        return "cdi";
    }

    @Override
    protected List<Annotation> getTypeAnnotations(Mapper mapper) {
        return Collections.singletonList(new Annotation(this.getType("ApplicationScoped")));
    }

    @Override
    protected List<Annotation> getMapperReferenceAnnotations() {
        return Arrays.asList(new Annotation(this.getType("Inject")));
    }

    @Override
    protected boolean requiresGenerationOfDecoratorClass() {
        return false;
    }

    @Override
    protected boolean additionalPublicEmptyConstructor() {
        return true;
    }

    private Type getType(String simpleName) {
        String javaxPrefix = "javax.inject.";
        String jakartaPrefix = "jakarta.inject.";
        if ("ApplicationScoped".equals(simpleName)) {
            javaxPrefix = "javax.enterprise.context.";
            jakartaPrefix = "jakarta.enterprise.context.";
        }
        if (this.getTypeFactory().isTypeAvailable(javaxPrefix + simpleName)) {
            return this.getTypeFactory().getType(javaxPrefix + simpleName);
        }
        if (this.getTypeFactory().isTypeAvailable(jakartaPrefix + simpleName)) {
            return this.getTypeFactory().getType(jakartaPrefix + simpleName);
        }
        throw new AnnotationProcessingException("Couldn't find any of the CDI or Jakarta CDI Dependency types. Are you missing a dependency on your classpath?");
    }
}

