/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.audioengines.javasound.JSAuralParameters;
import com.sun.j3d.audioengines.javasound.JSClip;
import com.sun.j3d.audioengines.javasound.JSDirectionalSample;
import com.sun.j3d.audioengines.javasound.JSPositionalSample;
import com.sun.j3d.audioengines.javasound.JSSample;
import com.sun.j3d.audioengines.javasound.JSStream;
import com.sun.j3d.audioengines.javasound.JSThread;
import java.util.ArrayList;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class JavaSoundMixer
extends AudioEngine3DL2 {
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;
    static final int ADD_TO_LIST = 1;
    static final int SET_INTO_LIST = 2;
    JSAuralParameters auralParams = null;
    JSThread thread = new JSThread(Thread.currentThread().getThreadGroup(), this);
    protected float deviceGain = 1.0f;
    protected static final int NOT_PAUSED = 0;
    protected static final int PAUSE_PENDING = 1;
    protected static final int PAUSED = 2;
    protected static final int RESUME_PENDING = 3;
    protected int pause = 0;

    void debugPrint(String message) {
    }

    void debugPrintln(String message) {
    }

    public JavaSoundMixer(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
    }

    @Override
    public int getTotalChannels() {
        if (this.thread != null) {
            return this.thread.getTotalChannels();
        }
        return 32;
    }

    @Override
    public boolean initialize() {
        if (this.thread == null) {
            return false;
        }
        this.thread.initialize();
        this.auralParams = new JSAuralParameters();
        return true;
    }

    @Override
    public boolean close() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepareSound(int soundType, MediaContainer soundData) {
        int index = -1;
        int methodType = 1;
        if (soundData == null) {
            return -1;
        }
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            int samplesSize;
            index = samplesSize = this.samples.size();
            this.samples.ensureCapacity(index + 1);
            boolean error = false;
            if (soundType == 3) {
                JSDirectionalSample dirSample = new JSDirectionalSample();
                error = dirSample.load(soundData);
                if (error) {
                    return -1;
                }
                if (methodType == 2) {
                    this.samples.set(index, dirSample);
                } else {
                    this.samples.add(index, dirSample);
                }
                dirSample.setDirtyFlags(65535);
                dirSample.setSoundType(soundType);
                dirSample.setSoundData(soundData);
            } else if (soundType == 2) {
                JSPositionalSample posSample = new JSPositionalSample();
                error = posSample.load(soundData);
                if (error) {
                    return -1;
                }
                if (methodType == 2) {
                    this.samples.set(index, posSample);
                } else {
                    this.samples.add(index, posSample);
                }
                posSample.setDirtyFlags(65535);
                posSample.setSoundType(soundType);
                posSample.setSoundData(soundData);
            } else {
                JSSample sample = null;
                sample = new JSSample();
                error = sample.load(soundData);
                if (error) {
                    return -1;
                }
                if (methodType == 2) {
                    this.samples.set(index, sample);
                } else {
                    this.samples.add(index, sample);
                }
                sample.setDirtyFlags(65535);
                sample.setSoundType(soundType);
                sample.setSoundData(soundData);
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSound(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return;
        }
        sample.clear();
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            this.samples.set(index, null);
        }
    }

    @Override
    public void setVworldXfrm(int index, Transform3D trans) {
        super.setVworldXfrm(index, trans);
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return;
        }
        int soundType = sample.getSoundType();
        if (soundType == 3) {
            JSDirectionalSample dirSample = null;
            dirSample = (JSDirectionalSample)this.getSample(index);
            if (dirSample == null) {
                return;
            }
            dirSample.setXformedDirection();
            dirSample.setXformedPosition();
            dirSample.setVWrldXfrmFlag(true);
        } else if (soundType == 2) {
            JSPositionalSample posSample = null;
            posSample = (JSPositionalSample)this.getSample(index);
            if (posSample == null) {
                return;
            }
            posSample.setXformedPosition();
            posSample.setVWrldXfrmFlag(true);
        }
    }

    @Override
    public void setPosition(int index, Point3d position) {
        super.setPosition(index, position);
        JSPositionalSample posSample = null;
        posSample = (JSPositionalSample)this.getSample(index);
        if (posSample == null) {
            return;
        }
        int soundType = posSample.getSoundType();
        if (soundType == 2 || soundType == 3) {
            posSample.setXformedPosition();
        }
    }

    @Override
    public void setDirection(int index, Vector3d direction) {
        super.setDirection(index, direction);
        JSDirectionalSample dirSample = null;
        dirSample = (JSDirectionalSample)this.getSample(index);
        if (dirSample == null) {
            return;
        }
        int soundType = dirSample.getSoundType();
        if (soundType == 3) {
            dirSample.setXformedDirection();
        }
    }

    @Override
    public void setReflectionCoefficient(float coefficient) {
        super.setReflectionCoefficient(coefficient);
        this.auralParams.reverbDirty |= JSAuralParameters.REFLECTION_COEFF_CHANGED;
    }

    @Override
    public void setReverbDelay(float reverbDelay) {
        super.setReverbDelay(reverbDelay);
        this.auralParams.reverbDirty |= JSAuralParameters.REVERB_DELAY_CHANGED;
    }

    @Override
    public void setReverbOrder(int reverbOrder) {
        super.setReverbOrder(reverbOrder);
        this.auralParams.reverbDirty |= JSAuralParameters.REVERB_ORDER_CHANGED;
    }

    @Override
    public int startSample(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null || this.thread == null) {
            return -1;
        }
        int soundType = sample.getSoundType();
        boolean muted = sample.getMuteFlag();
        if (muted) {
            this.thread.muteSample(sample);
            if (soundType != 1) {
                this.setFilter(index, false, -1.0f);
            }
        } else {
            sample.render(sample.getDirtyFlags(), this.getView(), this.auralParams);
            this.scaleSampleRate(index, sample.rateRatio);
            if (soundType != 1) {
                this.setFilter(index, sample.getFilterFlag(), sample.getFilterFreq());
            }
        }
        boolean startSuccessful = this.thread.startSample(sample);
        sample.channel.startSample(sample.getLoopCount(), sample.getGain(), 0);
        if (!startSuccessful) {
            return -1;
        }
        if (!muted) {
            if (this.auralParams.reverbDirty > 0) {
                float delayTime = this.auralParams.reverbDelay * this.auralParams.rolloff;
                this.calcReverb(sample);
            }
            this.setReverb(sample);
        }
        return index;
    }

    @Override
    public int stopSample(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return -1;
        }
        int dataType = sample.getDataType();
        int soundType = sample.getSoundType();
        boolean stopSuccessful = true;
        stopSuccessful = this.thread.stopSample(sample);
        sample.channel.stopSample();
        if (!stopSuccessful) {
            return -1;
        }
        sample.reset();
        return 0;
    }

    @Override
    public void pauseSample(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return;
        }
        this.thread.pauseSample(sample);
    }

    @Override
    public void unpauseSample(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return;
        }
        this.thread.unpauseSample(sample);
    }

    @Override
    public void updateSample(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null || this.thread == null) {
            return;
        }
        int soundType = sample.getSoundType();
        boolean muted = sample.getMuteFlag();
        if (muted) {
            if (soundType != 1) {
                this.setFilter(index, false, -1.0f);
            }
            this.thread.muteSample(sample);
        } else {
            if (this.auralParams.reverbDirty > 0) {
                float delayTime = this.auralParams.reverbDelay * this.auralParams.rolloff;
                this.calcReverb(sample);
            }
            this.setReverb(sample);
            float reverbGain = 0.0f;
            if (!muted && this.auralParams.reverbFlag) {
                reverbGain = sample.getGain() * this.auralParams.reflectionCoefficient;
            }
            sample.render(sample.getDirtyFlags(), this.getView(), this.auralParams);
            if (soundType != 1) {
                this.setFilter(index, sample.getFilterFlag(), sample.getFilterFreq());
            }
            this.thread.setSampleGain(sample, this.auralParams);
            this.thread.setSampleRate(sample, this.auralParams);
            this.thread.setSampleDelay(sample, this.auralParams);
        }
    }

    @Override
    public void muteSample(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return;
        }
        sample.setMuteFlag(true);
        this.thread.muteSample(sample);
    }

    @Override
    public void unmuteSample(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return;
        }
        sample.setMuteFlag(false);
        this.auralParams.reverbDirty = 65535;
        sample.setDirtyFlags(65535);
        this.thread.unmuteSample(sample);
    }

    @Override
    public long getSampleDuration(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return -1L;
        }
        long duration = sample != null ? sample.getDuration() : -1L;
        return duration;
    }

    @Override
    public int getNumberOfChannelsUsed(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return 0;
        }
        return this.getNumberOfChannelsUsed(index, sample.getMuteFlag());
    }

    @Override
    public int getNumberOfChannelsUsed(int index, boolean muted) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return 0;
        }
        int soundType = sample.getSoundType();
        int dataType = sample.getDataType();
        if (dataType == 3 || dataType == 3) {
            return 1;
        }
        if (soundType == 1) {
            return 1;
        }
        return 3;
    }

    @Override
    public long getStartTime(int index) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return 0L;
        }
        if (sample.channel == null) {
            return 0L;
        }
        return sample.channel.startTime;
    }

    void scaleSampleRate(int index, float scaleFactor) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null || this.thread == null) {
            return;
        }
        int dataType = sample.getDataType();
        int soundType = sample.getSoundType();
        if (dataType == 1 || dataType == 2) {
            this.thread.setSampleRate(sample, scaleFactor);
        } else if (dataType == 3 || dataType == 3) {
            this.thread.setSampleRate(sample, scaleFactor);
        }
    }

    void calcReverb(JSSample sample) {
        int dataType = sample.getDataType();
        int soundType = sample.getSoundType();
        float decay = this.auralParams.decayTime;
        float delay = this.auralParams.reverbDelay * this.auralParams.rolloff;
        float reflection = this.auralParams.reflectionCoefficient;
        int order = this.auralParams.reverbOrder;
        if (this.auralParams.reflectionCoefficient == 0.0f || this.auralParams.reverbCoefficient == 0.0f) {
            this.auralParams.reverbFlag = false;
        } else {
            float clampedTime;
            this.auralParams.reverbFlag = true;
            if (order > 0 && (clampedTime = (float)order * delay) < decay) {
                decay = clampedTime;
            }
            this.auralParams.reverbType = delay < 100.0f ? (decay <= 1500.0f ? 2 : 4) : (delay < 500.0f ? (decay <= 1500.0f ? 3 : 6) : (decay <= 1500.0f ? 6 : 5));
        }
        this.auralParams.reverbDirty = 0;
    }

    void setReverb(JSSample sample) {
        int soundType = sample.getSoundType();
        int dataType = sample.getDataType();
        if (soundType == 3 || soundType == 2) {
            if (sample == null) {
                return;
            }
            JSPositionalSample posSample = (JSPositionalSample)sample;
            if (posSample.channel == null) {
                return;
            }
            if (dataType == 1) {
                JSStream stream = (JSStream)posSample.channel;
                stream.setSampleReverb(this.auralParams.reverbType, this.auralParams.reverbFlag);
            } else if (dataType == 2) {
                JSClip clip = (JSClip)posSample.channel;
                clip.setSampleReverb(this.auralParams.reverbType, this.auralParams.reverbFlag);
            }
        }
    }

    @Override
    public void setLoop(int index, int count) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return;
        }
        int dataType = sample.getDataType();
        if ((dataType == 1 || dataType == 2) && count == -1) {
            count = 0x7FFFFFF;
        }
        super.setLoop(index, count);
    }

    void setFilter(int index, boolean filterFlag, float filterFreq) {
        JSPositionalSample posSample = null;
        posSample = (JSPositionalSample)this.getSample(index);
        if (posSample == null) {
            return;
        }
        if (posSample.channel == null) {
            return;
        }
        int dataType = posSample.getDataType();
        if (dataType == 3 || dataType == 3) {
            return;
        }
        if (dataType == 2) {
            JSClip clip = (JSClip)posSample.channel;
            clip.setSampleFiltering(filterFlag, filterFreq);
        } else {
            JSStream stream = (JSStream)posSample.channel;
            stream.setSampleFiltering(filterFlag, filterFreq);
        }
    }

    @Override
    public void setGain(float scaleFactor) {
        float oldDeviceGain = this.deviceGain;
        float gainFactor = scaleFactor / oldDeviceGain;
        this.deviceGain = scaleFactor;
    }

    @Override
    public void setRateScaleFactor(int index, float rateScaleFactor) {
        JSSample sample = null;
        sample = (JSSample)this.getSample(index);
        if (sample == null) {
            return;
        }
        sample.setRateScaleFactor(rateScaleFactor);
        this.scaleSampleRate(index, rateScaleFactor);
    }

    @Override
    public void pause() {
        this.pause = 1;
    }

    @Override
    public void resume() {
        this.pause = 3;
    }
}

