/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.picking;

import com.sun.j3d.utils.picking.PickTool;
import java.awt.event.MouseEvent;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Locale;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickCylinderRay;
import javax.media.j3d.PickRay;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PickCanvas
extends PickTool {
    Canvas3D canvas;
    float tolerance = 2.0f;
    int save_xpos;
    int save_ypos;

    public PickCanvas(Canvas3D c, BranchGroup b) {
        super(b);
        this.canvas = c;
    }

    public PickCanvas(Canvas3D c, Locale l) {
        super(l);
        this.canvas = c;
    }

    public Canvas3D getCanvas() {
        return this.canvas;
    }

    public void setTolerance(float t) {
        if (t < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.tolerance = t;
        if (this.pickShape != null && !this.userDefineShape) {
            this.pickShape = null;
            this.setShapeLocation(this.save_xpos, this.save_ypos);
        }
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public void setShapeLocation(MouseEvent mevent) {
        this.setShapeLocation(mevent.getX(), mevent.getY());
    }

    public void setShapeLocation(int xpos, int ypos) {
        Transform3D motion = new Transform3D();
        Point3d eyePosn = new Point3d();
        Point3d mousePosn = new Point3d();
        Vector3d mouseVec = new Vector3d();
        boolean isParallel = false;
        double radius = 0.0;
        double spreadAngle = 0.0;
        this.save_xpos = xpos;
        this.save_ypos = ypos;
        this.canvas.getCenterEyeInImagePlate(eyePosn);
        this.canvas.getPixelLocationInImagePlate(xpos, ypos, mousePosn);
        if (this.canvas.getView() != null && this.canvas.getView().getProjectionPolicy() == 0) {
            eyePosn.x = mousePosn.x;
            eyePosn.y = mousePosn.y;
            isParallel = true;
        }
        Vector3d eyeToCanvas = new Vector3d();
        eyeToCanvas.sub((Tuple3d)mousePosn, (Tuple3d)eyePosn);
        double distanceEyeToCanvas = eyeToCanvas.length();
        Point3d deltaImgPlate = new Point3d();
        this.canvas.getPixelLocationInImagePlate(xpos + 1, ypos, deltaImgPlate);
        Vector3d ptToDelta = new Vector3d();
        ptToDelta.sub((Tuple3d)mousePosn, (Tuple3d)deltaImgPlate);
        double distancePtToDelta = ptToDelta.length();
        distancePtToDelta *= (double)this.tolerance;
        this.canvas.getImagePlateToVworld(motion);
        motion.transform(eyePosn);
        this.start = new Point3d(eyePosn);
        motion.transform(mousePosn);
        mouseVec.sub((Tuple3d)mousePosn, (Tuple3d)eyePosn);
        mouseVec.normalize();
        if ((double)this.tolerance == 0.0) {
            if (this.pickShape != null && this.pickShape instanceof PickRay) {
                ((PickRay)this.pickShape).set(eyePosn, mouseVec);
            } else {
                this.pickShape = new PickRay(eyePosn, mouseVec);
            }
        } else if (isParallel) {
            distancePtToDelta *= motion.getScale();
            if (this.pickShape != null && this.pickShape instanceof PickCylinderRay) {
                ((PickCylinderRay)this.pickShape).set(eyePosn, mouseVec, distancePtToDelta);
            } else {
                this.pickShape = new PickCylinderRay(eyePosn, mouseVec, distancePtToDelta);
            }
        } else {
            spreadAngle = Math.atan(distancePtToDelta / distanceEyeToCanvas);
            if (this.pickShape != null && this.pickShape instanceof PickConeRay) {
                ((PickConeRay)this.pickShape).set(eyePosn, mouseVec, spreadAngle);
            } else {
                this.pickShape = new PickConeRay(eyePosn, mouseVec, spreadAngle);
            }
        }
    }
}

