/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.BehaviorState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.LOD;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Switch;

public abstract class LODState
extends BehaviorState {
    private int[] switches;

    public LODState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.switches = new int[((LOD)this.node).numSwitches()];
            for (int i = 0; i < this.switches.length; ++i) {
                this.switches[i] = control.getSymbolTable().addReference((SceneGraphObject)((LOD)this.node).getSwitch(i));
            }
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.switches.length);
        for (int i = 0; i < this.switches.length; ++i) {
            out.writeInt(this.switches[i]);
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        LOD attr = (LOD)this.node;
        this.switches = new int[in.readInt()];
        for (int i = 0; i < this.switches.length; ++i) {
            this.switches[i] = in.readInt();
        }
    }

    @Override
    public void buildGraph() {
        LOD attr = (LOD)this.node;
        for (int i = 0; i < this.switches.length; ++i) {
            attr.addSwitch((Switch)this.control.getSymbolTable().getJ3dNode(this.switches[i]));
        }
        super.buildGraph();
    }
}

