/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.image;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.imageio.ImageIO;
import org.scijava.java3d.ImageComponent;
import org.scijava.java3d.ImageComponent2D;
import org.scijava.java3d.Texture;
import org.scijava.java3d.Texture2D;
import org.scijava.java3d.utils.image.ImageException;

public class TextureLoader {
    public static final int GENERATE_MIPMAP = 1;
    public static final int BY_REFERENCE = 2;
    public static final int Y_UP = 4;
    public static final int ALLOW_NON_POWER_OF_TWO = 8;
    private static ColorSpace cs = ColorSpace.getInstance(1000);
    private static int[] nBits = new int[]{8, 8, 8, 8};
    private static int[] bandOffset = new int[]{0, 1, 2, 3};
    private static ComponentColorModel colorModel = new ComponentColorModel(cs, nBits, true, false, 3, 0);
    private Texture2D tex = null;
    private BufferedImage bufferedImage = null;
    private ImageComponent2D imageComponent = null;
    private int textureFormat = 6;
    private int imageComponentFormat = 2;
    private int flags;
    private boolean byRef = false;
    private boolean yUp = false;
    private boolean forcePowerOfTwo = true;

    public TextureLoader(BufferedImage bImage) {
        this(bImage, null, 0);
    }

    public TextureLoader(BufferedImage bImage, String format) {
        this(bImage, format, 0);
    }

    public TextureLoader(BufferedImage bImage, int flags) {
        this(bImage, null, flags);
    }

    public TextureLoader(BufferedImage bImage, String format, int flags) {
        if (bImage == null) {
            throw new NullPointerException();
        }
        this.parseFormat(format);
        this.flags = flags;
        this.bufferedImage = bImage;
        if (format == null) {
            this.chooseFormat(this.bufferedImage);
        }
        if ((flags & 2) != 0) {
            this.byRef = true;
        }
        if ((flags & 4) != 0) {
            this.yUp = true;
        }
        if ((flags & 8) != 0) {
            this.forcePowerOfTwo = false;
        }
    }

    public TextureLoader(Image image, Component observer) {
        this(image, null, 0, observer);
    }

    public TextureLoader(Image image, String format, Component observer) {
        this(image, format, 0, observer);
    }

    public TextureLoader(Image image, int flags, Component observer) {
        this(image, null, flags, observer);
    }

    public TextureLoader(Image image, String format, int flags, Component observer) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (observer == null) {
            observer = new Container();
        }
        this.parseFormat(format);
        this.flags = flags;
        this.bufferedImage = this.createBufferedImage(image, observer);
        if (this.bufferedImage == null) {
            throw new ImageException("Error loading image: " + image.toString());
        }
        if (format == null) {
            this.chooseFormat(this.bufferedImage);
        }
        if ((flags & 2) != 0) {
            this.byRef = true;
        }
        if ((flags & 4) != 0) {
            this.yUp = true;
        }
        if ((flags & 8) != 0) {
            this.forcePowerOfTwo = false;
        }
    }

    public TextureLoader(String fname, Component observer) {
        this(fname, null, 0, observer);
    }

    public TextureLoader(String fname, String format, Component observer) {
        this(fname, format, 0, observer);
    }

    public TextureLoader(String fname, int flags, Component observer) {
        this(fname, null, flags, observer);
    }

    public TextureLoader(final String fname, String format, int flags, Component observer) {
        if (observer == null) {
            observer = new Container();
        }
        this.bufferedImage = (BufferedImage)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return ImageIO.read(new File(fname));
                }
                catch (IOException e) {
                    throw new ImageException(e);
                }
            }
        });
        if (this.bufferedImage == null) {
            throw new ImageException("Error loading image: " + fname);
        }
        this.parseFormat(format);
        this.flags = flags;
        if (format == null) {
            this.chooseFormat(this.bufferedImage);
        }
        if ((flags & 2) != 0) {
            this.byRef = true;
        }
        if ((flags & 4) != 0) {
            this.yUp = true;
        }
        if ((flags & 8) != 0) {
            this.forcePowerOfTwo = false;
        }
    }

    public TextureLoader(URL url, Component observer) {
        this(url, null, 0, observer);
    }

    public TextureLoader(URL url, String format, Component observer) {
        this(url, format, 0, observer);
    }

    public TextureLoader(URL url, int flags, Component observer) {
        this(url, null, flags, observer);
    }

    public TextureLoader(final URL url, String format, int flags, Component observer) {
        if (observer == null) {
            observer = new Container();
        }
        this.bufferedImage = (BufferedImage)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return ImageIO.read(url);
                }
                catch (IOException e) {
                    throw new ImageException(e);
                }
            }
        });
        if (this.bufferedImage == null) {
            throw new ImageException("Error loading image: " + url.toString());
        }
        this.parseFormat(format);
        this.flags = flags;
        if (format == null) {
            this.chooseFormat(this.bufferedImage);
        }
        if ((flags & 2) != 0) {
            this.byRef = true;
        }
        if ((flags & 4) != 0) {
            this.yUp = true;
        }
        if ((flags & 8) != 0) {
            this.forcePowerOfTwo = false;
        }
    }

    public ImageComponent2D getImage() {
        if (this.imageComponent == null) {
            this.imageComponent = new ImageComponent2D(this.imageComponentFormat, this.bufferedImage, this.byRef, this.yUp);
        }
        return this.imageComponent;
    }

    public ImageComponent2D getScaledImage(float xScale, float yScale) {
        if (xScale == 1.0f && yScale == 1.0f) {
            return this.getImage();
        }
        return new ImageComponent2D(this.imageComponentFormat, this.getScaledImage(this.bufferedImage, xScale, yScale), this.byRef, this.yUp);
    }

    public ImageComponent2D getScaledImage(int width, int height) {
        if (this.bufferedImage.getWidth() == width && this.bufferedImage.getHeight() == height) {
            return this.getImage();
        }
        return new ImageComponent2D(this.imageComponentFormat, this.getScaledImage(this.bufferedImage, width, height), this.byRef, this.yUp);
    }

    public Texture getTexture() {
        ImageComponent2D[] scaledImageComponents = null;
        BufferedImage[] scaledBufferedImages = null;
        if (this.tex == null) {
            int height;
            int width;
            if (this.forcePowerOfTwo) {
                width = this.getClosestPowerOf2(this.bufferedImage.getWidth());
                height = this.getClosestPowerOf2(this.bufferedImage.getHeight());
            } else {
                width = this.bufferedImage.getWidth();
                height = this.bufferedImage.getHeight();
            }
            if ((this.flags & 1) != 0) {
                BufferedImage origImage = this.bufferedImage;
                int newW = width;
                int newH = height;
                int level = Math.max(this.computeLog(width), this.computeLog(height)) + 1;
                scaledImageComponents = new ImageComponent2D[level];
                scaledBufferedImages = new BufferedImage[level];
                this.tex = new Texture2D(2, this.textureFormat, width, height);
                for (int i = 0; i < level; ++i) {
                    scaledBufferedImages[i] = this.getScaledImage(origImage, newW, newH);
                    scaledImageComponents[i] = new ImageComponent2D(this.imageComponentFormat, scaledBufferedImages[i], this.byRef, this.yUp);
                    this.tex.setImage(i, (ImageComponent)scaledImageComponents[i]);
                    if (this.forcePowerOfTwo) {
                        if (newW > 1) {
                            newW >>= 1;
                        }
                        if (newH > 1) {
                            newH >>= 1;
                        }
                    } else {
                        if (newW > 1) {
                            newW = (int)Math.floor((double)newW / 2.0);
                        }
                        if (newH > 1) {
                            newH = (int)Math.floor((double)newH / 2.0);
                        }
                    }
                    origImage = scaledBufferedImages[i];
                }
            } else {
                scaledImageComponents = new ImageComponent2D[1];
                scaledBufferedImages = new BufferedImage[]{this.getScaledImage(this.bufferedImage, width, height)};
                scaledImageComponents[0] = new ImageComponent2D(this.imageComponentFormat, scaledBufferedImages[0], this.byRef, this.yUp);
                this.tex = new Texture2D(1, this.textureFormat, width, height);
                this.tex.setImage(0, (ImageComponent)scaledImageComponents[0]);
            }
            this.tex.setMinFilter(3);
            this.tex.setMagFilter(3);
        }
        return this.tex;
    }

    private BufferedImage createBufferedImage(Image image, Component observer) {
        observer.prepareImage(image, null);
        while (true) {
            int status;
            if (((status = observer.checkImage(image, null)) & 0x40) != 0) {
                return null;
            }
            if ((status & 0x20) != 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        int width = image.getWidth(observer);
        int height = image.getHeight(observer);
        WritableRaster wr = Raster.createInterleavedRaster(0, width, height, width * 4, 4, bandOffset, null);
        BufferedImage bImage = new BufferedImage(colorModel, wr, false, null);
        Graphics g = bImage.getGraphics();
        g.drawImage(image, 0, 0, observer);
        return bImage;
    }

    private void chooseFormat(BufferedImage image) {
        switch (image.getType()) {
            case 2: 
            case 6: {
                this.imageComponentFormat = 2;
                this.textureFormat = 6;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                this.imageComponentFormat = 1;
                this.textureFormat = 5;
                break;
            }
            case 0: {
                if (!this.is4ByteRGBAOr3ByteRGB(image)) break;
                SampleModel sm = image.getSampleModel();
                if (sm.getNumBands() == 3) {
                    this.imageComponentFormat = 1;
                    this.textureFormat = 5;
                    break;
                }
                this.imageComponentFormat = 2;
                this.textureFormat = 6;
                break;
            }
            default: {
                this.imageComponentFormat = 2;
                this.textureFormat = 6;
            }
        }
    }

    private boolean is4ByteRGBAOr3ByteRGB(RenderedImage ri) {
        boolean value = false;
        int biType = this.getImageType(ri);
        if (biType != 0) {
            return false;
        }
        ColorModel cm = ri.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        SampleModel sm = ri.getSampleModel();
        boolean isAlphaPre = cm.isAlphaPremultiplied();
        int csType = cs.getType();
        if (csType == 5) {
            int numBands = sm.getNumBands();
            if (sm.getDataType() == 0 && cm instanceof ComponentColorModel && sm instanceof PixelInterleavedSampleModel) {
                PixelInterleavedSampleModel csm = (PixelInterleavedSampleModel)sm;
                int[] offs = csm.getBandOffsets();
                ComponentColorModel ccm = (ComponentColorModel)cm;
                int[] nBits = ccm.getComponentSize();
                boolean is8Bit = true;
                for (int i = 0; i < numBands; ++i) {
                    if (nBits[i] == 8) continue;
                    is8Bit = false;
                    break;
                }
                if (is8Bit && offs[0] == 0 && offs[1] == 1 && offs[2] == 2) {
                    if (numBands == 3) {
                        value = true;
                    } else if (offs[3] == 3 && !isAlphaPre) {
                        value = true;
                    }
                }
            }
        }
        return value;
    }

    private int getImageType(RenderedImage ri) {
        int imageType = 0;
        if (ri instanceof BufferedImage) {
            return ((BufferedImage)ri).getType();
        }
        ColorModel cm = ri.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        SampleModel sm = ri.getSampleModel();
        int csType = cs.getType();
        boolean isAlphaPre = cm.isAlphaPremultiplied();
        if (csType != 5) {
            if (csType == 6 && cm instanceof ComponentColorModel) {
                if (sm.getDataType() == 0) {
                    imageType = 10;
                } else if (sm.getDataType() == 1) {
                    imageType = 11;
                }
            }
        } else {
            int numBands = sm.getNumBands();
            if (sm.getDataType() == 0 && cm instanceof ComponentColorModel && sm instanceof PixelInterleavedSampleModel) {
                PixelInterleavedSampleModel csm = (PixelInterleavedSampleModel)sm;
                int[] offs = csm.getBandOffsets();
                ComponentColorModel ccm = (ComponentColorModel)cm;
                int[] nBits = ccm.getComponentSize();
                boolean is8Bit = true;
                for (int i = 0; i < numBands; ++i) {
                    if (nBits[i] == 8) continue;
                    is8Bit = false;
                    break;
                }
                if (is8Bit && offs[0] == numBands - 1 && offs[1] == numBands - 2 && offs[2] == numBands - 3) {
                    if (numBands == 3) {
                        imageType = 5;
                    } else if (offs[3] == 0) {
                        imageType = isAlphaPre ? 7 : 6;
                    }
                }
            }
        }
        return imageType;
    }

    private void parseFormat(String format) {
        if (format == null) {
            return;
        }
        if (format.equals("RGBA")) {
            this.imageComponentFormat = 2;
            this.textureFormat = 6;
        } else if (format.equals("RGBA4")) {
            this.imageComponentFormat = 6;
            this.textureFormat = 6;
        } else if (format.equals("RGB5_A1")) {
            this.imageComponentFormat = 4;
            this.textureFormat = 6;
        } else if (format.equals("RGB")) {
            this.imageComponentFormat = 1;
            this.textureFormat = 5;
        } else if (format.equals("RGB4")) {
            this.imageComponentFormat = 5;
            this.textureFormat = 5;
        } else if (format.equals("RGB5")) {
            this.imageComponentFormat = 3;
            this.textureFormat = 5;
        } else if (format.equals("R3_G3_B2")) {
            this.imageComponentFormat = 9;
            this.textureFormat = 5;
        } else if (format.equals("LUM8_ALPHA8")) {
            this.imageComponentFormat = 8;
            this.textureFormat = 4;
        } else if (format.equals("LUM4_ALPHA4")) {
            this.imageComponentFormat = 7;
            this.textureFormat = 4;
        } else if (format.equals("LUMINANCE")) {
            this.imageComponentFormat = 10;
            this.textureFormat = 2;
        } else if (format.equals("ALPHA")) {
            this.imageComponentFormat = 10;
            this.textureFormat = 3;
        }
    }

    private BufferedImage getScaledImage(BufferedImage origImage, int width, int height) {
        int origW = origImage.getWidth();
        int origH = origImage.getHeight();
        float xScale = (float)width / (float)origW;
        float yScale = (float)height / (float)origH;
        return this.getScaledImage(origImage, xScale, yScale);
    }

    private BufferedImage getScaledImage(BufferedImage origImage, float xScale, float yScale) {
        BufferedImage scaledImage;
        WritableRaster wr;
        if (xScale == 1.0f && yScale == 1.0f) {
            return origImage;
        }
        int scaleW = (int)((double)((float)origImage.getWidth() * xScale) + 0.5);
        int scaleH = (int)((double)((float)origImage.getHeight() * yScale) + 0.5);
        int origImageType = origImage.getType();
        if (origImageType != 0) {
            WritableRaster origWr = origImage.getRaster();
            wr = origWr.createCompatibleWritableRaster(0, 0, scaleW, scaleH);
            scaledImage = new BufferedImage(scaleW, scaleH, origImageType);
        } else {
            int imageType;
            int numComponents = origImage.getSampleModel().getNumBands();
            int[] bandOffset = new int[numComponents];
            int[] nBits = new int[numComponents];
            for (int ii = 0; ii < numComponents; ++ii) {
                bandOffset[ii] = ii;
                nBits[ii] = 8;
            }
            wr = Raster.createInterleavedRaster(0, scaleW, scaleH, scaleW * numComponents, numComponents, bandOffset, null);
            switch (numComponents) {
                case 1: {
                    imageType = 10;
                    break;
                }
                case 3: {
                    imageType = 5;
                    break;
                }
                case 4: {
                    imageType = 6;
                    break;
                }
                default: {
                    throw new ImageException("Illegal number of bands : " + numComponents);
                }
            }
            scaledImage = new BufferedImage(scaleW, scaleH, imageType);
        }
        scaledImage.setData(wr);
        Graphics2D g2 = scaledImage.createGraphics();
        AffineTransform at = AffineTransform.getScaleInstance(xScale, yScale);
        g2.transform(at);
        g2.drawImage((Image)origImage, 0, 0, null);
        return scaledImage;
    }

    private int computeLog(int value) {
        int i = 0;
        if (value == 0) {
            return -1;
        }
        while (value != 1) {
            value >>= 1;
            ++i;
        }
        return i;
    }

    private int getClosestPowerOf2(int value) {
        if (value < 1) {
            return value;
        }
        int powerValue = 1;
        while (value >= (powerValue *= 2)) {
        }
        int minBound = powerValue / 2;
        if (powerValue - value > value - minBound) {
            return minBound;
        }
        return powerValue;
    }
}

