/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import com.carrotsearch.junitbenchmarks.AutocloseConsumer;
import com.carrotsearch.junitbenchmarks.Escape;
import com.carrotsearch.junitbenchmarks.Result;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class XMLConsumer
extends AutocloseConsumer
implements Closeable {
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private Writer writer;
    private final StringBuilder b = new StringBuilder();
    private final NumberFormat nf;

    public XMLConsumer() throws IOException {
        this(XMLConsumer.getDefaultOutputFile());
    }

    public XMLConsumer(File fileName) throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
        XMLConsumer.addAutoclose(this);
        this.writer.write("<benchmark-results tstamp=\"" + XMLConsumer.tstamp() + "\">\n\n");
        this.nf = NumberFormat.getInstance(Locale.ENGLISH);
        this.nf.setMaximumFractionDigits(3);
        this.nf.setGroupingUsed(false);
    }

    public void accept(Result result) throws IOException {
        this.b.setLength(0);
        this.b.append("\t<testname");
        this.attribute(this.b, "classname", result.getTestClassName());
        this.attribute(this.b, "name", result.getTestMethodName());
        this.b.append("\n\t\t");
        this.attribute(this.b, "benchmark-rounds", Integer.toString(result.benchmarkRounds));
        this.attribute(this.b, "warmup-rounds", Integer.toString(result.warmupRounds));
        this.b.append("\n\t\t");
        this.attribute(this.b, "round-avg", this.nf.format(result.roundAverage.avg));
        this.attribute(this.b, "round-stddev", this.nf.format(result.roundAverage.stddev));
        this.b.append("\n\t\t");
        this.attribute(this.b, "gc-avg", this.nf.format(result.gcAverage.avg));
        this.attribute(this.b, "gc-stddev", this.nf.format(result.gcAverage.stddev));
        this.b.append("\n\t\t");
        this.attribute(this.b, "gc-invocations", Long.toString(result.gcInfo.accumulatedInvocations()));
        this.attribute(this.b, "gc-time", this.nf.format((double)result.gcInfo.accumulatedTime() / 1000.0));
        this.b.append("\n\t\t");
        this.attribute(this.b, "benchmark-time-total", this.nf.format((double)result.benchmarkTime * 0.001));
        this.attribute(this.b, "warmup-time-total", this.nf.format((double)result.warmupTime * 0.001));
        this.b.append("\n\t\t");
        this.attribute(this.b, "threads", Integer.toString(result.getThreadCount()));
        this.b.append("/>\n\n");
        this.writer.write(this.b.toString());
        this.writer.flush();
    }

    public void close() {
        try {
            if (this.writer != null) {
                this.writer.write("</benchmark-results>");
                this.writer.close();
                this.writer = null;
                XMLConsumer.removeAutoclose(this);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File getDefaultOutputFile() {
        String xmlPath = System.getProperty("jub.xml.file");
        if (xmlPath != null && !xmlPath.trim().equals("")) {
            return new File(xmlPath);
        }
        throw new IllegalArgumentException("Missing global property: jub.xml.file");
    }

    private static String tstamp() {
        SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_FORMAT);
        return sdf.format(new Date());
    }

    private void attribute(StringBuilder b, String attrName, String value) {
        b.append(' ');
        b.append(attrName);
        b.append("=\"");
        b.append(Escape.xmlAttrEscape(value));
        b.append('\"');
    }
}

