/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command.console;

import java.util.LinkedList;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;
import org.scijava.console.AbstractConsoleArgument;
import org.scijava.console.ConsoleArgument;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=ConsoleArgument.class)
public class RunArgument
extends AbstractConsoleArgument {
    @Parameter
    private CommandService commandService;

    @Override
    public void handle(LinkedList<String> args) {
        if (!this.supports(args)) {
            return;
        }
        args.removeFirst();
        String commandToRun = args.removeFirst();
        String optionString = args.isEmpty() ? "" : args.removeFirst();
        this.run(commandToRun, optionString);
    }

    @Override
    public boolean supports(LinkedList<String> args) {
        return args != null && args.size() >= 2 && args.getFirst().equals("--run");
    }

    private void run(String commandToRun, String optionString) {
        CommandInfo info = this.commandService.getCommand(commandToRun);
        if (info == null) {
            String label = commandToRun.replace('_', ' ');
            for (CommandInfo ci : this.commandService.getCommands()) {
                if (!label.equals(ci.getTitle())) continue;
                info = ci;
                break;
            }
        }
        if (info == null) {
            return;
        }
        this.commandService.run(info, true, new Object[0]);
    }
}

