/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.options;

import org.scijava.command.DynamicCommand;
import org.scijava.event.EventService;
import org.scijava.module.ModuleItem;
import org.scijava.options.event.OptionsEvent;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.SingletonPlugin;
import org.scijava.util.Prefs;

public class OptionsPlugin
extends DynamicCommand
implements SingletonPlugin {
    @Parameter
    protected EventService eventService;

    public void load() {
        for (ModuleItem<?> input : this.getInfo().inputs()) {
            this.loadInput(input);
        }
    }

    public void save() {
        for (ModuleItem<?> input : this.getInfo().inputs()) {
            this.saveInput(input);
        }
    }

    public void reset() {
        Prefs.clear(this.getClass());
    }

    @Override
    public void run() {
        this.save();
        for (ModuleItem<?> input : this.getInfo().inputs()) {
            this.setResolved(input.getName(), false);
        }
        this.eventService.publish(new OptionsEvent(this));
    }

    private <T> void loadInput(ModuleItem<T> input) {
        T value = input.loadValue();
        if (value != null) {
            input.setValue(this, value);
        }
    }

    private <T> void saveInput(ModuleItem<T> input) {
        T value = input.getValue(this);
        input.saveValue(value);
    }
}

