/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.scijava.InstantiableException;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginIndex;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.plugin.SciJavaPlugin;
import org.scijava.plugin.event.PluginsAddedEvent;
import org.scijava.plugin.event.PluginsRemovedEvent;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.ListUtils;

@Plugin(type=Service.class)
public class DefaultPluginService
extends AbstractService
implements PluginService {
    @Parameter
    private LogService log;
    @Parameter
    private EventService eventService;
    private PluginIndex pluginIndex;

    @Override
    public PluginIndex getIndex() {
        return this.pluginIndex;
    }

    @Override
    public void reloadPlugins() {
        List oldPlugins = this.pluginIndex.getAll();
        this.pluginIndex.clear();
        if (oldPlugins.size() > 0) {
            this.eventService.publish(new PluginsRemovedEvent(oldPlugins));
        }
        this.pluginIndex.discover();
        List newPlugins = this.pluginIndex.getAll();
        if (newPlugins.size() > 0) {
            this.eventService.publish(new PluginsAddedEvent(newPlugins));
        }
        this.logExceptions();
    }

    @Override
    public void addPlugin(PluginInfo<?> plugin) {
        if (this.pluginIndex.add(plugin)) {
            this.eventService.publish(new PluginsAddedEvent(plugin));
        }
    }

    @Override
    public <T extends PluginInfo<?>> void addPlugins(Collection<T> plugins) {
        if (this.pluginIndex.addAll(plugins)) {
            this.eventService.publish(new PluginsAddedEvent((Collection<? extends PluginInfo<?>>)plugins));
        }
    }

    @Override
    public void removePlugin(PluginInfo<?> plugin) {
        if (this.pluginIndex.remove(plugin)) {
            this.eventService.publish(new PluginsRemovedEvent(plugin));
        }
    }

    @Override
    public <T extends PluginInfo<?>> void removePlugins(Collection<T> plugins) {
        if (this.pluginIndex.removeAll(plugins)) {
            this.eventService.publish(new PluginsRemovedEvent((Collection<? extends PluginInfo<?>>)plugins));
        }
    }

    @Override
    public List<PluginInfo<?>> getPlugins() {
        return this.pluginIndex.getAll();
    }

    @Override
    public <P extends SciJavaPlugin> PluginInfo<SciJavaPlugin> getPlugin(Class<P> pluginClass) {
        return ListUtils.first(this.getPluginsOfClass(pluginClass));
    }

    @Override
    public <PT extends SciJavaPlugin, P extends PT> PluginInfo<PT> getPlugin(Class<P> pluginClass, Class<PT> type) {
        return ListUtils.first(this.getPluginsOfClass(pluginClass, type));
    }

    @Override
    public PluginInfo<SciJavaPlugin> getPlugin(String className) {
        return ListUtils.first(this.getPluginsOfClass(className));
    }

    @Override
    public <PT extends SciJavaPlugin> List<PluginInfo<PT>> getPluginsOfType(Class<PT> type) {
        return this.pluginIndex.getPlugins(type);
    }

    @Override
    public <P extends SciJavaPlugin> List<PluginInfo<SciJavaPlugin>> getPluginsOfClass(Class<P> pluginClass) {
        return this.getPluginsOfClass(pluginClass, SciJavaPlugin.class);
    }

    @Override
    public <PT extends SciJavaPlugin, P extends PT> List<PluginInfo<PT>> getPluginsOfClass(Class<P> pluginClass, Class<PT> type) {
        ArrayList<PluginInfo<PT>> result = new ArrayList<PluginInfo<PT>>();
        this.findPluginsOfClass(pluginClass, this.getPluginsOfType(type), result);
        this.filterNonmatchingClasses(pluginClass, result);
        return result;
    }

    @Override
    public List<PluginInfo<SciJavaPlugin>> getPluginsOfClass(String className) {
        return this.getPluginsOfClass(className, SciJavaPlugin.class);
    }

    @Override
    public <PT extends SciJavaPlugin> List<PluginInfo<SciJavaPlugin>> getPluginsOfClass(String className, Class<PT> type) {
        ArrayList<PluginInfo<SciJavaPlugin>> result = new ArrayList<PluginInfo<SciJavaPlugin>>();
        DefaultPluginService.findPluginsOfClass(className, this.getPluginsOfType(type), result);
        return result;
    }

    @Override
    public <PT extends SciJavaPlugin> List<PT> createInstancesOfType(Class<PT> type) {
        List<PluginInfo<PT>> plugins = this.getPluginsOfType(type);
        return this.createInstances(plugins);
    }

    @Override
    public <PT extends SciJavaPlugin> List<PT> createInstances(List<PluginInfo<PT>> infos) {
        ArrayList<PT> list = new ArrayList<PT>();
        for (PluginInfo<PT> info : infos) {
            PT p = this.createInstance(info);
            if (p == null) continue;
            list.add(p);
        }
        return list;
    }

    @Override
    public <PT extends SciJavaPlugin> PT createInstance(PluginInfo<PT> info) {
        try {
            Object p = info.createInstance();
            this.context().inject(p);
            return (PT)p;
        }
        catch (Throwable t) {
            this.log.error("Cannot create plugin: " + info, t);
            return null;
        }
    }

    @Override
    public void initialize() {
        this.pluginIndex = this.context().getPluginIndex();
        this.log.info("Found " + this.pluginIndex.size() + " plugins.");
        if (this.log.isDebug()) {
            for (PluginInfo info : this.pluginIndex) {
                this.log.debug("- " + info);
            }
        }
        this.logExceptions();
        super.initialize();
    }

    public static <T extends PluginInfo<?>> void findPluginsOfClass(String className, List<? extends PluginInfo<?>> srcList, List<T> destList) {
        for (PluginInfo<?> info : srcList) {
            if (!info.getClassName().equals(className)) continue;
            PluginInfo<?> match = info;
            destList.add(match);
        }
    }

    public static <PT extends SciJavaPlugin, P extends PT> Class<PT> getPluginType(Class<P> pluginClass) {
        Plugin annotation = pluginClass.getAnnotation(Plugin.class);
        if (annotation == null) {
            return null;
        }
        Class<? extends SciJavaPlugin> type = annotation.type();
        return type;
    }

    private <T extends PluginInfo<?>> void findPluginsOfClass(Class<?> pluginClass, List<? extends PluginInfo<?>> srcList, List<T> destList) {
        String className = pluginClass.getName();
        for (PluginInfo<?> info : srcList) {
            try {
                Class<?> clazz2 = info.getPluginClass();
                if (clazz2 != pluginClass && (!info.getClassName().equals(className) || info.loadClass() != pluginClass)) continue;
                PluginInfo<?> match = info;
                destList.add(match);
            }
            catch (InstantiableException exc) {
                this.log.debug("Ignoring plugin: " + info, exc);
            }
        }
    }

    private <PT extends SciJavaPlugin, P extends PT> void filterNonmatchingClasses(Class<P> pluginClass, ArrayList<PluginInfo<PT>> result) {
        Iterator<PluginInfo<PT>> iter = result.iterator();
        while (iter.hasNext()) {
            try {
                if (iter.next().loadClass() == pluginClass) continue;
                iter.remove();
            }
            catch (InstantiableException exc) {
                this.log.debug(exc);
                iter.remove();
            }
        }
    }

    private void logExceptions() {
        Map<String, Throwable> exceptions = this.pluginIndex.getExceptions();
        int excCount = exceptions.size();
        if (excCount > 0) {
            this.log.warn(excCount + " exceptions occurred during plugin discovery.");
            if (this.log.isDebug()) {
                for (String name : exceptions.keySet()) {
                    Throwable t = exceptions.get(name);
                    this.log.debug(name, t);
                }
            }
        }
    }
}

