/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.plugin.PluginIndex;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.plugin.SciJavaPlugin;

public class PluginIndexTest {
    @Test
    public void testGetPluginsOfClass() {
        Context context = new Context(new Class[]{PluginService.class});
        PluginIndex pluginIndex = context.getPluginIndex();
        PluginInfo testPlugin = new PluginInfo(FooBar.class.getName(), SciJavaPlugin.class);
        pluginIndex.add((Object)testPlugin);
        PluginService pluginService = (PluginService)context.getService(PluginService.class);
        List plugins = pluginService.getPluginsOfClass(FooBar.class);
        Assert.assertEquals((long)1L, (long)plugins.size());
        Assert.assertSame((Object)testPlugin, plugins.get(0));
        PluginInfo plugin = pluginService.getPlugin(FooBar.class);
        Assert.assertSame((Object)testPlugin, (Object)plugin);
    }

    @Test
    public void testGetPluginsOfClassString() {
        Context context = new Context(new Class[]{PluginService.class});
        PluginIndex pluginIndex = context.getPluginIndex();
        String fakeClass = "foo.bar.FooBar";
        PluginInfo testPlugin = new PluginInfo("foo.bar.FooBar", SciJavaPlugin.class);
        pluginIndex.add((Object)testPlugin);
        PluginService pluginService = (PluginService)context.getService(PluginService.class);
        List plugins = pluginService.getPluginsOfClass("foo.bar.FooBar");
        Assert.assertEquals((long)1L, (long)plugins.size());
        Assert.assertSame((Object)testPlugin, plugins.get(0));
        PluginInfo plugin = pluginService.getPlugin("foo.bar.FooBar");
        Assert.assertSame((Object)testPlugin, (Object)plugin);
    }

    public static class FooBar
    implements SciJavaPlugin {
    }
}

