/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.io.RecentFileService;
import org.scijava.io.event.IOEvent;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.PrefService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.FileUtils;

@Plugin(type=Service.class)
public final class DefaultRecentFileService
extends AbstractService
implements RecentFileService {
    private static final int MAX_DISPLAY_LENGTH = 40;
    private static final String RECENT_MENU_NAME = "Open Recent";
    private static final String RECENT_FILES_KEY = "recentfiles";
    @Parameter
    private EventService eventService;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private PrefService prefService;
    private List<String> recentFiles;
    private Map<String, ModuleInfo> recentModules;

    @Override
    public void add(String path) {
        boolean present = this.recentModules.containsKey(path);
        if (present) {
            this.recentFiles.remove(path);
        }
        this.recentFiles.add(path);
        this.prefService.putList(this.recentFiles, RECENT_FILES_KEY);
        if (present) {
            ModuleInfo info = this.recentModules.get(path);
            info.update(this.eventService);
        } else {
            ModuleInfo info = this.createInfo(path);
            this.recentModules.put(path, info);
            this.moduleService.addModule(info);
        }
    }

    @Override
    public boolean remove(String path) {
        boolean success = this.recentFiles.remove(path);
        this.prefService.putList(this.recentFiles, RECENT_FILES_KEY);
        ModuleInfo info = this.recentModules.remove(path);
        if (info != null) {
            this.moduleService.removeModule(info);
        }
        return success;
    }

    @Override
    public void clear() {
        this.recentFiles.clear();
        this.prefService.clear(RECENT_FILES_KEY);
        this.moduleService.removeModules(this.recentModules.values());
        this.recentModules.clear();
    }

    @Override
    public List<String> getRecentFiles() {
        return Collections.unmodifiableList(this.recentFiles);
    }

    @Override
    public void initialize() {
        this.recentFiles = this.prefService.getList(RECENT_FILES_KEY);
        this.recentModules = new HashMap<String, ModuleInfo>();
        for (String path : this.recentFiles) {
            this.recentModules.put(path, this.createInfo(path));
        }
        this.moduleService.addModules(this.recentModules.values());
    }

    @EventHandler
    protected void onEvent(IOEvent event) {
        this.add(event.getDescriptor());
    }

    private ModuleInfo createInfo(String path) {
        String commandClassName = "imagej.plugins.commands.io.OpenFile";
        CommandInfo info = new CommandInfo("imagej.plugins.commands.io.OpenFile");
        HashMap<String, Object> presets = new HashMap<String, Object>();
        presets.put("inputFile", path);
        info.setPresets(presets);
        MenuPath menuPath = new MenuPath();
        menuPath.add(new MenuEntry("File"));
        menuPath.add(new MenuEntry(RECENT_MENU_NAME));
        MenuEntry leaf = new MenuEntry(this.shortPath(path));
        menuPath.add(leaf);
        info.setMenuPath(menuPath);
        leaf.setWeight(0.0);
        CommandInfo fileOpen = this.commandService.getCommand("imagej.plugins.commands.io.OpenFile");
        if (fileOpen != null) {
            String iconPath = fileOpen.getIconPath();
            info.setIconPath(iconPath);
        }
        return info;
    }

    private String shortPath(String path) {
        return FileUtils.limitPath(path, 40);
    }
}

