/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.tool;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.app.StatusService;
import org.scijava.display.event.DisplayEvent;
import org.scijava.display.event.input.KyPressedEvent;
import org.scijava.display.event.input.KyReleasedEvent;
import org.scijava.display.event.input.MsClickedEvent;
import org.scijava.display.event.input.MsDraggedEvent;
import org.scijava.display.event.input.MsMovedEvent;
import org.scijava.display.event.input.MsPressedEvent;
import org.scijava.display.event.input.MsReleasedEvent;
import org.scijava.display.event.input.MsWheelEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;
import org.scijava.tool.DummyTool;
import org.scijava.tool.Tool;
import org.scijava.tool.ToolService;
import org.scijava.tool.event.ToolActivatedEvent;
import org.scijava.tool.event.ToolDeactivatedEvent;
import org.scijava.util.RealCoords;

@Plugin(type=Service.class)
public class DefaultToolService
extends AbstractSingletonService<Tool>
implements ToolService {
    private static final double SEPARATOR_DISTANCE = 10.0;
    @Parameter
    private EventService eventService;
    @Parameter
    private StatusService statusService;
    private Map<String, Tool> alwaysActiveTools;
    private List<Tool> alwaysActiveToolList;
    private Map<String, Tool> tools;
    private List<Tool> toolList;
    private Tool activeTool;

    @Override
    public Tool getTool(String name) {
        Tool alwaysActiveTool = this.alwaysActiveTools().get(name);
        if (alwaysActiveTool != null) {
            return alwaysActiveTool;
        }
        return this.tools().get(name);
    }

    @Override
    public <T extends Tool> T getTool(Class<T> toolClass) {
        for (Tool tool : this.alwaysActiveToolList()) {
            if (!toolClass.isInstance(tool)) continue;
            return (T)((Tool)toolClass.cast(tool));
        }
        for (Tool tool : this.toolList()) {
            if (!toolClass.isInstance(tool)) continue;
            return (T)((Tool)toolClass.cast(tool));
        }
        return null;
    }

    @Override
    public List<Tool> getTools() {
        return this.toolList();
    }

    @Override
    public List<Tool> getAlwaysActiveTools() {
        return this.alwaysActiveToolList();
    }

    @Override
    public Tool getActiveTool() {
        return this.activeTool();
    }

    @Override
    public void setActiveTool(Tool activeTool) {
        if (this.activeTool() == activeTool) {
            return;
        }
        assert (this.activeTool != null);
        if (activeTool == null) {
            throw new IllegalArgumentException("Active tool cannot be null");
        }
        this.activeTool.deactivate();
        this.eventService.publish(new ToolDeactivatedEvent(this.activeTool));
        this.activeTool = activeTool;
        activeTool.activate();
        this.eventService.publish(new ToolActivatedEvent(activeTool));
    }

    @Override
    public boolean isSeparatorNeeded(Tool tool1, Tool tool2) {
        double priority2;
        if (tool1 == null || tool2 == null) {
            return false;
        }
        double priority1 = tool1.getInfo().getPriority();
        return Math.abs(priority1 - (priority2 = tool2.getInfo().getPriority())) >= 10.0;
    }

    @Override
    public void reportRectangle(double x, double y, double w, double h) {
        DecimalFormat f = new DecimalFormat("0.##");
        String fx = f.format(x);
        String fy = f.format(y);
        String fw = f.format(w);
        String fh = f.format(h);
        this.statusService.showStatus("x=" + fx + ", y=" + fy + ", w=" + fw + ", h=" + fh);
    }

    @Override
    public void reportRectangle(RealCoords p1, RealCoords p2) {
        double x = Math.min(p1.x, p2.x);
        double y = Math.min(p1.y, p2.y);
        double w = Math.abs(p2.x - p1.x);
        double h = Math.abs(p2.y - p1.y);
        this.reportRectangle(x, y, w, h);
    }

    @Override
    public void reportLine(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y1 - y2;
        double angle = 57.29577951308232 * Math.atan2(dy, dx);
        double w = Math.abs(x2 - x1);
        double h = Math.abs(y2 - y1);
        double length = Math.sqrt(w * w + h * h);
        DecimalFormat f = new DecimalFormat("0.##");
        String fx = f.format(x2);
        String fy = f.format(y2);
        String fa = f.format(angle);
        String fl = f.format(length);
        this.statusService.showStatus("x=" + fx + ", y=" + fy + ", angle=" + fa + ", length=" + fl);
    }

    @Override
    public void reportLine(RealCoords p1, RealCoords p2) {
        this.reportLine(p1.x, p1.y, p2.x, p2.y);
    }

    @Override
    public void reportPoint(double x, double y) {
        DecimalFormat f = new DecimalFormat("0.##");
        String fx = f.format(x);
        String fy = f.format(y);
        this.statusService.showStatus("x=" + fx + ", y=" + fy);
    }

    @Override
    public void reportPoint(RealCoords p) {
        this.reportPoint(p.x, p.y);
    }

    @Override
    public Class<Tool> getPluginType() {
        return Tool.class;
    }

    @EventHandler
    protected void onEvent(KyPressedEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Tool aTool = this.getActiveTool();
        if (this.eventOk(event, aTool)) {
            aTool.onKeyDown(event);
        }
        for (Tool tool : this.getAlwaysActiveTools()) {
            if (event.isConsumed()) break;
            if (!this.eventOk(event, tool)) continue;
            tool.onKeyDown(event);
        }
    }

    @EventHandler
    protected void onEvent(KyReleasedEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Tool aTool = this.getActiveTool();
        if (this.eventOk(event, aTool)) {
            aTool.onKeyUp(event);
        }
        for (Tool tool : this.getAlwaysActiveTools()) {
            if (event.isConsumed()) break;
            if (!this.eventOk(event, tool)) continue;
            tool.onKeyUp(event);
        }
    }

    @EventHandler
    protected void onEvent(MsPressedEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Tool aTool = this.getActiveTool();
        if (this.eventOk(event, aTool)) {
            aTool.onMouseDown(event);
        }
        for (Tool tool : this.getAlwaysActiveTools()) {
            if (event.isConsumed()) break;
            if (!this.eventOk(event, tool)) continue;
            tool.onMouseDown(event);
        }
    }

    @EventHandler
    protected void onEvent(MsReleasedEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Tool aTool = this.getActiveTool();
        if (this.eventOk(event, aTool)) {
            aTool.onMouseUp(event);
        }
        for (Tool tool : this.getAlwaysActiveTools()) {
            if (event.isConsumed()) break;
            if (!this.eventOk(event, tool)) continue;
            tool.onMouseUp(event);
        }
    }

    @EventHandler
    protected void onEvent(MsClickedEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Tool aTool = this.getActiveTool();
        if (this.eventOk(event, aTool)) {
            aTool.onMouseClick(event);
        }
        for (Tool tool : this.getAlwaysActiveTools()) {
            if (event.isConsumed()) break;
            if (!this.eventOk(event, tool)) continue;
            tool.onMouseClick(event);
        }
    }

    @EventHandler
    protected void onEvent(MsMovedEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Tool aTool = this.getActiveTool();
        if (this.eventOk(event, aTool)) {
            aTool.onMouseMove(event);
        }
        for (Tool tool : this.getAlwaysActiveTools()) {
            if (event.isConsumed()) break;
            if (!this.eventOk(event, tool)) continue;
            tool.onMouseMove(event);
        }
    }

    @EventHandler
    protected void onEvent(MsDraggedEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Tool aTool = this.getActiveTool();
        if (this.eventOk(event, aTool)) {
            aTool.onMouseDrag(event);
        }
        for (Tool tool : this.getAlwaysActiveTools()) {
            if (event.isConsumed()) break;
            if (!this.eventOk(event, tool)) continue;
            tool.onMouseDrag(event);
        }
    }

    @EventHandler
    protected void onEvent(MsWheelEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Tool aTool = this.getActiveTool();
        if (this.eventOk(event, aTool)) {
            aTool.onMouseWheel(event);
        }
        for (Tool tool : this.getAlwaysActiveTools()) {
            if (event.isConsumed()) break;
            if (!this.eventOk(event, tool)) continue;
            tool.onMouseWheel(event);
        }
    }

    private Map<String, Tool> alwaysActiveTools() {
        if (this.alwaysActiveTools == null) {
            this.initAlwaysActiveTools();
        }
        return this.alwaysActiveTools;
    }

    private List<Tool> alwaysActiveToolList() {
        if (this.alwaysActiveToolList == null) {
            this.initAlwaysActiveToolList();
        }
        return this.alwaysActiveToolList;
    }

    private Map<String, Tool> tools() {
        if (this.tools == null) {
            this.initTools();
        }
        return this.tools;
    }

    private List<Tool> toolList() {
        if (this.toolList == null) {
            this.initToolList();
        }
        return this.toolList;
    }

    private Tool activeTool() {
        if (this.activeTool == null) {
            this.initActiveTool();
        }
        return this.activeTool;
    }

    private synchronized void initAlwaysActiveTools() {
        if (this.alwaysActiveTools != null) {
            return;
        }
        HashMap<String, Tool> map = new HashMap<String, Tool>();
        for (Tool tool : this.alwaysActiveToolList()) {
            map.put(tool.getInfo().getName(), tool);
        }
        this.alwaysActiveTools = map;
    }

    private synchronized void initAlwaysActiveToolList() {
        if (this.alwaysActiveToolList != null) {
            return;
        }
        ArrayList<Tool> list = new ArrayList<Tool>();
        for (Tool tool : this.getInstances()) {
            if (!tool.isAlwaysActive()) continue;
            list.add(tool);
        }
        this.alwaysActiveToolList = list;
    }

    private synchronized void initTools() {
        if (this.tools != null) {
            return;
        }
        HashMap<String, Tool> map = new HashMap<String, Tool>();
        for (Tool tool : this.toolList()) {
            map.put(tool.getInfo().getName(), tool);
        }
        this.tools = map;
    }

    private synchronized void initToolList() {
        if (this.toolList != null) {
            return;
        }
        ArrayList<Tool> list = new ArrayList<Tool>();
        for (Tool tool : this.getInstances()) {
            if (tool.isAlwaysActive()) continue;
            list.add(tool);
        }
        this.toolList = list;
    }

    private synchronized void initActiveTool() {
        Tool active;
        if (this.activeTool != null) {
            return;
        }
        Tool rectangle = this.getTool("Rectangle");
        this.activeTool = active = rectangle == null ? new DummyTool() : rectangle;
    }

    private boolean eventOk(DisplayEvent event, Tool tool) {
        if (event.getDisplay() != null) {
            return true;
        }
        return tool.isActiveInAppFrame();
    }
}

