/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.app;

import java.io.File;
import org.scijava.app.App;
import org.scijava.log.LogService;
import org.scijava.plugin.AbstractRichPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.util.AppUtils;
import org.scijava.util.Manifest;
import org.scijava.util.POM;

public abstract class AbstractApp
extends AbstractRichPlugin
implements App {
    @Parameter(required=false)
    private LogService log;
    private POM pom;
    private Manifest manifest;

    @Override
    public String getTitle() {
        return this.getInfo().getName();
    }

    @Override
    public String getVersion() {
        return this.getPOM() == null ? "Unknown" : this.getPOM().getVersion();
    }

    @Override
    public POM getPOM() {
        if (this.pom == null) {
            this.pom = POM.getPOM(this.getClass(), this.getGroupId(), this.getArtifactId());
        }
        return this.pom;
    }

    @Override
    public Manifest getManifest() {
        if (this.manifest == null) {
            this.manifest = Manifest.getManifest(this.getClass());
        }
        return this.manifest;
    }

    @Override
    public String getInfo(boolean mem) {
        String appTitle = this.getTitle();
        String appVersion = this.getVersion();
        String javaVersion = System.getProperty("java.version");
        String osArch = System.getProperty("os.arch");
        long maxMem = Runtime.getRuntime().maxMemory();
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totalMem - freeMem;
        long usedMB = usedMem / 0x100000L;
        long maxMB = maxMem / 0x100000L;
        StringBuilder sb = new StringBuilder();
        sb.append(appTitle + " " + appVersion);
        sb.append("; Java " + javaVersion + " [" + osArch + "]");
        if (mem) {
            sb.append("; " + usedMB + "MB of " + maxMB + "MB");
        }
        return sb.toString();
    }

    @Override
    public String getSystemProperty() {
        return this.getInfo().getName().toLowerCase() + ".dir";
    }

    @Override
    public File getBaseDirectory() {
        return AppUtils.getBaseDirectory(this.getSystemProperty(), this.getClass(), null);
    }

    @Override
    public void about() {
        if (this.log != null) {
            this.log.info(this.getInfo(false));
        }
    }

    @Override
    public void prefs() {
    }

    @Override
    public void quit() {
        this.getContext().dispose();
    }
}

