/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.console.SystemPropertyArgument;

public class SystemPropertyArgumentTest {
    @Test
    public void testSystemProperties() {
        this.assertPropertySet("foo", "bar");
        this.assertPropertySet("prop.with.dots", "true");
        this.assertPropertySet("prop-with-dashes", "whiz");
        this.assertPropertySet("prop_with_underscores", "bang");
        this.assertPropertySet("empty.value", "");
        this.assertPropertySet("unspecified.value", null);
        this.assertPropertySet("_-_", "legal");
        this.assertPropertySet("-_-", "also legal");
    }

    private void assertPropertySet(String key, String value) {
        SystemPropertyArgument spa = new SystemPropertyArgument();
        LinkedList<String> args = new LinkedList<String>();
        args.add(value == null ? "-D" + key : "-D" + key + "=" + value);
        Assert.assertTrue((boolean)spa.supports(args));
        Assert.assertNull((Object)System.getProperty(key));
        spa.handle(args);
        Assert.assertTrue((boolean)args.isEmpty());
        Assert.assertEquals((Object)(value == null ? "" : value), (Object)System.getProperty(key));
    }
}

