/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.scijava.AbstractBasicDetails;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.module.MethodCallException;
import org.scijava.module.MethodRef;
import org.scijava.module.Module;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.util.ClassUtils;
import org.scijava.util.ConversionUtils;
import org.scijava.util.NumberUtils;
import org.scijava.util.Prefs;
import org.scijava.util.StringMaker;

public abstract class AbstractModuleItem<T>
extends AbstractBasicDetails
implements ModuleItem<T> {
    private final ModuleInfo info;
    private MethodRef initializerRef;
    private MethodRef validaterRef;
    private MethodRef callbackRef;

    public AbstractModuleItem(ModuleInfo info) {
        this.info = info;
    }

    @Override
    public String toString() {
        StringMaker sm = new StringMaker();
        sm.append("label", this.getLabel());
        sm.append("description", this.getDescription());
        sm.append("visibility", (Object)this.getVisibility(), (Object)ItemVisibility.NORMAL);
        sm.append("required", this.isRequired());
        sm.append("persisted", this.isPersisted());
        sm.append("persistKey", this.getPersistKey());
        sm.append("callback", this.getCallback());
        sm.append("widgetStyle", this.getWidgetStyle());
        sm.append("default", this.getDefaultValue());
        sm.append("min", this.getMinimumValue());
        sm.append("max", this.getMaximumValue());
        sm.append("softMin", this.getSoftMinimum());
        sm.append("softMax", this.getSoftMaximum());
        sm.append("stepSize", this.getStepSize(), NumberUtils.toNumber("1", this.getType()));
        sm.append("columnCount", this.getColumnCount(), 6);
        sm.append("choices", this.getChoices());
        return this.getName() + ": " + sm.toString();
    }

    @Override
    public ModuleInfo getInfo() {
        return this.info;
    }

    @Override
    public Type getGenericType() {
        return this.getType();
    }

    @Override
    public ItemIO getIOType() {
        return ItemIO.INPUT;
    }

    @Override
    public boolean isInput() {
        ItemIO ioType = this.getIOType();
        return ioType == ItemIO.INPUT || ioType == ItemIO.BOTH;
    }

    @Override
    public boolean isOutput() {
        ItemIO ioType = this.getIOType();
        return ioType == ItemIO.OUTPUT || ioType == ItemIO.BOTH;
    }

    @Override
    public ItemVisibility getVisibility() {
        return ItemVisibility.NORMAL;
    }

    @Override
    public boolean isAutoFill() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    public String getPersistKey() {
        return null;
    }

    @Override
    @Deprecated
    public T loadValue() {
        String sValue;
        if (!this.isPersisted()) {
            return null;
        }
        String persistKey = this.getPersistKey();
        if (persistKey == null || persistKey.isEmpty()) {
            Class<?> prefClass = this.getDelegateClass();
            String prefKey = this.getName();
            sValue = Prefs.get(prefClass, prefKey);
        } else {
            sValue = Prefs.get(persistKey);
        }
        if (sValue == null) {
            return null;
        }
        return ConversionUtils.convert((Object)sValue, this.getType());
    }

    @Override
    @Deprecated
    public void saveValue(T value) {
        String sValue;
        if (!this.isPersisted()) {
            return;
        }
        String string = sValue = value == null ? "" : value.toString();
        if (!ConversionUtils.canConvert((Object)sValue, this.getType())) {
            return;
        }
        String persistKey = this.getPersistKey();
        if (persistKey == null || persistKey.isEmpty()) {
            Class<?> prefClass = this.getDelegateClass();
            String prefKey = this.getName();
            Prefs.put(prefClass, prefKey, sValue);
        } else {
            Prefs.put(persistKey, sValue);
        }
    }

    @Override
    public String getInitializer() {
        return null;
    }

    @Override
    public void initialize(Module module) throws MethodCallException {
        Object delegateObject = module.getDelegateObject();
        if (this.initializerRef == null) {
            this.initializerRef = new MethodRef(delegateObject.getClass(), this.getInitializer(), new Class[0]);
        }
        this.initializerRef.execute(module.getDelegateObject(), new Object[0]);
    }

    @Override
    public String getValidater() {
        return null;
    }

    @Override
    public void validate(Module module) throws MethodCallException {
        Object delegateObject = module.getDelegateObject();
        if (this.validaterRef == null) {
            this.validaterRef = new MethodRef(delegateObject.getClass(), this.getValidater(), new Class[0]);
        }
        this.validaterRef.execute(module.getDelegateObject(), new Object[0]);
    }

    @Override
    public String getCallback() {
        return null;
    }

    @Override
    public void callback(Module module) throws MethodCallException {
        Object delegateObject = module.getDelegateObject();
        if (this.callbackRef == null) {
            this.callbackRef = new MethodRef(delegateObject.getClass(), this.getCallback(), new Class[0]);
        }
        this.callbackRef.execute(delegateObject, new Object[0]);
    }

    @Override
    public String getWidgetStyle() {
        return null;
    }

    @Override
    public T getDefaultValue() {
        return null;
    }

    @Override
    public T getMinimumValue() {
        return null;
    }

    @Override
    public T getMaximumValue() {
        return null;
    }

    @Override
    public T getSoftMinimum() {
        return this.getMinimumValue();
    }

    @Override
    public T getSoftMaximum() {
        return this.getMaximumValue();
    }

    @Override
    public Number getStepSize() {
        if (!ClassUtils.isNumber(this.getType())) {
            return null;
        }
        return NumberUtils.toNumber("1", this.getType());
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public List<T> getChoices() {
        T[] choices = this.getType().getEnumConstants();
        return choices == null ? null : Arrays.asList(choices);
    }

    @Override
    public T getValue(Module module) {
        Object result = this.isInput() ? module.getInput(this.getName()) : (this.isOutput() ? module.getOutput(this.getName()) : null);
        Object value = result;
        return (T)value;
    }

    @Override
    public void setValue(Module module, T value) {
        if (this.isInput()) {
            module.setInput(this.getName(), value);
        }
        if (this.isOutput()) {
            module.setOutput(this.getName(), value);
        }
    }

    protected Class<?> getDelegateClass() {
        try {
            return this.info.loadDelegateClass();
        }
        catch (ClassNotFoundException exc) {
            throw new IllegalStateException(exc);
        }
    }
}

