/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import org.scijava.log.LogLevel;
import org.scijava.log.LogSource;

public class LogMessage {
    private final LogSource source;
    private final int level;
    private final String message;
    private final Throwable throwable;
    private final Date time;
    private Collection<Object> attachments;

    public LogMessage(LogSource source, int level, Object message, Throwable throwable) {
        this.source = source;
        this.attachments = null;
        this.level = level;
        this.message = message == null ? null : message.toString();
        this.throwable = throwable;
        this.time = new Date();
    }

    public LogMessage(LogSource source, int level, Object msg) {
        this(source, level, msg, null);
    }

    public LogSource source() {
        return this.source;
    }

    public int level() {
        return this.level;
    }

    public String text() {
        return this.message;
    }

    public Throwable throwable() {
        return this.throwable;
    }

    public Date time() {
        return this.time;
    }

    public Collection<Object> attachments() {
        return Collections.unmodifiableCollection(this.attachments);
    }

    public void attach(Object value) {
        if (this.attachments == null) {
            this.attachments = new LinkedList<Object>();
        }
        this.attachments.add(value);
    }

    public String toString() {
        return LogMessage.format(this);
    }

    public static String format(LogMessage message) {
        StringWriter sw = new StringWriter();
        PrintWriter printer = new PrintWriter(sw);
        printer.print("[" + message.time() + "] ");
        printer.print("[" + LogLevel.prefix(message.level()) + "] ");
        printer.print("[" + message.source() + "] ");
        printer.println(message.text());
        if (message.throwable() != null) {
            message.throwable().printStackTrace(printer);
        }
        return sw.toString();
    }
}

