/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.console.AbstractConsoleArgument;
import org.scijava.console.ConsoleArgument;
import org.scijava.console.ConsoleService;
import org.scijava.console.OutputEvent;
import org.scijava.console.OutputListener;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

public class ConsoleServiceTest {
    private ConsoleService consoleService;

    @Before
    public void setUp() {
        this.consoleService = (ConsoleService)new Context().service(ConsoleService.class);
    }

    @After
    public void tearDown() {
        this.consoleService.context().dispose();
    }

    @Test
    public void testProcessArgs() {
        Assert.assertFalse((boolean)((FooArgument)this.consoleService.getInstance(FooArgument.class)).argsHandled);
        this.consoleService.processArgs(new String[]{"--foo", "--bar"});
        Assert.assertTrue((boolean)((FooArgument)this.consoleService.getInstance(FooArgument.class)).argsHandled);
    }

    @Test
    public void testInfiniteLoopAvoidance() {
        Assert.assertFalse((boolean)((BrokenArgument)this.consoleService.getInstance(BrokenArgument.class)).argsHandled);
        this.consoleService.processArgs(new String[]{"--broken"});
        Assert.assertTrue((boolean)((BrokenArgument)this.consoleService.getInstance(BrokenArgument.class)).argsHandled);
    }

    @Test
    public void testOutputListeners() throws InterruptedException, ExecutionException {
        ThreadService threadService = (ThreadService)this.consoleService.context().service(ThreadService.class);
        String stdoutBefore = "hoc";
        String stderrBefore = "us-";
        String stdoutGlobal = "poc";
        String stderrGlobal = "us-";
        String stdoutLocal = "abra";
        String stderrLocal = "-cad";
        String stdoutAfter = "ave";
        String stderrAfter = "rs-";
        ArrayList events = new ArrayList();
        OutputTracker outputListener = new OutputTracker(events);
        Printer r = new Printer("abra", "-cad");
        System.out.print("hoc");
        System.err.print("us-");
        this.consoleService.addOutputListener((OutputListener)outputListener);
        System.out.print("poc");
        System.err.print("us-");
        threadService.run((Runnable)r).get();
        this.consoleService.removeOutputListener((OutputListener)outputListener);
        threadService.run((Runnable)r).get();
        System.out.print("ave");
        System.err.print("rs-");
        Assert.assertEquals((long)4L, (long)events.size());
        this.assertOutputEvent(OutputEvent.Source.STDOUT, "poc", false, (OutputEvent)events.get(0));
        this.assertOutputEvent(OutputEvent.Source.STDERR, "us-", false, (OutputEvent)events.get(1));
        this.assertOutputEvent(OutputEvent.Source.STDOUT, "abra", true, (OutputEvent)events.get(2));
        this.assertOutputEvent(OutputEvent.Source.STDERR, "-cad", true, (OutputEvent)events.get(3));
    }

    @Test
    public void testMultipleContextOutput() throws InterruptedException, ExecutionException {
        Context c1 = this.consoleService.context();
        Context c2 = new Context();
        ConsoleService cs1 = this.consoleService;
        ConsoleService cs2 = (ConsoleService)c2.service(ConsoleService.class);
        ThreadService ts1 = (ThreadService)c1.service(ThreadService.class);
        ThreadService ts2 = (ThreadService)c2.service(ThreadService.class);
        ArrayList events1 = new ArrayList();
        cs1.addOutputListener((OutputListener)new OutputTracker(events1));
        ArrayList events2 = new ArrayList();
        cs2.addOutputListener((OutputListener)new OutputTracker(events2));
        String globalOut = "and";
        String globalErr = "-zo";
        String c1RunOut = "mbi";
        String c1RunErr = "es-";
        String c2RunOut = "sha";
        String c2RunErr = "zam";
        String c1InvokeOut = "-cl";
        String c1InvokeErr = "eop";
        String c2InvokeOut = "atr";
        String c2InvokeErr = "a";
        System.out.print("and");
        System.err.print("-zo");
        ts1.run((Runnable)new Printer("mbi", "es-")).get();
        ts2.run((Runnable)new Printer("sha", "zam")).get();
        ts1.run((Runnable)new EDTPrinter(ts1, "-cl", "eop")).get();
        ts2.run((Runnable)new EDTPrinter(ts2, "atr", "a")).get();
        c2.dispose();
        Assert.assertEquals((long)6L, (long)events1.size());
        this.assertOutputEvent(OutputEvent.Source.STDOUT, "and", false, (OutputEvent)events1.get(0));
        this.assertOutputEvent(OutputEvent.Source.STDERR, "-zo", false, (OutputEvent)events1.get(1));
        this.assertOutputEvent(OutputEvent.Source.STDOUT, "mbi", true, (OutputEvent)events1.get(2));
        this.assertOutputEvent(OutputEvent.Source.STDERR, "es-", true, (OutputEvent)events1.get(3));
        this.assertOutputEvent(OutputEvent.Source.STDOUT, "-cl", true, (OutputEvent)events1.get(4));
        this.assertOutputEvent(OutputEvent.Source.STDERR, "eop", true, (OutputEvent)events1.get(5));
        Assert.assertEquals((long)6L, (long)events2.size());
        this.assertOutputEvent(OutputEvent.Source.STDOUT, "and", false, (OutputEvent)events2.get(0));
        this.assertOutputEvent(OutputEvent.Source.STDERR, "-zo", false, (OutputEvent)events2.get(1));
        this.assertOutputEvent(OutputEvent.Source.STDOUT, "sha", true, (OutputEvent)events2.get(2));
        this.assertOutputEvent(OutputEvent.Source.STDERR, "zam", true, (OutputEvent)events2.get(3));
        this.assertOutputEvent(OutputEvent.Source.STDOUT, "atr", true, (OutputEvent)events2.get(4));
        this.assertOutputEvent(OutputEvent.Source.STDERR, "a", true, (OutputEvent)events2.get(5));
    }

    private void assertOutputEvent(OutputEvent.Source source, String output, boolean contextual, OutputEvent event) {
        Assert.assertEquals((Object)source, (Object)event.getSource());
        Assert.assertEquals((Object)output, (Object)event.getOutput());
        Assert.assertEquals((Object)contextual, (Object)event.isContextual());
    }

    private static class EDTPrinter
    implements Runnable {
        private final ThreadService ts;
        private final Printer p;

        private EDTPrinter(ThreadService ts, String out, String err) {
            this.ts = ts;
            this.p = new Printer(out, err);
        }

        @Override
        public void run() {
            try {
                this.ts.invoke((Runnable)this.p);
            }
            catch (InvocationTargetException exc) {
                throw new RuntimeException(exc);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    private static class Printer
    implements Runnable {
        private final String out;
        private final String err;

        private Printer(String out, String err) {
            this.out = out;
            this.err = err;
        }

        @Override
        public void run() {
            System.out.print(this.out);
            System.err.print(this.err);
        }
    }

    private static class OutputTracker
    implements OutputListener {
        private final Collection<OutputEvent> events;

        private OutputTracker(Collection<OutputEvent> events) {
            this.events = events;
        }

        public void outputOccurred(OutputEvent event) {
            this.events.add(event);
        }
    }

    @Plugin(type=ConsoleArgument.class)
    public static class BrokenArgument
    extends AbstractConsoleArgument {
        private boolean argsHandled;

        public BrokenArgument() {
            super(1, new String[]{"--broken"});
        }

        public void handle(LinkedList<String> args) {
            this.argsHandled = true;
        }
    }

    @Plugin(type=ConsoleArgument.class, priority=100.0)
    public static class FooArgument
    extends AbstractConsoleArgument {
        private boolean argsHandled;

        public FooArgument() {
            super(1, new String[]{"--foo"});
        }

        public void handle(LinkedList<String> args) {
            Assert.assertNotNull(args);
            Assert.assertEquals((long)2L, (long)args.size());
            Assert.assertEquals((Object)"--foo", (Object)args.get(0));
            Assert.assertEquals((Object)"--bar", (Object)args.get(1));
            args.clear();
            this.argsHandled = true;
        }
    }
}

