/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class DataHandles {
    private static Method utfMethod;

    private DataHandles() {
    }

    public static int writeUTF(String str, DataOutput out) throws IOException {
        try {
            return (Integer)DataHandles.utfMethod().invoke(null, str, out);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exc) {
            throw new IllegalStateException("Cannot invoke DataOutputStream.writeUTF(String, DataOutput)", exc);
        }
    }

    private static Method utfMethod() {
        if (utfMethod == null) {
            DataHandles.initUTFMethod();
        }
        return utfMethod;
    }

    private static synchronized void initUTFMethod() {
        if (utfMethod != null) {
            return;
        }
        try {
            Method m = DataOutputStream.class.getDeclaredMethod("writeUTF", String.class, DataOutput.class);
            m.setAccessible(true);
            utfMethod = m;
        }
        catch (NoSuchMethodException | SecurityException exc) {
            throw new IllegalStateException("No usable DataOutputStream.writeUTF(String, DataOutput)", exc);
        }
    }
}

