/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.handle.DataHandleTest;
import org.scijava.io.handle.FileHandle;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;

public class FileHandleTest
extends DataHandleTest {
    @Override
    public Class<? extends DataHandle<?>> getExpectedHandleType() {
        return FileHandle.class;
    }

    @Override
    public Location createLocation() throws IOException {
        File tmpFile = File.createTempFile("FileHandleTest", "test-file");
        tmpFile.deleteOnExit();
        this.populateData(new FileOutputStream(tmpFile));
        return new FileLocation(tmpFile);
    }

    @Test
    public void testExists() throws IOException {
        Context ctx = new Context();
        DataHandleService dhs = (DataHandleService)ctx.service(DataHandleService.class);
        File nonExistentFile = File.createTempFile("FileHandleTest", "nonexistent-file");
        Assert.assertTrue((boolean)nonExistentFile.delete());
        Assert.assertFalse((boolean)nonExistentFile.exists());
        FileLocation loc = new FileLocation(nonExistentFile);
        DataHandle handle = (DataHandle)dhs.create((Object)loc);
        Assert.assertTrue((boolean)(handle instanceof FileHandle));
        Assert.assertFalse((boolean)handle.exists());
        Assert.assertEquals((long)-1L, (long)handle.length());
        handle.writeBoolean(true);
        Assert.assertTrue((boolean)handle.exists());
        Assert.assertEquals((long)1L, (long)handle.length());
        Assert.assertTrue((boolean)nonExistentFile.delete());
    }

    @Test
    public void testNotCreatedByClose() throws IOException {
        Context ctx = new Context();
        DataHandleService dhs = (DataHandleService)ctx.service(DataHandleService.class);
        File nonExistentFile = File.createTempFile("FileHandleTest", "nonexistent-file");
        Assert.assertTrue((boolean)nonExistentFile.delete());
        Assert.assertFalse((boolean)nonExistentFile.exists());
        FileLocation loc = new FileLocation(nonExistentFile);
        DataHandle handle = (DataHandle)dhs.create((Object)loc);
        Assert.assertTrue((boolean)(handle instanceof FileHandle));
        Assert.assertFalse((boolean)handle.exists());
        handle.close();
        Assert.assertFalse((boolean)nonExistentFile.exists());
    }
}

